// @Prolog: #include "stdinc.h"
// @Prolog: #include "ResourceManager.h"
// @Strings: std::string dcpp::ResourceManager::strings[]
// @Names: std::string dcpp::ResourceManager::names[]

enum Strings { // @DontAdd
	ACCEPTED_DISCONNECTS, // "Accepted Disconnects"
	ACCEPTED_TIMEOUTS, // "Accepted Timeouts"
	ACTIVE, // "Active"
	ACTIVE_SEARCH_STRING, // "Enabled / Search String"
	ADD, // "&Add"
	ADD_AS_SOURCE, // "Add as source"
	ADD_FINISHED_INSTANTLY, // "Add finished files to share instantly (if shared)"
	ADD_TO_FAVORITES, // "Add To Favorites"
	ADDED, // "Added"
	ADL_SEARCH, // "Automatic Directory Listing Search"
	ADLS_DESTINATION, // "Destination Directory"
	ADLS_DISCARD, // "Discard"
	ADLS_DOWNLOAD, // "Download Matches"
	ADLS_ENABLED, // "Enabled"
	ADLS_FULL_PATH, // "Full Path"
	ADLS_PROPERTIES, // "ADLSearch Properties"
	ADLS_SEARCH_STRING, // "Search String"
	ADLS_SIZE_MAX, // "Max FileSize"
	ADLS_SIZE_MIN, // "Min FileSize"
	ADLS_TYPE, // "Search Type"
	ADLS_UNITS, // "Size Type"
	ALL, // "All"
	ALL_DOWNLOAD_SLOTS_TAKEN, // "All download slots taken"
	ALL_FILE_SLOTS_TAKEN, // "All file slots taken"
	ALL_USERS_OFFLINE, // "All %d users offline"
	ALLOW_NAT_TRAVERSAL, // "Allow NAT Traversal for connections with passive users with NMDC (disabling can resolve connectivity issues with cerain hub softwares)"
	ALTERNATES_SEND, // "Searching TTH alternates for:"
	ANTI_PASSIVE_SEARCH, // "-- WARNING --\r\n-- You are in active mode, but have activated passive search. --\r\n-- Don't use passive search if you have search results without this option --\r\n-- because you don't get search result from passive clients !!! --\r\n-- Turn it off in settings => ApexDC++ => Always use Passive Mode for Search --\r\n"
	ANY, // "Any"
	AT_LEAST, // "At least"
	AT_MOST, // "At most"
	AUDIO, // "Audio"
	AUTO, // "Auto"
	AUTO_CONNECT, // "Auto connect / Name"
	AUTO_GRANT, // "Auto grant slot / Nick"
	AUTOMATIC, // "Automatic"
	AVERAGE, // "Average/s:"
	AVERAGE_UPLOAD, // "Upload Speed"
	AWAY, // "AWAY"
	AWAY_MODE_OFF, // "Away mode off"
	AWAY_MODE_ON, // "Away mode on:"
	LIMITER_OFF, // "Transfer limiter disabled"
	LIMITER_ON, // "Transfer limiter enabled"
	B, // "B"
	BALLOON_POPUPS, // "Balloon popups"
	BITZI_LOOKUP, // "Bitzi Lookup"
	BOTH_USERS_OFFLINE, // "Both users offline"
	BROWSE, // "Browse..."
	BROWSE_ACCEL, // "&Browse..."
	BROWSE_FILE_LIST, // "Browse file list"
	BUMPED, // "Bumped"
	CANCEL, // "Cancel"
	CERTIFICATE_GENERATED, // "Generated new TLS certificate"
	CERTIFICATE_NOT_TRUSTED, // "Certificate not trusted"
	CERTIFICATE_GENERATION_FAILED, // "TLS disabled, failed to generate certificate:"
	CHEATING_DESCRIPTION, // "Cheating Description"
	CID, // "CID"
	CIPHER, // "Cipher"
	CLEAR_CHAT, // "Clear chat"
	CLIENTID, // "Client"
	CLOSE, // "Close"
	CLOSE_CONNECTION, // "Close connection"
	COLLAPSE_ALL, // "Collapse All"
	COLOR_FAST, // "User with fireball"
	COLOR_OP, // "User is OP"
	COLOR_PASIVE, // "Passive user"
	COLOR_SERVER, // "User with server"
	COMMAND_TOO_LONG, // "Maximum command length exceeded"
	COMMENT, // "Comment"
	COMPRESSED, // "Compressed"
	COMPRESSION_ERROR, // "Error during compression"
	CONFIGURE, // "&Configure"
	CONFIGURED_HUB_LISTS, // "Configured Public Hub Lists"
	CONNECT, // "&Connect"
	CONNECT_ALL, // "Connect to all users"
	CONNECT_FAVUSER_HUB, // "Connect to hub"
	CONNECTED, // "Connected"
	CONNECTING, // "Connecting..."
	CONNECTING_FORCED, // "Connecting (forced)..."
	CONNECTING_TO, // "Connecting to"
	CONNECTION, // "Connection"
	CONNECTION_CLOSED, // "Connection closed"
	CONNECTION_DETECTION, // "Enable automatic incoming connection type detection"
	CONNECTION_ERROR, // "Connection error"
	CONNECTION_TIMEOUT, // "Connection timeout"
	CONTINUE, // "Continue"
	COPY, // "Copy"
	COPY_HUB, // "Copy address to clipboard"
	COPY_LINE, // "Copy actual line"
	COPY_MAGNET_LINK, // "Copy magnet link to clipboard"
	COPY_NICK, // "Copy nick"
	COPY_URL, // "Copy URL"
	COULD_NOT_OPEN_TARGET_FILE, // "Could not open target file:"
	COUNT, // "Count"
	COUNTRY, // "Country"
	CREATING_HASH, // "Hashing"
	CURRENT_VERSION, // "Current version"
	DATA_RETRIEVED, // "Data retrieved"
	DECOMPRESSION_ERROR, // "Error during decompression"
	DEFAULT, // "Default"
	DESCRIPTION, // "Description"
	DESTINATION, // "Destination"
	DIRECTORY, // "Directory"
	DIRECTORY_ADD_ERROR, // "Directory or directory name already exists"
	DIRECTORY_IS_HIDDEN, // "Directory is hidden"
	DISABLE_SOUNDS, // "Disable sounds"
	DISABLED, // "Disabled"
	DISCONNECT_ALL, // "Disconnect all users"
	DISCONNECT_USER, // "Disconnect user(s)"
	DISCONNECTED, // "Disconnected"
	DISCONNECTED_USER, // "Disconnected user leaving the hub:"
	DOCUMENT, // "Document"
	DONE, // "Done"
	DONT_ADD_SEGMENT_TEXT, // "Don't begin new segment if overall file speed is over"
	DONT_REMOVE_SLASH_PASSWORD, // "Don't remove /password before your password"
	DONT_SHARE_TEMP_DIRECTORY, // "The temporary download directory cannot be shared"
	DOWNLOAD, // "Download"
	DOWNLOAD_FAILED, // "Download failed:"
	DOWNLOAD_FINISHED_IDLE, // "Download finished, idle..."
	DOWNLOAD_QUEUE, // "Download queue"
	DOWNLOAD_STARTING, // "Download starting..."
	DOWNLOAD_TO, // "Download to..."
	DOWNLOAD_WHOLE_DIR, // "Download whole directory"
	DOWNLOAD_WHOLE_DIR_TO, // "Download whole directory to..."
	DOWNLOAD_WITH_PRIORITY, // "Download with priority..."
	DOWNLOADED, // "Downloaded"
	DOWNLOADED_BYTES, // "Downloaded %s (%.01f%%) in %s"
	DOWNLOADED_FROM, // "downloaded from"
	DOWNLOADED_PARTS, // "Downloaded parts"
	DOWNLOADING, // "Downloading..."
	DOWNLOADING_HUB_LIST, // "Downloading public hub list..."
	DOWNLOADING_LIST, // "Downloading list..."
	DOWNLOADS_RUNNING, // "Downloads running, please disconnect them"
	DUPLICATE_SOURCE, // "Duplicate source"
	EB, // "EiB"
	EDIT_ACCEL, // "&Edit"
	EMAIL, // "E-Mail"
	ENABLE_LIMITING, // "Enable Transfer Rate Limiting"
	ENABLE_MULTI_SOURCE, // "Enable segmented downloads"
	ENABLED, // "Enabled"
	ENTER_NICK, // "Please enter a nickname in the settings dialog!"
	ENTER_PASSWORD, // "Please enter a password"
	ENTER_SEARCH_STRING, // "Enter search string"
	ERROR_CREATING_HASH_DATA_FILE, // "Error creating hash data file:"
	ERROR_CREATING_REGISTRY_KEY_ADC, // "Error creating adc registry key"
	ERROR_CREATING_REGISTRY_KEY_DCHUB, // "Error creating dchub registry key"
	ERROR_CREATING_REGISTRY_KEY_MAGNET, // "Error creating magnet registry key"
	ERROR_HASHING, // "Error hashing"
	ERROR_SAVING_HASH, // "Error saving hash data:"
	ERRORS, // "Errors"
	EXACT_SHARED, // "Exact Share"
	EXACT_SIZE, // "Exact size"
	EXECUTABLE, // "Executable"
	EXPAND_ALL, // "Expand All"
	EXPANDED_RESULTS, // "Expand search results"
	EXTRA_HUB_SLOTS, // "Slot ratio"
	EXTRA_SLOTS_SET, // "Extra slots set"
	FAILED_TO_SHUTDOWN, // "Failed to shutdown!"
	FAILED_TO_LOAD_CERTIFICATE, // "Failed to load certificate file"
	FAILED_TO_LOAD_PRIVATE_KEY, // "Failed to load private key"
	FAV_JOIN_SHOWING_OFF, // "Join/part of favorite users showing off"
	FAV_JOIN_SHOWING_ON, // "Join/part of favorite users showing on"
	FAVORITE_DIR_NAME, // "Favorite name"
	FAVORITE_DIR_NAME_LONG, // "Under what name you see the directory"
	FAVORITE_HUB_ADDED, // "Favorite hub added"
	FAVORITE_HUB_ALREADY_EXISTS, // "Hub already exists as a favorite"
	FAVORITE_HUB_DOES_NOT_EXIST, // "This hub is not a favorite hub"
	FAVORITE_HUB_IDENTITY, // "Identification (leave blank for defaults)"
	FAVORITE_HUB_PROPERTIES, // "Favorite Hub Properties"
	FAVORITE_HUB_REMOVED, // "Favorite hub removed"
	FAVORITE_HUBS, // "Favorite Hubs"
	FAVORITE_USER_ADDED, // "Favorite user added"
	FAVORITE_USERS, // "Favorite Users"
	FAVUSER_ONLINE, // "Favorite user online"
	FILE, // "File"
	FILE_ALREADY_FINISHED, // "File is already finished"
	FILE_LIST, // "file list"
	FILE_LIST_DIFF, // "Subtract list"
	FILE_LIST_REFRESH_FAILED, // "File list refresh failed:"
	FILE_LIST_REFRESH_FINISHED, // "File list refresh finished"
	FILE_LIST_REFRESH_IN_PROGRESS, // "File list refresh in progress, please wait for it to finish before trying to refresh again"
	FILE_LIST_REFRESH_INITIATED, // "File list refresh initiated"
	FILE_NOT_AVAILABLE, // "File not available"
	FILE_TYPE, // "File type"
	FILE_WITH_DIFFERENT_SIZE, // "A file with a different size already exists in the queue"
	FILE_WITH_DIFFERENT_TTH, // "A file with different TTH root already exists in the queue"
	FILENAME, // "Filename"
	FILES, // "Files"
	FILES_LEFT, // "files left"
	FILES_PER_HOUR, // "files/h"
	FILTER, // "F&ilter"
	FILTERED, // "Filtered"
	FIND, // "Find"
	FINISHED_DOWNLOAD, // "Download finished: %s From: %s "
	FINISHED_DOWNLOADS, // "Finished Downloads"
	FINISHED_UPLOAD, // "Upload finished: %s To: %s"
	FINISHED_UPLOADS, // "Finished Uploads"
	FOLDER, // "Folder"
	FORBIDDEN, // "Forbidden"
	FORBIDDEN_FILE_NOT_SHARED, // "Forbidden file will not be shared: "
	FORCE_ATTEMPT, // "Force attempt"
	GB, // "GiB"
	GENERATE_CERTIFICATES, // "Generate certificates"
	GET_FILE_LIST, // "Get file list"
	GO_TO_DIRECTORY, // "Go to directory"
	GRANT_EXTRA_SLOT, // "Grant extra slot (10 min)"
	GRANT_EXTRA_SLOT_DAY, // "Grant extra slot (day)"
	GRANT_EXTRA_SLOT_HOUR, // "Grant extra slot (hour)"
	GRANT_EXTRA_SLOT_WEEK, // "Grant extra slot (week)"
	GRANT_SLOTS_MENU, // "Extra Slots"
	GROUP, // "Group"
	GROUP_SEARCH_RESULTS, // "Group search results by TTH"
	HASH_DATABASE, // "Hash database"
	HASH_PROGRESS, // "Creating file index..."
	HASH_PROGRESS_BACKGROUND, // "Run in background"
	HASH_PROGRESS_STATS, // "Statistics"
	HASH_PROGRESS_TEXT, // "Please wait while ApexDC++ indexes your files (they won't be shared until they've been indexed)..."
	HASH_READ_FAILED, // "Unable to read hash data file"
	HASH_REBUILT, // "Hash database rebuilt"
	HASHING_FAILED, // "Hashing failed:"
	HASHING_FINISHED, // "Finished hashing:"
	HIBERNATE, // "Hibernate"
	HIGH, // "High"
	HIGHEST, // "Highest"
	HISTORY, // "History"
	HIT_COUNT, // "Hits"
	HIT_RATIO, // "Hit Ratio:"
	HITS, // "Hits:"
	HUB, // "Hub"
	HUB_ADDRESS, // "Address"
	HUB_CONNECTED, // "Hub connected"
	HUB_DISCONNECTED, // "Hub disconnected"
	HUB_LIST, // "Hublist"
	HUB_LIST_DOWNLOADED, // "Hub list downloaded..."
	HUB_LIST_EDIT, // "Edit the hublist"
	HUB_LIST_LOADED_FROM_CACHE, // "Hub list loaded from cache..."
	HUB_NAME, // "Name"
	HUB_SEGMENTS, // "Hub / Segments"
	HUB_TOPIC, // "Hub Topic :"
	HUB_USERS, // "Users"
	HUBLIST_CACHE_CORRUPTED, // "Cached hub list is corrupted or unsupported..."
	HUBLIST_DOWNLOAD_CORRUPTED, // "Downloaded hub list is corrupted or unsupported..."
	HUBS, // "Hubs"
	CHATDBLCLICKACTION, // "Nick (chat) action:"
	CHEATING_USER, // "Cheating user found"
	CHECK_0BYTE_SHARE, // "zero bytes real size"
	CHECK_FILELIST, // "Check File List"
	CHECK_FORBIDDEN, // "Sharing %[userAL] forbidden files including %[userAI], comment: %[userAC]"
	CHECK_INFLATED, // "filelist was inflated %s times"
	CHECK_MISMATCHED_SHARE_SIZE, // "Mismatched share size -"
	CHECK_ON_CONNECT, // "Check user on join"
	CHECK_SHOW_REAL_SHARE, // ", stated size = %[shareshort], real size = %[realshareformat]"
	CHOOSE_FOLDER, // "Choose folder"
	IGNORE_TTH_SEARCHES, // "Ignore TTH searches"
	IGNORE_USER, // "Ignore User"
	IGNORED_MESSAGE, // "Ignored message:"
	INCOMPLETE_FAV_HUB, // "Hub address cannot be empty."
	INTEGRITY_CHECK, // "Integrity check: %s (%s)"
	INVALID_LISTNAME, // "Invalid file list name"
	INVALID_NUMBER_OF_SLOTS, // "Invalid number of slots"
	INVALID_SIZE, // "Invalid size"
	INVALID_TARGET_FILE, // "Invalid target file (missing directory, check default download directory setting)"
	INVALID_TREE, // "Full tree does not match TTH root"
	IP, // "Ip:"
	IP_BARE, // "Ip"
	ITEMS, // "Items"
	JOIN_SHOWING_OFF, // "Join/part showing off"
	JOIN_SHOWING_ON, // "Join/part showing on"
	JOINS, // "Joins:"
	KB, // "KiB"
	KBPS, // "KiB/s"
	KEEP_FINISHED_FILES, // "Keep finished files in the queue"
	KICK_USER, // "Kick user(s)"
	KICK_USER_FILE, // "Kick user(s) with filename"
	LAST_HUB, // "Hub (last seen on if offline)"
	LAST_CHANGE, // "Last change:"
	LAST_SEEN, // "Time last seen"
	LATEST_VERSION, // "Latest version"
	LEFT, // "left"
	LEFT_COLOR, // "Left color"
	LIB_CRASH, // "Application ""%s"" caused an unhandled exception in ApexDC++. Please uninstall it, upgrade it or use an alternate product."
	LIMIT, // "Upload Limit"
	LOADED_FILE_LIST, // "File list loaded."
	LOADING, // "Loading ApexDC++, please wait..."
	LOADING_FILE_LIST, // "Loading file list, this may take a while if the list is large."
	LOCK, // "Lock"
	LOG_OFF, // "Log off"
	LOW, // "Low"
	LOWEST, // "Lowest"
	MAGNET_ASK, // "Ask for Magnet action"
	MAGNET_DLG_FILE, // "Filename:"
	MAGNET_DLG_HASH, // "File Hash:"
	MAGNET_DLG_NOTHING, // "Do nothing"
	MAGNET_DLG_QUEUE, // "Add this file to your download queue"
	MAGNET_DLG_REMEMBER, // "Do the same action next time without asking"
	MAGNET_DLG_SEARCH, // "Start a search for this file"
	MAGNET_DLG_SIZE, // "File Size:"
	MAGNET_DLG_TEXT_BAD, // "A MAGNET link was given to ApexDC++, but it didn't contain a valid file hash for use on the Direct Connect network.  No action will be taken."
	MAGNET_DLG_TEXT_GOOD, // "ApexDC++ has detected a MAGNET link with a file hash that can be searched for on the Direct Connect network.  What would you like to do?"
	MAGNET_DLG_TITLE, // "MAGNET Link detected"
	MAGNET_HANDLER_DESC, // "Download files from the Direct Connect network"
	MAGNET_HANDLER_ROOT, // "ApexDC++"
	MAGNET_SHELL_DESC, // "URL:MAGNET URI"
	MANAGE_GROUPS, // "Manage Groups"
	MATCH_QUEUE, // "Match queue"
	MATCHED_FILES, // "Matched %d file(s)"
	MAX_HUBS, // "Max Hubs"
	MAX_SEGMENTS_NUMBER, // "Max number of segments"
	MAX_SIZE, // "Max Size"
	MAX_USERS, // "Max Users"
	MB, // "MiB"
	MBITSPS, // "MBit/s"
	MBPS, // "MiB/s"
	MENU_ABOUT, // "About"
	MENU_ADL_SEARCH, // "ADL Search"
	MENU_ARRANGE, // "Arrange icons"
	MENU_CASCADE, // "Cascade"
	MENU_CDMDEBUG_MESSAGES, // "CDM Debug Messages"
	MENU_CLOSE_ALL_DIR_LIST, // "Close all file list windows"
	MENU_CLOSE_ALL_OFFLINE_PM, // "Close all offline PM windows"
	MENU_CLOSE_ALL_PM, // "Close all PM windows"
	MENU_CLOSE_ALL_SEARCHFRAME, // "Close all search windows"
	MENU_CLOSE_DISCONNECTED, // "Close disconnected"
	MENU_RECONNECT_DISCONNECTED, // "Reconnect disconnected"
	MENU_CLOSE_ALL_HUBS, // "Close all hubs"
	MENU_CLOSE_HUBS_EMPTY, // "Close hubs with no users"
	MENU_DISCUSS, // "Forums"
	MENU_DONATE, // "Donate"
	MENU_DOWNLOAD_QUEUE, // "&Download Queue\tCtrl+D"
	MENU_EXIT, // "E&xit"
	MENU_FAVORITE_HUBS, // "&Favorite Hubs\tCtrl+F"
	MENU_FAVORITE_USERS, // "Favorite &Users\tCtrl+U"
	MENU_FILE, // "&File"
	MENU_FILE_RECENT_HUBS, // "&Recent Hubs"
	MENU_FOLLOW_REDIRECT, // "Follow last redirec&t\tCtrl+T"
	MENU_HASH_PROGRESS, // "Indexing progress"
	MENU_HELP, // "&Help"
	MENU_TOOLS, // "&Tools"
	MENU_TOOLS_INSTALL, // "Reinstall ApexDC++"
	MENU_TOOLS_GEOFILE, // "GeoIP database update"
	MENU_TOOLS_LOGIN, // "User Login"
	MENU_TOOLS_AUTHORIZE, // "Authorize binary"
	MENU_SITES_GUIDES, // "User made FAQ's and guides"
	MENU_HOMEPAGE, // "Homepage"
	MENU_HORIZONTAL_TILE, // "Horizontal Tile"
	MENU_MINIMIZE_ALL, // "Minimize &All"
	MENU_NETWORK_STATISTICS, // "Network Statistics"
	MENU_NOTEPAD, // "&Notepad\tCtrl+N"
	MENU_OPEN_DOWNLOADS_DIR, // "Open downloads directory\tCtrl+Z"
	MENU_OPEN_FILE_LIST, // "Open file list...\tCtrl+L"
	MENU_OPEN_MATCH_ALL, // "Match downloaded lists"
	MENU_OPEN_OWN_LIST, // "Open own list\tCtrl+O"
	MENU_PUBLIC_HUBS, // "&Public Hubs\tCtrl+P"
	MENU_QUICK_CONNECT, // "&Quick Connect ...\tCtrl+Q"
	MENU_RECONNECT, // "&Reconnect\tCtrl+R"
	MENU_REFRESH_FILE_LIST, // "Refresh file list\tCtrl+E"
	MENU_RESTORE_ALL, // "Restore All"
	MENU_SEARCH, // "&Search\tCtrl+S"
	MENU_SEARCH_SPY, // "Search spy"
	MENU_SETTINGS, // "Settings..."
	MENU_SHOW, // "Hide/Show ApexDC++"
	MENU_STATUS_BAR, // "&Status bar\tCtrl+2"
	MENU_TOOLBAR, // "&Toolbar\tCtrl+1"
	MENU_TRANSFER_VIEW, // "T&ransfers\tCtrl+3"
	MENU_TRANSFERS, // "&Transfers"
	MENU_HASH, // "Get Hashes for file..."
	MENU_VERTICAL_TILE, // "Vertical Tile"
	MENU_VIEW, // "&View"
	MENU_WINDOW, // "&Window"
	MENUBAR, // "Menu bar"
	MIN_SHARE, // "Min Share"
	MIN_SLOTS, // "Min Slots"
	MINIMUM_SEARCH_INTERVAL, // "Minimum search interval"
	MINSHARE, // "Min share"
	MINSLOTS, // "Min slots"
	MINUTES, // "Minutes"
	MODE, // "Mode"
	MOVE, // "Move/Rename"
	MOVE_DOWN, // "Move &Down"
	MOVE_UP, // "Move &Up"
	MYNICK_IN_CHAT, // "My nick in mainchat"
	NA, // "N/A"
	NAME, // "Name"
	NETWORK_STATISTICS, // "Network Statistics"
	NEW, // "&New..."
	NEW_DISCONNECT, // "Remove user from queue, if speed is below"
	NEXT, // "Next"
	NICK, // "Nick"
	NICK_TAKEN, // "Your nick was already taken, please change to something else!"
	NICK_UNKNOWN, // "(Nick unknown)"
	NO, // "No"
	NO_CERTIFICATE_FILE_SET, // "TLS disabled, no certificate file set"
	NO_DIRECTORY_SPECIFIED, // "No directory specified"
	NO_DOWNLOADS_FROM_SELF, // "You're trying to download from yourself!"
	NO_ERRORS, // "No errors"
	NO_FREE_BLOCK, // "No free block"
	NO_FULL_TREE, // "No full tree available"
	NO_LOG_FOR_HUB, // "Hub log doesn't exist"
	NO_LOG_FOR_USER, // "User log doesn't exist"
	NO_MATCHES, // "No matches"
	NO_NEEDED_PART, // "No needed part"
	NO_SLOTS_AVAILABLE, // "No slots available"
	NO_USERS, // "No users"
	NO_USERS_TO_DOWNLOAD_FROM, // "No users to download from"
	NONE, // "None"
	NORMAL, // "Normal"
	NOT_LISTENING, // "Not listening for connections - please restart ApexDC++"
	NOTEPAD, // "Notepad"
	NUMBER_OF_SEGMENTS, // "segment(s)"
	OFFLINE, // "Offline"
	OK, // "OK"
	ONLINE, // "Online"
	ONLY_FREE_SLOTS, // "Only users with free slots"
	ONLY_TTH, // "Only results with TTH root"
	ONLY_WHERE_OP, // "Only where I'm op"
	OPEN, // "Open"
	OPEN_DOWNLOAD_PAGE, // "Open download page?"
	OPEN_FOLDER, // "Open folder"
	OPEN_HUB_LOG, // "Open hub log"
	OPEN_USER_LOG, // "Open user log"
	OVERLAP_CHUNKS, // "Overlap slow chunks by faster user when file is going to be finished"
	OVERLAPPED_SLOW_SEGMENT, // "Overlapped by faster user"
	OWN_CERTIFICATE_FILE, // "Own certificate file"
	PARTS, // "Parts:"
	PARAM_EXISTS, // "Param with same name already exists!"
	PASSIVE_USER, // "Passive user"
	PASSWORD, // "Password"
	PATH, // "Path"
	PAUSE, // "Pause"
	PAUSED, // "Paused"
	PB, // "PiB"
	PICTURE, // "Picture"
	PLAY, // "Play"
	POPUP_DOWNLOAD_FAILED, // "Show popup on download failed"
	POPUP_DOWNLOAD_FINISHED, // "Show popup on download finished"
	POPUP_DOWNLOAD_START, // "Show popup on download begins"
	POPUP_FAVORITE_CONNECTED, // "Show popup on favorite user connected"
	POPUP_HUB_CONNECTED, // "Show popup on hub connected"
	POPUP_HUB_DISCONNECTED, // "Show popup on hub disconnected"
	POPUP_CHEATING_USER, // "Show popup on cheating user found"
	POPUP_NEW_PM, // "Show popup on new private message"
	POPUP_PM, // "Show popup on private message"
	POPUP_TYPE, // "Popup type"
	POPUP_UPLOAD_FINISHED, // "Show popup on upload finished"
	PORT, // "Port:"
	POWER_OFF, // "Power off"
	PRESS_FOLLOW, // "Press the follow redirect button to connect to"
	PREVIEW_MENU, // "Preview"
	PREVIOUS_FOLDERS, // "Previous folders"
	PRIORITY, // "Priority"
	PRIVATE_KEY_FILE, // "Private key file"
	PRIVATE_MESSAGE, // "Private message"
	PRIVATE_MESSAGE_FROM, // "Private message from"
	MESSAGE, // "Message"
	PROGRESS_BACK, // "Transfer progressbar - background"
	PROGRESS_COMPRESS, // "Transfer progressbar - decompressed part"
	PROGRESS_DONE, // "Queue progressbar - done chunks"
	PROGRESS_DOWNLOADED, // "Queue progressbar - downloaded bytes"
	PROGRESS_RUNNING, // "Queue progressbar - running chunks"
	PROGRESS_SEGMENT, // "Transfer progressbar - actual segment"
	PROGRESSBAR_ODC_STYLE, // "oDC Style"
	PROGRESSBAR_STEALTHY_STYLE, // "Stealthy Style"
	PROPERTIES, // "&Properties"
	PUBLIC_HUBS, // "Public Hubs"
	PURGE, // "Purge"
	REGEXP_TESTER, // "RegExp Tester"
	REGEXP_MATCH, // "It's a match!"
	REGEXP_MISMATCH, // "It's not a match."
	REGEXP_INVALID, // "Invalid RegExp!"
	REGEXP, // "RegExp"
	QSEARCH_STR, // "Search for files..."
	QUEUED, // "Queued:"
	QUICK_CONNECT, // "Quick Connect"
	RATING, // "Rating"
	RATIO, // "Ratio"
	READD_SOURCE, // "Readd source"
	REALLY_EXIT, // "Really exit?"
	REALLY_REMOVE, // "Really remove?"
	REASON, // "Reason"
	REBOOT, // "Reboot"
	RECENT_HUBS, // "Recent Hubs"
	RECHECK_FILE, // "Recheck integrity"
	REDIRECT_ALREADY_CONNECTED, // "Redirect request received to a hub that's already connected"
	REDIRECT_USER, // "Redirect user(s)"
	REFRESH, // "&Refresh"
	REFRESH_USER_LIST, // "Refresh user list"
	RELIABILITY, // "Reliability"
	REQUESTING, // "Requesting"
	REQUESTING_LIST, // "Requesting file list"
	REMOVE, // "&Remove"
	REMOVE_ALL, // "Remove all"
	REMOVE_EXTRA_SLOT, // "Remove extra slot"
	REMOVE_FROM_ALL, // "Remove user from queue"
	REMOVE_OFFLINE, // "Remove offline users"
	REMOVE_SOURCE, // "Remove source"
	RENAMED_TO, // "renamed to"
	REPORT, // "Report user"
	REPORT_ALTERNATES, // "Report auto search for alternates in status bar"
	RESUME, // "Resume"
	RETRIEVING_DATA, // "Retrieving data"
	RIGHT_COLOR, // "Right color"
	RUNNING, // "Running..."
	SEARCH, // "Search"
	SEARCH_FOR, // "Search for"
	SEARCH_FOR_ALTERNATES, // "Search for alternates"
	SEARCH_FOR_FILE, // "Search for file"
	SEARCH_IN_RESULTS, // "Search in results"
	SEARCH_OPTIONS, // "Search options"
	SEARCH_SPAM_FROM, // "Search spam detected from"
	SEARCH_SPY, // "Search Spy"
	SEARCH_STRING, // "Search String"
	SEARCHING_FOR, // "Searching for"
	SECONDS, // "Seconds"
	SEEK_BEYOND_END, // "Request to seek beyond the end of data"
	SEGMENT, // "Segment"
	SEGMENTS, // "Segments"
	SELECT_ALL, // "Select all"
	SELECT_USER_LIST, // "Select user in list"
	SEND_PRIVATE_MESSAGE, // "Send private message"
	SEND_PUBLIC_MESSAGE, // "Send public message"
	SEPARATOR, // "Separator"
	SERVER, // "Server"
	SET_PRIORITY, // "Set priority"
	SETSTRONGDC_ALTERNATE_LIMITING, // "Use Alternate Limiting from"
	SETSTRONGDC_BACK_COLOR, // "Back color"
	SETSTRONGDC_BLACK_WHITE, // "Black & white"
	SETSTRONGDC_BOLD, // "Bold Authors of messages in chat"
	SETSTRONGDC_CZCHARS_DISABLE, // "Remove diacritic marks from Czech chars"
	SETSTRONGDC_DEFAULT_STYLE, // "Default styles"
	SETSTRONGDC_DISCONNECTING_ENABLE, // "Enable slow downloads disconnecting"
	SETSTRONGDC_DOWNLOAD_SPEED, // "Download Speed"
	SETSTRONGDC_ERROR_COLOR, // "Error color"
	SETSTRONGDC_H_DOWN_SPEED, // "And whole file speed exceeds"
	SETSTRONGDC_I_DOWN_SPEED, // "Disconnect download if speed is below"
	SETSTRONGDC_MAGNET_URI_HANDLER, // "Install Magnet URI handler on startup"
	SETSTRONGDC_MIN_FILE_SIZE, // "And file size is more than"
	SETSTRONGDC_NOTE_SMALL_UP, // "* Small Uploads Slots => Slots for filelist and Small Files."
	SETSTRONGDC_PARTIAL_SLOTS, // "Extra slots for uploading partially downloaded files"
	SETSTRONGDC_PASSIVE_SEARCH, // "Always use passive mode for Search (Use only if you know what this does)"
	SETSTRONGDC_PM_LINES, // "Lines from log on new PM"
	SETSTRONGDC_PREVIEW, // "Preview"
	SETSTRONGDC_PRIVATE_SOUND, // "Private message sound"
	SETSTRONGDC_PROGRESSBAR_COLORS, // "Progressbar colors"
	SETSTRONGDC_PROGRESSBAR_TEXT, // "Progressbar text colors"
	SETSTRONGDC_REMOVE_FORBIDDEN, // "Remove Forbidden (Unfinished Kazaa, Win MX, GetRight, eMule, DC++)"
	SETSTRONGDC_SECONDARY_LIMITING, // "Secondary transfer limiter"
	SETSTRONGDC_SLOW_DISCONNECT, // "Disconnecting slow downloads"
	SETSTRONGDC_SMALL_FILES, // "Small file size"
	SETSTRONGDC_SMALL_UP_SLOTS, // "Small Upload Slots"
	SETSTRONGDC_STYLES, // "Available styles"
	SETSTRONGDC_TEXT_COLOR, // "Text color"
	SETSTRONGDC_TEXT_STYLE, // "Text style"
	SETSTRONGDC_TIME_DOWN, // "More than"
	SETSTRONGDC_TO, // "to"
	SETSTRONGDC_TRANSFER_LIMITING, // "Limit transfer speeds"
	SETSTRONGDC_UPLOAD, // "Upload"
	SETSTRONGDC_UPLOAD_SPEED, // "Upload Speed"
	SETSTRONGDC_WINAMP, // "Winamp"
	SETTINGS, // "Settings"
	SETTINGS_ADD_FOLDER, // "&Add folder"
	SETTINGS_ADLS_BREAK_ON_FIRST, // "Break on first ADLSearch match"
	SETTINGS_ADVANCED, // "Advanced"
	SETTINGS_ADVANCED_SHOW_SHARE_CHECKED_USERS, // "Show share-checked users"
	SETTINGS_ADVANCED_SUPPRESS_MAIN_CHAT, // "Suppress main chat"
	SETTINGS_ADVANCED3, // "Experts only"
	SETTINGS_ALLOW_UNTRUSTED_CLIENTS, // "Allow TLS connections to clients without trusted certificate"
	SETTINGS_ALLOW_UNTRUSTED_HUBS, // "Allow TLS connections to hubs without trusted certificate"
	SETTINGS_ANTI_FRAG, // "Use antifragmentation method for downloads"
	SETTINGS_APPEARANCE, // "Appearance"
	SETTINGS_ARGUMENT, // "Arguments"
	SETTINGS_AUTO_AWAY, // "Auto-away on minimize (and back on restore)"
	SETTINGS_AUTO_DROP_SEGMENTED_SOURCE, // "When segmented downloading only (more than 2 active sources)"
	SETTINGS_AUTO_FOLLOW, // "Automatically follow redirects"
	SETTINGS_AUTO_KICK, // "Automatically disconnect users who leave the hub"
	SETTINGS_AUTO_KICK_NO_FAVS, // "Don't automatically disconnect favorite users who leave the hub"
	SETTINGS_AUTO_OPEN, // "Auto-open at startup"
	SETTINGS_AUTO_PRIORITY_DEFAULT, // "Use Auto Priority by default"
	SETTINGS_AUTO_REFRESH_TIME, // "Auto refresh time"
	SETTINGS_AUTO_SEARCH, // "Automatically search for alternative TTH source every"
	SETTINGS_AUTO_SEARCH_AUTO_MATCH, // "Automatically match queue for search hits"
	SETTINGS_AUTO_SEARCH_LIMIT, // "Max sources for autosearch"
	SETTINGS_AUTO_SLOTS, // "Maximum auto opened"
	SETTINGS_AVIPREVIEW, // "File Preview"
	SETTINGS_BIND_ADDRESS, // "Bind address"
	SETTINGS_BIND_ADDRESS_HELP, // "Network interface for all connections"
	SETTINGS_BOLD_OPTIONS, // "Tab highlight on content change"
	SETTINGS_CERTIFICATES, // "Security"
	SETTINGS_CLEAR_SEARCH, // "Clear search box after each search"
	SETTINGS_CLIENTS, // "Clients"
	SETTINGS_COLOR_ALTERNATE, // "Search Alternate"
	SETTINGS_COLOR_BAD_CLIENT, // "Bad client"
	SETTINGS_COLOR_BAD_FILELIST, // "Bad filelist/fakeshare"
	SETTINGS_COLOR_FAVORITE, // "Favorite"
	SETTINGS_COLOR_FULL_CHECKED, // "User check completed"
	SETTINGS_COLOR_IGNORED, // "Ignored"
	SETTINGS_COLOR_NORMAL, // "Normal"
	SETTINGS_COLOR_RESERVED, // "Has reserved slot"
	SETTINGS_COLORS, // "Other colors"
	SETTINGS_COMMAND, // "Command"
	SETTINGS_COMPRESS_TRANSFERS, // "Enable safe and compressed transfers"
	SETTINGS_CONFIGURE_HUB_LISTS, // "Configure Public Hub Lists"
	SETTINGS_RESET_HUB_LISTS, // "Reset Public Hub Lists"
	SETTINGS_RESET_HUB_LISTS_CONFIRM, // "This will remove all existing hublist entries and reset to the default preconfigured ones. Do you really want to proceed?"
	SETTINGS_CONFIRM_EXIT, // "Confirm application exit"
	SETTINGS_CONFIRM_HUB_REMOVAL, // "Confirm favorite hub removal"
	SETTINGS_CONFIRM_ITEM_REMOVAL, // "Confirm item removal in download queue"
	SETTINGS_STRONGDC, // "ApexDC++"
	SETTINGS_STRONGDC_EXTRA_DOWNLOADS, // "Highest Priority Extra Download Slots"
	SETTINGS_DEFAULT_AWAY_MSG, // "Default away message"
	SETTINGS_DIRECT, // "Direct connection"
	SETTINGS_DIRECTORIES, // "Directories"
	SETTINGS_DISPLAY_CHEATS_IN_MAIN_CHAT, // "Display cheats in main chat"
	SETTINGS_DONT_DL_ALREADY_SHARED, // "Don't download files already in share"
	SETTINGS_DOWNCONN, // "Dwnld attempts/second"
	SETTINGS_DOWNLOAD_DIRECTORY, // "Default download directory"
	SETTINGS_DOWNLOAD_LIMITS, // "Limits"
	SETTINGS_DOWNLOADS, // "Downloads"
	SETTINGS_DOWNLOADS_MAX, // "Maximum simultaneous downloads (0 = infinite)"
	SETTINGS_DOWNLOADS_SPEED_PAUSE, // "No new downloads if speed exceeds (KiB/s, 0 = disable)"
	SETTINGS_EXPAND_QUEUE, // "Automatically expand folders in Queue"
	SETTINGS_EXTENSIONS, // "Extensions"
	SETTINGS_EXTERNAL_IP, // "External / WAN IP"
	SETTINGS_FAKEDETECT, // "Fake detector"
	SETTINGS_FAV_SHOW_JOINS, // "Only show joins / parts for favorite users"
	SETTINGS_FAVORITE_DIRS, // "Favorite download directories"
	SETTINGS_FAVORITE_DIRS_PAGE, // "Favorites"
	SETTINGS_FILE_NAME, // "Filename"
	SETTINGS_FILES_MAX, // "Maximum simultaneous files (0 = infinite)"
	SETTINGS_FILTER_MESSAGES, // "Filter kick and NMDC debug messages"
	SETTINGS_FILTER_ENTER, // "Activate search/userlist filter by pressing Enter"
	SETTINGS_FIREWALL_NAT, // "Firewall with manual port forwarding"
	SETTINGS_FIREWALL_PASSIVE, // "Firewall (passive, worst case)"
	SETTINGS_FIREWALL_UPNP, // "Firewall with UPnP (WinXP+ only)"
	SETTINGS_FORMAT, // "Format"
	SETTINGS_GENERAL, // "General"
	SETTINGS_GET_USER_COUNTRY, // "Get User Country"
	SETTINGS_HUB_USER_COMMANDS, // "Accept custom user commands from hub"
	SETTINGS_CHANGE, // "&Change"
	SETTINGS_IGNORE_HUB_PMS, // "Ignore private messages from the hub"
	SETTINGS_IGNORE_BOT_PMS, // "Ignore private messages from bots"
	SETTINGS_INCOMING, // "Incoming connection settings (see Help/FAQ if unsure)"
	SETTINGS_KEEP_LISTS, // "Don't delete file lists when exiting"
	SETTINGS_LANGUAGE_FILE, // "Language file"
	SETTINGS_LIMIT, // "Bandwidth Limiting"
	SETTINGS_LOG_DIR, // "Log directory"
	SETTINGS_LOG_DOWNLOADS, // "Log downloads"
	SETTINGS_LOG_FILELIST_TRANSFERS, // "Log filelist transfers"
	SETTINGS_LOG_MAIN_CHAT, // "Log main chat"
	SETTINGS_LOG_PRIVATE_CHAT, // "Log private chat"
	SETTINGS_LOG_STATUS_MESSAGES, // "Log status messages"
	SETTINGS_LOG_SYSTEM_MESSAGES, // "Log system messages"
	SETTINGS_LOG_UPLOADS, // "Log uploads"
	SETTINGS_LOG_WEBSERVER, // "Log webserver"
	SETTINGS_LOGGING, // "Logging"
	SETTINGS_LOGS, // "Logs"
	SETTINGS_MAX_COMPRESS, // "Max compression level"
	SETTINGS_MAX_HASH_SPEED, // "Max hash speed"
	SETTINGS_MAX_TAB_ROWS, // "Max tab rows"
	SETTINGS_MINIMIZE_ON_STARTUP, // "Minimize at program startup"
	SETTINGS_MINIMIZE_TRAY, // "Minimize to tray"
	SETTINGS_MOUSE_OVER, // "Mouse Over"
	SETTINGS_NAME, // "Name"
	SETTINGS_NETWORK, // "Connection settings"
	SETTINGS_NO_AWAYMSG_TO_BOTS, // "Don't send the away message to bots"
	SETTINGS_NORMAL, // "Normal"
	SETTINGS_ODC_SHUTDOWNTIMEOUT, // "timeout"
	SETTINGS_ONLY_HASHED, // "Note; Files appear in the share only after they've been hashed!"
	SETTINGS_OPEN_NEW_WINDOW, // "Open new window when using /join"
	SETTINGS_OPERACOLORS, // "Progressbar colors"
	SETTINGS_OPTIONS, // "Options"
	SETTINGS_OUTGOING, // "Outgoing connection settings"
	SETTINGS_OVERRIDE, // "Don't allow hub/UPnP to override"
	SETTINGS_PERSONAL_INFORMATION, // "Personal Information"
	SETTINGS_PM_BEEP, // "Make an annoying sound every time a private message is received"
	SETTINGS_PM_BEEP_OPEN, // "Make an annoying sound when a private message window is opened"
	SETTINGS_PM_HISTORY, // "PM history"
	SETTINGS_POPUNDER_FILELIST, // "Open new file list windows in the background"
	SETTINGS_POPUNDER_PM, // "Open new private message windows in the background"
	SETTINGS_POPUP_BOT_PMS, // "Open private messages from the hub in their own window"
	SETTINGS_POPUP_HUB_PMS, // "Open private messages from bots in their own window"
	SETTINGS_POPUP_PMS, // "Open private messages in their own window"
	SETTINGS_PORTS, // "Ports"
	SETTINGS_PRIO_AUTOPRIO, // "Priority settings - has higher priority than Autopriority"
	SETTINGS_PRIO_HIGH, // "High prio max size"
	SETTINGS_PRIO_HIGHEST, // "Highest prio max size"
	SETTINGS_PRIO_LOW, // "Low prio max size"
	SETTINGS_PRIO_LOWEST, // "Set lowest prio for newly added files larger than Low prio size"
	SETTINGS_PRIO_NORMAL, // "Normal prio max size"
	SETTINGS_PROMPT_PASSWORD, // "Popup box to input password for hubs"
	SETTINGS_PUBLIC_HUB_LIST, // "Public Hubs list"
	SETTINGS_PUBLIC_HUB_LIST_HTTP_PROXY, // "HTTP Proxy (for hublist only)"
	SETTINGS_PUBLIC_HUB_LIST_URL, // "Public Hubs list URL"
	SETTINGS_QUEUE, // "Queue"
	SETTINGS_RENAME_FOLDER, // "Rename"
	SETTINGS_REQUIRES_RESTART, // "Note; most of these options require that you restart ApexDC++"
	SETTINGS_RESET, // "Reset"
	SETTINGS_SB_MAX_SOURCES, // "Max sources for match queue"
	SETTINGS_SEARCH_HISTORY, // "Search history"
	SETTINGS_SEGMENT, // "Segment Downloading"
	SETTINGS_SELECT_COLOR, // "Select color"
	SETTINGS_SELECT_TEXT_FACE, // "&Text style"
	SETTINGS_SELECT_WINDOW_COLOR, // "&Window color"
	SETTINGS_SEND_UNKNOWN_COMMANDS, // "Send unknown /commands to the hub"
	SETTINGS_SHARE_HIDDEN, // "Share hidden files"
	SETTINGS_SHARE_SIZE, // "Total size:"
	SETTINGS_SHARED_DIRECTORIES, // "Shared directories"
	SETTINGS_SHOW_INFO_TIPS, // "Show InfoTips in lists"
	SETTINGS_SHOW_JOINS, // "Show joins / parts in chat by default"
	SETTINGS_SHOW_PROGRESS_BARS, // "Show progress bars for transfers (uses some CPU)"
	SETTINGS_SHOW_SHELL_MENU, // "Show shell menu in finished transfers"
	SETTINGS_SKIP_ZERO_BYTE, // "Skip zero-byte files"
	SETTINGS_SOCKS5, // "SOCKS5"
	SETTINGS_SOCKS5_IP, // "Socks IP"
	SETTINGS_SOCKS5_PORT, // "Port"
	SETTINGS_SOCKS5_RESOLVE, // "Use SOCKS5 server to resolve host names"
	SETTINGS_SOCKS5_USERNAME, // "Login"
	SETTINGS_SORT_FAVUSERS_FIRST, // "Sort favorite users first"
	SETTINGS_SOUNDS, // "Sounds"
	SETTINGS_SPEEDS_NOT_ACCURATE, // "Note; because of changing download speeds, this is not 100% accurate..."
	SETTINGS_STATUS_IN_CHAT, // "View status messages in main chat"
	SETTINGS_DHT_PORT, // "DHT/UDP"
	SETTINGS_TCP_PORT, // "TCP"
	SETTINGS_TLS_PORT, // "TLS/TCP"
	SETTINGS_TEXT_STYLES, // "Colors & Fonts"
	SETTINGS_TIME_STAMPS, // "Show timestamps in chat by default"
	SETTINGS_TIME_STAMPS_FORMAT, // "Set timestamps"
	SETTINGS_TOGGLE_ACTIVE_WINDOW, // "Toggle window when selecting an active tab"
	SETTINGS_TOOLBAR, // "Toolbar"
	SETTINGS_TOOLBAR_ADD, // "Add -->"
	SETTINGS_TOOLBAR_IMAGE, // "Toolbar images"
	SETTINGS_TOOLBAR_REMOVE, // "<-- Remove"
	SETTINGS_UDP_PORT, // "UDP"
	SETTINGS_UNFINISHED_DOWNLOAD_DIRECTORY, // "Unfinished downloads directory"
	SETTINGS_UPDATE_IP, // "Update IP on startup and DHT firewall check"
	SETTINGS_UPLOAD_LINE_SPEED, // "Line speed (upload)"
	SETTINGS_UPLOADS, // "Sharing"
	SETTINGS_UPLOADS_MIN_SPEED, // "Open an extra slot if speed is below (0 = disable)"
	SETTINGS_UPLOADS_SLOTS, // "Upload slots"
	SETTINGS_URL_HANDLER, // "Install URL handler on startup (to handle dchub:// links)"
	SETTINGS_USE_CTRL_FOR_LINE_HISTORY, // "Use CTRL for line history"
	SETTINGS_USE_OLD_SHARING_UI, // "Use old sharing user interface"
	SETTINGS_USE_SYSTEM_ICONS, // "Use system icons when browsing files (slows browsing down a bit)"
	SETTINGS_USE_TLS, // "Use TLS when remote client supports it (affects both clients and hubs)"
	SETTINGS_USER_COLORS, // "User List Colors"
	SETTINGS_USER_COMMANDS, // "User Commands"
	SETTINGS_USER_MENU, // "User Menu Items"
	SETTINGS_WEBSERVER, // "Enable Webserver"
	SETTINGS_WINDOWS, // "Windows"
	SETTINGS_WINDOWS_OPTIONS, // "Window options"
	SETTINGS_WRITE_BUFFER, // "Write buffer size"
	SETTINGS_ZDC_PROGRESS_OVERRIDE, // "Override system colors"
	SETTINGS_MAX_FILELIST_SIZE, // "Max Filelist size"
	SHARED, // "Shared"
	SHARED_FILES, // "Shared Files"
	SHOW_POPUP_AWAY, // "Display popup in away mode only"
	SHOW_POPUP_MINIMIZED, // "Display popup when minimized only"
	SHOW_LIMIT, // "Show bandwidth limit in description"
	SHUTDOWN, // "Shutdown computer"
	SHUTDOWN_ACTION, // "Shutdown action"
	SHUTDOWN_OFF, // "Shutdown sequence deactivated..."
	SHUTDOWN_ON, // "Shutdown sequence activated..."
	SIZE, // "Size"
	SIZE_EXACT, // "Exactly"
	SIZE_MIN, // "Min Size"
	SKIP_RENAME, // "New virtual name matches old name, skipping..."
	SLOT_GRANTED, // "Slot granted"
	SLOTS, // "Slots"
	SLOTS_SET, // "Slots set"
	SLOW_USER, // "Slow user"
	SMALL_FILE_SIZE_SET, // "Small file size set"
	SOCKS_AUTH_FAILED, // "Socks server authentication failed (bad login / password?)"
	SOCKS_AUTH_UNSUPPORTED, // "The socks server doesn't support login / password authentication"
	SOCKS_FAILED, // "The socks server failed establish a connection"
	SOCKS_NEEDS_AUTH, // "The socks server requires authentication"
	SOCKS_SETUP_ERROR, // "Failed to set up the socks server for UDP relay (check socks address and port)"
	SOUND_DOWNLOAD_BEGINS, // "Download begins"
	SOUND_DOWNLOAD_FINISHED, // "Download finished"
	SOUND_EXCEPTION, // "Unhandled Exception"
	SOUND_FAKER_FOUND, // "Faker found"
	SOUND_TYPING_NOTIFY, // "Typing sound"
	SOUND_UPLOAD_FINISHED, // "Upload finished"
	SOURCE_TOO_OLD, // "Remote client does not fully support TTH - cannot download"
	SOURCE_TYPE, // "Source Type"
	SPECIFY_SEARCH_STRING, // "Specify a search string"
	SPECIFY_SERVER, // "Specify a server to connect to"
	SPEED, // "Speed"
	SSL_ERROR, // "SSL Error"
	STARTED, // "Started"
	STATUS, // "Status"
	STEALTH_MODE, // "Emulate DC++ in this hub"
	STORED_PASSWORD_SENT, // "Stored password sent..."
	STRING_NOT_FOUND, // "String not found:"
	SUPPORTS, // "Supports"
	SUSPEND, // "Suspend"
	TABS_BOTTOM, // "Bottom"
	TABS_LEFT, // "Left"
	TABS_POSITION, // "Tabs position"
	TABS_RIGHT, // "Right"
	TABS_TOP, // "Top"
	TAG, // "Tag"
	TARGET_FILE_EXISTS, // "File already exists at the target location"
	TARGET_FILENAME_TOO_LONG, // "Target filename too long"
	TARGET_REMOVED, // "Target removed"
	TB, // "TiB"
	PORT_BUSY, // "Unable to open ports. File transfers will not work correctly until you change settings or turn off any application that might be using these ports"
	TEXT_FAKEPERCENT, // "Percent fake share accepted"
	TEXT_MANUAL, // "Manual settings of number of segments"
	TIME, // "Time"
	TIME_LEFT, // "Time left"
	TIMESTAMP_HELP, // "\r\n- %a - Abbreviated weekday name\r\n- %A - Full weekday name\r\n- %b - Abbreviated month name\r\n- %B - Full month name\r\n- %c - Date and time representation appropriate for locale\r\n- %d - Day of month as decimal number (01  31)\r\n- %H - Hour in 24-hour format (00  23)\r\n- %I - Hour in 12-hour format (01  12)\r\n- %j - Day of year as decimal number (001  366)\r\n- %m - Month as decimal number (01  12)\r\n- %M - Minute as decimal number (00  59)\r\n- %p - Current locale's A.M./P.M. indicator for 12-hour clock\r\n- %S - Second as decimal number (00  59)\r\n- %U - Week of year as decimal number, with Sunday as first day of week (00  53)\r\n- %w - Weekday as decimal number (0  6; Sunday is 0)\r\n- %W - Week of year as decimal number, with Monday as first day of week (00  53)\r\n- %x - Date representation for current locale\r\n- %X - Time representation for current locale\r\n- %y - Year without century, as decimal number (00  99)\r\n- %Y - Year with century, as decimal number\r\n- %z, %Z - Either the time-zone name or time zone abbreviation, depending on registry settings; no characters if time zone is unknown\r\n- %% - Percent sign\r\n\r\nDefault: %H:%M:%S"
	TIMESTAMP_HELP_DESC, // "Timestamps Help"
	TIMESTAMPS_DISABLED, // "Timestamps disabled"
	TIMESTAMPS_ENABLED, // "Timestamps enabled"
	TOGGLE_QSEARCH, // "Quick Search\tCtrl+4"
	TOO_LARGE_LIST, // "Greater than maximum filelist size"
	TOO_MUCH_DATA, // "More data was sent than was expected"
	TOTAL, // "Total:"
	TRANSFERLISTDBLCLICKACTION, // "Transfers action:"
	TRANSFERRED, // "Transferred"
	TRUSTED_CERTIFICATES_PATH, // "Trusted certificates path"
	TTH_ALREADY_SHARED, // "A file with the same hash already exists in your share"
	TTH_INCONSISTENCY, // "TTH Inconsistency"
	TTH_ROOT, // "TTH Root"
	TWO_COLORS, // "Two colors"
	TYPE, // "Type"
	UC_SUBMENU, // "Place usercommands to submenu"
	UNABLE_TO_CREATE_THREAD, // "Unable to create thread"
	UNABLE_TO_OPEN_FILELIST, // "Unable to open filelist:"
	UNABLE_TO_RENAME, // "Unable to rename"
	UNABLE_TO_SEND_FILE, // "Unable to send file"
	UNFINISHED_FILE_NOT_FOUND, // "Unfinished file not found"
	UNFINISHED_FILE_TOO_SMALL, // "Unfinished file too small"
	UNIGNORE_USER, // "Unignore User"
	UNKNOWN, // "Unknown"
	UNKNOWN_COMMAND, // "Unknown command:"
	UNKNOWN_ERROR, // "Unknown error: 0x%x"
	UPDATE, // "Update"
	UPDATE_CHECK, // "Update check"
	UPLOAD_FINISHED_IDLE, // "Upload finished, idle..."
	UPLOAD_QUEUE, // "Upload queue"
	UPLOAD_STARTING, // "Upload starting..."
	UPLOADED_BYTES, // "Uploaded %s (%.01f%%) in %s"
	UPLOADED_TO, // "uploaded to"
	MAPPING_FAILED_TO_CREATE_MAPPINGS, // "Failed to create port mappings."
	MAPPING_FAILED_TO_GET_EXTERNAL_IP, // "Failed to get external IP."
	MAPPING_FAILED_TO_REMOVE_MAPPINGS, // "Failed to remove port mappings from the %1% device with the %2% interface"
	MAPPING_REMOVED_MAPPINGS, // "Successfully removed port mappings from the %1% device with the %2% interface"
	MAPPING_NO_IMPLEMENTATION, // "No port mapping interfaces available"
	MAPPING_ANOTHER_MAPPING, // "Another port mapping attempt is in progress..."
	MAPPING_SUCCESSFULLY_CREATED_MAPPINGS, // "Successfully created port mappings (TCP: %1%, UDP: %2%, TLS: %3%) on the %4% device with the %5% interface"
	MAPPING_LOG_MESSAGE, // "Port mapping: %1%"
	MAPPING_INTERFACE_FAILED_PORT, // "The %1% interface has failed to map the %2% port (%3% %4%)"
	MAPPING_INTERFACE_FAILED_INIT, // "Failed to initalize the %1% interface"
	USE_DHT, // "Publish shared files on DHT and use it for searching alternate sources"
	USE_EXPLORER_THEME, // "Use Explorer theme in listviews and treeviews"
	USER, // "User"
	USER_CMD_COMMAND, // "Command"
	USER_CMD_CONTEXT, // "Context"
	USER_CMD_FILELIST_MENU, // "Filelist Menu"
	USER_CMD_HUB, // "Hub IP / DNS (empty = all, 'op' = where operator)"
	USER_CMD_HUB_MENU, // "Hub Menu"
	USER_CMD_CHAT, // "Chat"
	USER_CMD_ONCE, // "Send once per nick"
	USER_CMD_PARAMETERS, // "Parameters"
	USER_CMD_PM, // "PM"
	USER_CMD_RAW, // "Raw"
	USER_CMD_SEARCH_MENU, // "Search Menu"
	USER_CMD_TO, // "To"
	USER_CMD_TYPE, // "Command Type"
	USER_CMD_USER_MENU, // "User Menu"
	USER_CMD_WINDOW, // "Create / Modify Command"
	USER_DESCRIPTION, // "User Description"
	USER_OFFLINE, // "User offline"
	USER_ONLINE, // "Running... (user online)"
	USER_WENT_OFFLINE, // "User went offline"
	USER_WENT_ONLINE, // "User went online"
	USERINFO, // "Info User"
	USERLIST_ICONS, // "Userlist Icons"
	USERLISTDBLCLICKACTION, // "Userlist action:"
	USERS, // "Users"
	USERS_ONLINE, // "Running... (%d of %d users online)"
	VERSION, // "Version"
	VIDEO, // "Video"
	VIEW_AS_TEXT, // "View as text"
	VIRTUAL_NAME, // "Virtual name"
	VIRTUAL_NAME_EXISTS, // "Virtual directory name already exists"
	VIRTUAL_NAME_LONG, // "Name under which the others see the directory"
	WAITING, // "Waiting..."
	WAITING_TIME, // "Waiting time"
	WAITING_TO_RETRY, // "Waiting to retry..."
	WAITING_USER_ONLINE, // "Waiting (User online)"
	WAITING_USERS_ONLINE, // "Waiting (%d of %d users online)"
	WEBSERVER, // "Webserver"
	WHATS_THIS, // "What's &this?"
	WHO_IS, // "Whois"
	WINAMP_HELP, // "/winamp - Works with Winamp 1.x, 2.x, 5.x (no Winamp 3 support)\r\n- %[version]	Numerical Version (ex: 2.91)\r\n- %[state]	Playing state (ex: stopped/paused/playing)\r\n- %[title]		Window title from Winamp - if you want to change this for mp3s, Winamp > Pref > Input > MPEG > Title\r\n- %[rawtitle]	Window title from Winamp (if %[title] not working propertly)\r\n- %[percent]	Percentage (ex. 40%)\r\n- %[length]	Length in minutes:seconds (ex: 04:09)\r\n- %[elapsed]	Time elapsed in minutes:seconds (ex. 03:51)\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[bitrate]	Bitrate (ex. 128kbps)\r\n- %[sample]	Sample frequency (ex. 22kHz)\r\n- %[channels]	Number of channels (ex. stereo / mono)\r\n\r\nEmpty = Default String -> /me playing: %[title] at %[bitrate] <Winamp %[version]>\r\n\r\nNote:\r\nYou can use most of the features offered by /winamp command also with The KMPlayer.\r\nParameters that are known not to work (or return incorrect values) are %[version], %[bitrate], %[sample] and %[channels].\r\nIt's also very likely that you will need to use %[rawtitle] instead of %[title] to get the correct output."
	WINAMP_HELP_DESC, // "Winamp Help"
	YES, // "Yes"
	SETTINGS_STRIP_TOPIC, // "Hide hub topics"
	PASSWORD_DESC, // "Enter password"
	PASSWORD_TITLE, // "Password required"
	SETTINGS_SKIPLIST_SHARE, // "Share skiplist (wildcards supported, use semicolon to separate entries)"
	CHECK_SETTINGS, // "Check connection"
	GET_IP, // "Get IP address"
	PM_PREVIEW, // "Show preview of private message on popup"
	PRIO_FILE, // "Priority based on filename"
	PRIO_FILE_HIGHEST, // "Highest:"
	PRIO_FILE_LOWEST, // "Lowest:"
	POPUP_TIME, // "Popup time"
	SET_SECONDARY_AWAY, // "Secondary away message"
	TICKS_SPEED_DOWN, // "5 ticks down speed:"
	TICKS_SPEED_UP, // "5 ticks up speed:"
	IP_IN_CHAT, // "Attempt to show users IP in chat"
	COUNTRY_IN_CHAT, // "Attempt to show users country in chat"
	NOON, // "Noon"
	MIDNIGHT, // "Midnight"
	AM, // " AM"
	PM, // " PM"
	SETTINGS_STATE, // "Save settings window state"
	ENABLE_HUBTOPIC, // "Enable $HubTopic support"
	HIDE_SHARE, // "Hide share in this hub"
	SHOW_JOINS, // "Show joins"
	CLEAR, // "Clear"
	PROT_USERS, // "Protected prefixes"
	PROT_DESC, // "Exclude users from checking (wildcards, use semicolon to separate entries)"
	PROT_FAVS, // "Auto protect favourite users"
	SUPER_USER, // "Can bypass limiter"
	HUBCHATS, // "Hub Chatrooms (wildcards supported, use semicolon to separate entries)"
	EXCL_CHECKS, // "Exclude hub from automatic client/fake checking"
	POPUP_BACK_COLOR, // "&Back color"
	POPUP_FONT, // "&Msg text"
	POPUP_TITLE_FONT, // "&Title text"
	MAX_MSG_LENGTH, // "Max length"
	POPUP_IMAGE, // "Popup image"
	EXCEPTION_DIALOG, // "ApexDC++ has crashed..."
	EXCEPTION_HEADER, // "The following application error has occurred:"
	EXCEPTION_FOOTER, // "If this problem persists, copy the above exception information to the clipboard, and send it to ApexDC++ forums."
	EXCEPTION_RESTART, // "Reconnect after termination of the application"
	EXCEPTION_COPY, // "Copy Exception"
	EXCEPTION_CONTINUE, // "Continue"
	EXCEPTION_TERMINATE, // "Terminate Application"
	OPEN_LOGS_INTERNAL, // "Open log files internally (performance may decrease when opening huge log files)"
	GLOBAL_HUBFRAME_CONF, // "Use global layout for hub windows (overrides favorite hub specific preferences)"
	CASE_SENSITIVE, // "Case sensitive"
	CASE_INSENSITIVE_REGEXP, // "Case insensitive RegExp"
	MATCH, // "Match"
	NO_ADLS, // "Don't perform ADLSearches in this hub"
	GLOBAL, // "Overrides Fav. Hubs"
	ACTION, // "Action"
	NO_ACTION, // "No Action"
	FORBIDDEN_FILES, // "Forbidden Files"
	OPCHAT_INSTR, // "The first entry may be accessed with %[opchat] from raw and user commands but in order for this to work it may not contain any wildcard characters in it."
	PROFILE_NFO, // "Profile Info"
	SETTINGS_PARAMS, // "Params"
	NAME_REGEXP_EMPTY, // "Name or RegExp must not be empty"
	USE_ANTIVIR, // "Check finished files for viruses"
	HIDE_ANTIVIR, // "Run as hidden"
	STEALTHY_INDICATE_SPEEDS, // "Indicate speeds (Stealthy Style)"
	OLD_TRAY_BEHAV, // "Single click on tray icon to open"
	OLD_NAMING_STYLE, // "Use the old way (StrongDC 1.x) of displaying hub names"
	SETTINGS_DUPE_COLOR, // "Already Shared"
	DISCONNECT_RAW, // "Disconnect raw"
	TIMEOUT_RAW, // "Timeout raw"
	FAKESHARE_RAW, // "Fake share raw"
	LISTLEN_MISMATCH, // "ListLen mismatch"
	FILELIST_TOO_SMALL, // "Filelist too small"
	FILELIST_UNAVAILABLE, // "Filelist unavailable"
	SET_ACTION, // "Set action:"
	DELETE_CHECKED, // "Delete checked filelists"
	MENU_TOPMOST, // "Always on top"
	LOCK_TOOLBARS, // "Lock Toolbars"
	FAKE_SET, // "Fake share detector"
	RAW_SET, // "Raw commands"
	LOG_CHAT, // "Log chat"
	FAV_PROT_USERS, // "Protected prefixes (wildcards supported, use semicolon to separate entries)"
	SEARCH_DETECT_TTH, // "Automatically switch search type to TTH when one is found in search string"
	NO_DOWNLOADS_FROM_BOT, // "It's no use trying to download from bot"
	ICONS_MODE, // "Icons compatibility mode:"
	ZION_TABS, // "Use Zion styled tabs"
	NON_HUBS_FRONT, // "Place all non-hub tabs in front"
	GLOBAL_MINI_TABS, // "Use mini tabs for all hubs (if enabled the favourite hub properties option is reversed)"
	MINI_TAB, // "Mini tab"
	NORMAL_TAB, // "Normal tab"
	OLD_PW, // "Old password:"
	NEW_PW, // "New password:"
	CONFIRM_NEW_PW, // "Confirm new:"
	BLEND_OFFLINE_SEARCH, // "Blend offline search results"
	MAX_RESIZE_LINES, // "Max resize lines"
	AUTO_OPEN_OP_CHAT, // "Auto-open hub's OP Chat"
	FAKE_DETECT_ADV, // "Advanced Fake Detector Options"
	CHECKER_PREFS, // "Threaded Checking Preferences"
	MAX_FILELISTS, // "Max FileLists"
	CHECKER_DELAY, // "New user delay"
	CHECKER_SLEEP_TIME, // "Sleep time"
	CHECKER_DELAYED_SENDING, // "Use delayed sending of raws"
	ACTION_EXISTS, // "This Action already exists"
	NO_NAME_SPECIFIED, // "No name was specified"
	RAW_EXISTS, // "This Raw already exists"
	ACTION_RAW, // "Action & Raw"
	ACTION_RAW_DLG, // "Action && Raw"
	RAW, // "Raw"
	ADD_ACTION, // "Add / Rename an action"
	NAT_SORT, // "Use natural sorting"
	OP_ONLY, // "OP's Only"
	CHECKING_STARTED, // "Checking started"
	CHECKING_STOPPED, // "Checking stopped"
	INSTALL, // "Install"
	INSTALL_INTRO, // "Welcome to ApexDC++. Please take a moment to choose which actions you would like ApexDC++ to automatically perform."
	INSTALL_INFO, // "ApexDC++ can be removed at any time from Windows \"Add or Remove Programs\""
	INSTALL_NOTE, // "Note: by using this program you acknowledge that you hereby agree to the terms and conditions presented in"
	INSTALL_START, // "Create shortcut on Start menu"
	INSTALL_DESKTOP, // "Create shortcut on desktop"
	INSTALL_QLAUNCH, // "Add shortcut to Quick Launch"
	INSTALL_FIREWALL, // "Add an exception to Windows Firewall (XP SP2+)"
	USE_CUSTOM_LIST_BACKGROUND, // "Use custom list background style"
	FIREWALL_QUESTION, // "Would you like to add an exception for ApexDC++ to your Windows Firewall?"
	COLOR_PROTECTED, // "Protected user"
	USE_FAV_NAMES, // "Use details in favorites to identify hubs"
	REALLY_RUN, // "Are you certain that you wish to run this tool?"
	SETTINGS_PLUGINS, // "Plugins"
	PLUGIN_INFORMATION, // "Plugin information"
	PLUGIN_NAME, // "Name:"
	PLUGIN_VERSION, // "Version:"
	PLUGIN_AUTHOR, // "Author:"
	PLUGIN_DESCRIPTION, // "Description:"
	PLUGIN_WEB, // "Website:"
	PLUGIN_NO_CONFIG, // "This plugin requires no configuration"
	PLUGIN_LOAD, // "Install"
	PLUGIN_CONFIG, // "Configure"
	PLUGIN_UNLOAD, // "Uninstall"
	UPDATER, // "ApexDC++ Updater"
	UPDATER_START, // "Update is being downloaded and installed, you'll be notified again when your attention is required."
	UPDATER_RESTART, // "Update installation successful, would you like to restart ApexDC++ now to complete the update proccess?"
	UPDATER_IN_PROGRESS, // "ApexDC++ is in progress of updating files, please wait a while for it to complete and try again."
	UPDATER_PENDING_RESTART, // "Previous updates are waitting to be applied, please restart ApexDC++ to complete the update proccess."
	UPDATER_FAILED, // "Automatic update failed:"
	UPDATER_END, // "Successfully installed new updates!"
	SYSTEM_LOG, // "System Log"
	LOG_FILE, // "Log to file"
	AUTO_SCROLL, // "Auto scroll"
	DONT_ASK_AGAIN, // "Don't ask me again"
	ALWAYS_ASK, // "Always perform this check"
	DOT_HIDDEN_FILES, // "Treat files with a leading dot as hidden (unix like hidden files)"
	HASH_TOOL_DESC, // "ApexDC++ calculated the following Hashes for the provided file. Generic MAGNET link is also provided for your convenience."
	INVALID_DATA, // "Invalid data"
	NON_UTF8_ADC, // "Non-UTF-8 data in an ADC connection"
	ENABLE_RANDOM_SEGMENTS, // "Select all downloaded segments randomly"
	DBL_CLICK_ACTIONS, // "Double click actions"
	MANDATORY_UPDATE, // "Mandatory Update"
	UPDATE_INSTRUCTIONS, // "ApexDC++ will now forward you to a web page where you can download and install the the required update."
	ENCRYPTED_HUBS, // "Encrypted Hubs (ADC)"
	PREINSTALLED_HUBS, // "Preinstalled Hubs"
	VALUE, // "Value"
	SET, // "Set"
	NOTICE, // "Notice"
	FRAMEHUB_STATUS_HUBSECURE, // "Connections between this hub are secure (%s)"
	FRAMEHUB_STATUS_HUBNOTSECURE, // "Connections between this hub are not secure" 
	FRAMEHUB_STATUS_USERS, // "Total online users"
	FRAMEHUB_STATUS_SHARED, // "Total amount shared in the hub"
	FRAMEHUB_STATUS_AVERAGESHARE, // "Average share size per user"
	HUB_PERMANENT_REDIRECT, // "Permanent redirect received, we are now connected but there are no references to update..."
	HUB_PERMANENT_REDIRECT_UPDATED, // "Permanent redirect received, we are now connected and references have been updated..."
	WARN_SECURE_PASSWORD_REVEAL, // "Automatic password sending has been temporarily disabled for this hub connection. The previously secure ADC password would now be sent in plain text over NMDC. To send passwords automatically to the current hub manual reconnect will be required..."
	SECURITY_CERTIFICATES, // "Security certifcates"
	LAST // @DontAdd
};

