#pragma once
#include <windows.h>

struct SCUPluginInfos
{
	// master SH2 interrupt request
	void   (__cdecl * pfMasterSH2InterruptRequest)(unsigned char vector,unsigned char level);
	// slave SH2 interrupt request
	void   (__cdecl * pfSlaveSH2InterruptRequest)(unsigned char vector,unsigned char level);
	// memory interface for DMA
	unsigned char   (_fastcall * pfReadByte)(unsigned long address);
	unsigned short  (_fastcall * pfReadWord)(unsigned long address);
	unsigned long   (_fastcall * pfReadLong)(unsigned long address);
	void   (_fastcall * pfWriteByte)(unsigned long address,unsigned char data);
	void   (_fastcall * pfWriteWord)(unsigned long address,unsigned short data);
	void   (_fastcall * pfWriteLong)(unsigned long address,unsigned long data);
	// function to write text in the emu's client area
	// color:0x00RRGGBB
	// please do not use "/n" character, use instead multiple calls to function to write multiple lines
	void   (__cdecl * pfWriteText)(char *text,unsigned long color);
	// handle to the application's handle
	HINSTANCE hInstance;
	// pointer to the path of the plugin host executable
	char *hostPath;
	// Plugin version
	// you must return the plugin interface version you implement
	// format: 0xnm for version n.m
	unsigned char version;
};

#if defined(__cplusplus)
extern "C" {
#endif

//////////////////////////////////////
// SCU plugin interface version 1.0 //
//////////////////////////////////////

// called to init the plugin, return true if success
__declspec(dllexport) bool _cdecl InitSCUPlugin(SCUPluginInfos * infos);
// called to deinit the plugin
__declspec(dllexport) void _cdecl DeInitPlugin(void);
// for the about dialog box of the plugin
__declspec(dllexport) void _cdecl DisplayPluginInfo(void);
// must display a dialog box to configure the plugin
__declspec(dllexport) void _cdecl SetupPlugin(void);

// reset
__declspec(dllexport) void _cdecl Reset(void);
// write to SCU registers
__declspec(dllexport) void _fastcall  WriteByteSCURegs(unsigned long address,unsigned char data);
__declspec(dllexport) void _fastcall  WriteWordSCURegs(unsigned long address,unsigned short data);
__declspec(dllexport) void _fastcall  WriteLongSCURegs(unsigned long address,unsigned long data);
// read from SCU registers
__declspec(dllexport) unsigned char _fastcall  ReadByteSCURegs(unsigned long address);
__declspec(dllexport) unsigned short _fastcall  ReadWordSCURegs(unsigned long address);
__declspec(dllexport) unsigned long _fastcall  ReadLongSCURegs(unsigned long address);
// events generating an interrupt maskable by the SCU
// the plugin shall request interrupts to the SH2s if necessary
__declspec(dllexport) void _cdecl SCUOnVblankOut(void);
__declspec(dllexport) void _cdecl SCUOnVblankIn(void);
__declspec(dllexport) void _cdecl SCUOnHblankIn(void);
__declspec(dllexport) void _cdecl SCUOnSpriteDrawEnd(void);
__declspec(dllexport) void _cdecl SCUOnSMPCIntRequest(void);
__declspec(dllexport) void _cdecl SCUOnSCSPIntRequest(void);
__declspec(dllexport) void _cdecl SCUOnPADIntRequest(void);
// function called to process DSP if active and timer1 counting
// the number of cycles to be processed is given in SH2 frequency
// this number should be halved to get corresponding DSP cycles to execute (DSP opperates at 14 Mhz)
// this number should be divided by 4 to get the number to substract to timer1 (timer1 counts at 7 Mhz)
__declspec(dllexport) void _cdecl SCURunCycles(int number);

#if defined(__cplusplus)
}
#endif