;
; PS2 EE kernel syscalls
; set of general macro definitions for ps2 kernel syscalls
;
; (c) wiRe / Napalm 2002
;


; desc: execute file
; in: a0 = ptr on filename string, a1 = number of args, a2 = ptr on args
; waste: v0,v1
SysExecPS2      MACRO   _name, _n, _args
                addiu   v1, zero, 0x07
                syscall
SysExecPS2      ENDM

; desc: load executable file
; in: a0 = ptr on filename string, a1 = number of args, a2 = ptr on args
; waste: v0,v1
SysLoadExecPS2  MACRO   _name, _n, _args
                la      a0, _name
                li      a1, _n
                la      a1, _args
                addiu   v1, zero, 0x06
                syscall
SysLoadExecPS2  ENDM

; desc: leave current process
SysExit         MACRO
                addiu   v1, zero, 0x04
                syscall
SysExit         ENDM



; desc: flush the entire cache. allways assumes param a0 zero
; waste: a0,v0,v1
SysFlushCache   MACRO
                daddu   a0, zero, zero
                addiu   v1, zero, 0x64
                syscall
SysFlushCache   ENDM



; desc: write value a1 into register _reg
; waste: a0,v0,v1
SysSifSetReg    MACRO   _reg
                li      a0, _reg
                addiu   v1, zero, 0x79
                syscall
SysSifSetReg    ENDM

; desc: read register _reg into v0
; waste: a0,v0,v1
SysSifGetReg    MACRO   _reg
                li      a0, _reg
                addiu   v1, zero, 0x7A
                syscall
SysSifGetReg    ENDM



; desc: turn on dmac chn
SysEnableDmac   MACRO   _chn
                addiu   a0, zero, _chn
                addiu   v1, zero, 0x16
                syscall
SysEnableDmac   ENDM

; desc: turn off dmac chn
SysDisableDmac  MACRO   _chn
                addiu   a0, zero, _chn
                addiu   v1, zero, 0x17
                syscall
SysDisableDmac  ENDM



SYS_SEMA_CURRENT_COUNT  EQU 0
SYS_SEMA_MAX_COUNT      EQU 4
SYS_SEMA_INIT_COUNT     EQU 8
SYS_SEMA_NUM_WAIT_THRDS EQU 12
SYS_SEMA_ATTR           EQU 16
SYS_SEMA_OPTION         EQU 20
SYS_SEMA_SIZE_          EQU 24

; desc: create sema
; in: a0 = ptr on SemaParam
SysCreateSema   MACRO
                addiu   v1, zero, 0x40
                syscall
SysCreateSema   ENDM

; desc: delete sema
; in: a0 = sema id
SysDeleteSema   MACRO
                addiu   v1, zero, 0x41
                syscall
SysDeleteSema   ENDM

; desc: signal sema
; in: a0 = sema id
SysSignalSema   MACRO
                addiu   v1, zero, 0x42
                syscall
SysSignalSema   ENDM

; desc: wait sema
; in: a0 = sema id
SysWaitSema     MACRO
                addiu   v1, zero, 0x44
                syscall
SysWaitSema     ENDM
