;
; DMA Lib v1.9
; PS2 DMA routines and macros
;
; Notes:
; - Data is transfered in qword (128bit, 16bytes) units
; - Data should be aligned on qword boundary (.align 7, aligned(16))
;
; (c) Duke / Napalm 2001
; (c) wiRe / Napalm 2002
;


; DMA channel registers
DMA_REG                         EQU         0x1000E000
DMA_STAT                        EQU         0x10

DMA01                           EQU         0x10009000
DMA02                           EQU         0x1000A000
DMA05                           EQU         0x1000C000

DMA_CHCR                        EQU         0x00                                ; GIF Channel Control Register (channel 2)
DMA_MADR                        EQU         0x10                                ; Transfer Address Register
DMA_QWC                         EQU         0x20                                ; Transfer Size Register (in qwords)
DMA_TADR                        EQU         0x30                                ; ...




; desc: waits 'till bit 8 of dma channel control register goes low
; waste: at,v0
Dma02Wait                       PROC
                                li          at, DMA02
  lp:                           lw          v0, DMA_CHCR(at)
                                andi        v0, 0x100
                                bnez        v0, lp
                                nop
                                jr          ra
                                nop
Dma02Wait                       ENDP


; desc: send gif packet over dma02
; in: a0 = packet, v0 = size
; waste: at,v0,v1
Dma02SendGif                    PROC
                                li          at, DMA02
  lp:                           lw          v1, DMA_CHCR(at)
                                andi        v1, 0x100
                                bnez        v1, lp
                                nop
                                sw          v0, DMA_QWC(at)
                                sw          a0, DMA_MADR(at)
                                ori         v0, zero, 101h
                                sw          v0, DMA_CHCR(at)
                                jr          ra
                                nop
Dma02SendGif                    ENDP


; desc: send a chained list of packets over dma
; in: a0 = dma tag
; waste: at,v0
Dma02SendChain                  PROC
                                li          at, DMA02
  lp:                           lw          v0, DMA_CHCR(at)
                                andi        v0, 0x100
                                bnez        v0, lp
                                nop
                                sw          a0, DMA_TADR(at)
                                sw          zero, DMA_QWC(at)
                                addiu       v0, zero, 0x105
                                sw          v0, DMA_CHCR(at)
                                jr          ra
                                nop
Dma02SendChain                  ENDP


; desc: set some dma registers to zero
; waste: at,v0,v1
Dma02Reset                      PROC
                                li          at, DMA02
                                sw          zero, 0x80(at)
                                sw          zero, 0x00(at)
                                sw          zero, 0x30(at)
                                sw          zero, 0x10(at)
                                sw          zero, 0x50(at)
                                sw          zero, 0x40(at)

                                li          at, DMA_REG
                                li          v0, 0xFF1F
                                sw          v0, 0x10(at)
                                lw          v1, 0x10(at)
                                and         v1, v0
                                sw          v1, 0x10(at)

                                sw          zero, 0x00(at)
                                sw          zero, 0x20(at)
                                sw          zero, 0x30(at)
                                sw          zero, 0x50(at)
                                sw          zero, 0x40(at)

                                lw          v0, 0x00(at)
                                ori         v0, 1
                                sw          v0, 0x00(at)

                                jr          ra
                                nop
Dma02Reset                      ENDP
