
// data base to set palette for VS-Unisystem

use_vs_palette = 0;
pad_swap = 0;
vstopgun_ppu = 0;
vstopgun_value = 0;

if(crc32() == 0x70901b25) // VS Slalom
{
  uint8 palette[192] =
  {
    0x00,0x00,0x00,0xff,0xa0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,
    0x60,0xb0,0x00,0x00,0x00,0xe0,0xb0,0xff,0xff,0x78,0x30,0x90,0x40,0xf0,0x00,0x00,
    0x00,0xff,0x60,0xb0,0xe8,0xe8,0xe8,0xd8,0x40,0xc0,0xa0,0xff,0xf0,0x48,0xa8,0x10,
    0x00,0x00,0x00,0x61,0xa0,0xff,0xa0,0x30,0x00,0x00,0x00,0x00,0x48,0xa0,0x68,0x00,
    0x00,0x00,0x00,0x00,0x00,0x50,0x80,0xff,0x00,0x00,0x00,0xf0,0x60,0xff,0x00,0x00,
    0x00,0xa0,0xff,0xc8,0xa0,0xb8,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0xb0,
    0x00,0x00,0x00,0xff,0xd8,0xa0,0xff,0x78,0x30,0xc0,0xb0,0xff,0x40,0x60,0xf8,0x00,
    0x00,0x00,0xb0,0xb0,0xb0,0x50,0x80,0xff,0xd8,0x40,0xc0,0x60,0xd0,0x00,0x78,0x78,
    0x78,0x38,0x68,0x00,0x50,0x80,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
    0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xf0,0x41,0xff,0xa0,0x00,0x30,0x50,0x80,0x20,
    0x00,0xb0,0xd8,0x40,0x60,0x50,0xa0,0x00,0x00,0x00,0x00,0xa0,0xff,0xf0,0x78,0x40,
    0x00,0xff,0xd8,0xa0,0xff,0x00,0xff,0xb0,0x10,0x30,0x00,0x00,0x00,0x00,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0xd5d7eac4) // VS Dr. Mario
{
  uint8 palette[192] =
  {
    0x80,0x80,0x80,0x00,0x00,0xbb,0x37,0x00,0xbf,0x84,0x00,0xa6,0x1e,0x84,0x15,0xff,
    0xff,0xff,0x84,0xbf,0xff,0x91,0x26,0x00,0x7b,0x2b,0x00,0x05,0x05,0x05,0x00,0x48,
    0x0d,0x00,0x3c,0x22,0xff,0x37,0x5e,0x00,0x00,0x00,0x05,0x05,0x05,0x05,0x05,0x05,
    0x6f,0x84,0xff,0x00,0x59,0xff,0x44,0x3c,0xff,0xb7,0x33,0xcc,0xff,0x33,0xaa,0xc4,
    0x62,0x00,0xff,0x37,0x1a,0xd5,0x4b,0x00,0x80,0x80,0x80,0x3c,0x7b,0x00,0x1e,0x84,
    0x15,0x00,0x95,0x66,0x00,0x84,0xc4,0x11,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,
    0xff,0xff,0xff,0x00,0x95,0xff,0x6f,0x84,0xff,0xd5,0x6f,0xff,0xff,0x77,0xcc,0xff,
    0x6f,0x99,0xff,0x7b,0x59,0xff,0x91,0x5f,0xff,0xa2,0x33,0xa6,0xbf,0x00,0x00,0x95,
    0xff,0x4d,0xd5,0xae,0x00,0x59,0xff,0x66,0x66,0x66,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x00,0xd9,0xff,0x84,0xbf,0xff,0xbb,0xbb,0xff,0xd0,0xbb,0xff,0xff,0xbf,0xea,0xff,
    0xbf,0xcc,0xff,0xa2,0x33,0xff,0xcc,0xae,0x00,0x48,0x0d,0xcc,0xe1,0x99,0xbb,0xbb,
    0xff,0xff,0xcc,0xae,0xb3,0xee,0xff,0xdd,0xdd,0xdd,0x11,0x11,0x11,0x11,0x11,0x11
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
  pad_swap = 1;
}

if(crc32() == 0xffbef374) // VS Castlevania
{
  uint8 palette[192] =
  {
    0x00,0x00,0x00,0xff,0xa0,0x00,0x88,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
    0x60,0xb0,0x00,0x00,0x00,0xe0,0xb0,0xff,0xe0,0x50,0x00,0x90,0x40,0xf0,0x00,0x00,
    0x00,0x00,0x00,0x00,0xe8,0xe8,0xe8,0xa0,0x70,0xff,0x00,0x00,0x00,0x30,0x60,0x40,
    0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0x30,0x00,0x00,0x00,0x00,0x48,0xa0,0x68,0x00,
    0x00,0x00,0x00,0x00,0x00,0x50,0x80,0xff,0x00,0x00,0x00,0xf0,0x60,0xff,0x00,0x00,
    0x00,0x00,0x00,0x00,0xa0,0xb8,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x10,0xa0,
    0x00,0x00,0x00,0xff,0xd8,0xa0,0xff,0x78,0x30,0xc0,0xb0,0xff,0x40,0x60,0xf8,0x00,
    0x00,0x00,0xb0,0xb0,0xb0,0x00,0x00,0x00,0xd8,0x40,0xc0,0x00,0x00,0x00,0x78,0x78,
    0x78,0x38,0x68,0x00,0x40,0x40,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
    0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xf0,0x40,0xc0,0x70,0x00,0x30,0x50,0x80,0x20,
    0x00,0xb0,0xd8,0x40,0x60,0x50,0xa0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,
    0x00,0xff,0xd8,0xa0,0x00,0x00,0x00,0xb0,0x10,0x30,0x00,0x00,0x00,0x00,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x8c0c2df5) // VS Top Gun
{
  uint8 palette[192] =
  {
    0x80,0x80,0x80,0x00,0x00,0xbb,0x37,0x00,0xbf,0x84,0x00,0xa6,0x1e,0x84,0x15,0xff,
    0xff,0xff,0x84,0xbf,0xff,0x91,0x26,0x00,0x7b,0x2b,0x00,0x05,0x05,0x05,0x00,0x48,
    0x0d,0x00,0x3c,0x22,0xff,0x37,0x5e,0x00,0x00,0x00,0x05,0x05,0x05,0x05,0x05,0x05,
    0x6f,0x84,0xff,0x00,0x59,0xff,0x44,0x3c,0xff,0xb7,0x33,0xcc,0xff,0x33,0xaa,0xc4,
    0x62,0x00,0xff,0x37,0x1a,0xd5,0x4b,0x00,0x80,0x80,0x80,0x3c,0x7b,0x00,0x1e,0x84,
    0x15,0x00,0x95,0x66,0x00,0x84,0xc4,0x11,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,
    0xff,0xff,0xff,0x00,0x95,0xff,0x6f,0x84,0xff,0xd5,0x6f,0xff,0xff,0x77,0xcc,0xff,
    0x6f,0x99,0xff,0x7b,0x59,0xff,0x91,0x5f,0xff,0xa2,0x33,0xa6,0xbf,0x00,0x00,0x95,
    0xff,0x4d,0xd5,0xae,0x00,0x59,0xff,0x66,0x66,0x66,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x00,0xd9,0xff,0x84,0xbf,0xff,0xbb,0xbb,0xff,0xd0,0xbb,0xff,0xff,0xbf,0xea,0xff,
    0xbf,0xcc,0xff,0xa2,0x33,0xff,0xcc,0xae,0x00,0x48,0x0d,0xcc,0xe1,0x99,0xbb,0xbb,
    0xff,0xff,0xcc,0xae,0xb3,0xee,0xff,0xdd,0xdd,0xdd,0x11,0x11,0x11,0x11,0x11,0x11
  };
  vstopgun_ppu = 1;
  vstopgun_value = 0;
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x135adf7c) // VS Atari RBI Baseball
{
  uint8 palette[192] =
  {
    0x78,0x78,0x78,0xFF,0xA0,0x00,0xE0,0x50,0x00,0xFF,0x00,0x00,0x30,0x50,0x80,0x30,
    0x60,0x40,0xFF,0x00,0x00,0xE0,0xB0,0xFF,0xFF,0x00,0x00,0x78,0x78,0x78,0xFF,0xA0,
    0x00,0xFF,0xFF,0xFE,0x98,0x20,0x78,0xE8,0xD0,0x20,0xFF,0x00,0x00,0x30,0x60,0x40,
    0x60,0xA0,0xFF,0xFF,0x00,0x00,0x00,0x30,0x00,0x98,0xE8,0x00,0x48,0xA0,0x68,0xFF,
    0x00,0x00,0xFF,0x00,0x00,0x40,0x40,0xFF,0xFF,0x00,0x00,0xA0,0xFF,0xF0,0x01,0x00,
    0x00,0xFF,0x00,0x00,0xE8,0xE8,0xE8,0xB0,0xB0,0xB0,0xFF,0x00,0x00,0x60,0x10,0xA0,
    0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0xC0,0xB0,0xFF,0x40,0x60,0x00,0x30,
    0x50,0x80,0x48,0xA0,0x68,0xFF,0x00,0x00,0xD8,0x40,0xC0,0xFF,0x00,0x00,0x78,0x78,
    0x78,0xA0,0x30,0x00,0x40,0x40,0xFF,0x20,0x00,0xB0,0xFF,0x78,0x30,0xFF,0xFF,0xFF,
    0x00,0x00,0x00,0x50,0x9F,0x00,0xFF,0x00,0x00,0x30,0x60,0x40,0x30,0x50,0x80,0xFF,
    0x00,0x00,0xA0,0xFF,0xF0,0xC0,0x70,0x00,0xFF,0x00,0x00,0x40,0x60,0xF8,0x30,0x60,
    0x40,0xFF,0x00,0x00,0xFC,0xF0,0x90,0xFF,0x00,0x00,0x88,0x88,0x00,0xFF,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
  pad_swap = 1;
}

if(crc32() == 0xeb2dba63) // VS TKO Boxing
{
  uint8 palette[192] =
  {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0xb0,0xb0,0x00,0x00,0x00,0xff,
    0xff,0xff,0x90,0xd0,0xff,0x00,0x00,0x00,0x20,0x00,0xb0,0x00,0x00,0x00,0xff,0xc8,
    0xb8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0xff,0xf0,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xff,0x50,0xa0,0x00,0x00,
    0x00,0x00,0xc0,0x70,0x00,0x00,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x00,0x00,0x00,
    0x00,0x28,0x00,0xb8,0xe0,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xd8,0xa0,0x00,0x00,0x00,0xff,
    0xa0,0x00,0xff,0x78,0x30,0xe8,0xe8,0xe8,0x00,0x00,0x00,0x98,0x20,0x78,0x50,0x80,
    0xff,0x00,0x00,0x00,0x40,0x60,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x60,0xd0,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0x70,
    0xf0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0xff,0xf0,0x90,0x90,0x40,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x50,0x80
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0xcf36261e) // VS Super Sky Kid
{
  uint8 palette[192] =
  {
    0x80,0x80,0x80,0x00,0x00,0xbb,0xff,0x37,0x1a,0x84,0x00,0xa6,0xbb,0x00,0x6a,0xb7,
    0x00,0x1e,0xb3,0x00,0x00,0x91,0x26,0x00,0xff,0xff,0xff,0xc8,0xc8,0xc8,0x00,0x48,
    0x0d,0x00,0x3c,0x22,0x00,0x2f,0x66,0x00,0x00,0x00,0x05,0x05,0x05,0x05,0x05,0x05,
    0xb3,0xee,0xff,0xff,0x37,0x1a,0x44,0x3c,0xff,0xb7,0x33,0xcc,0xff,0x33,0xaa,0xff,
    0x37,0x5e,0xff,0x37,0x1a,0x44,0x3c,0xff,0xc4,0x62,0x00,0x3c,0x7b,0x00,0x05,0x05,
    0x05,0x00,0x95,0x66,0x00,0x84,0xc4,0x11,0x11,0x11,0x09,0x09,0x09,0x00,0x00,0xbb,
    0xff,0xff,0xff,0x00,0x95,0xff,0x6f,0x84,0xff,0x51,0xd9,0x6a,0xff,0x77,0xcc,0x80,
    0x80,0x80,0xff,0x7b,0x59,0xff,0x91,0x5f,0xff,0xa2,0x33,0xa6,0xbf,0x00,0x51,0xd9,
    0x6a,0xb3,0x00,0x00,0x00,0xd9,0xff,0x66,0x66,0x66,0xff,0x7b,0x59,0x0d,0x0d,0x0d,
    0xff,0xff,0xff,0x84,0xbf,0xff,0xbb,0xbb,0xff,0xd0,0xbb,0xff,0xff,0xbf,0xea,0xff,
    0xbf,0xcc,0xff,0xcc,0xae,0xff,0xcc,0xae,0xff,0xd9,0xa2,0x00,0x59,0xff,0x1e,0x84,
    0x15,0xaa,0xf7,0xee,0xb3,0xee,0xff,0xdd,0xdd,0xdd,0x11,0x11,0x11,0x11,0x11,0x11
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
  pad_swap = 1;
}

if(crc32() == 0x17ae56be) // VS Freedom Force
{
  uint8 palette[192] =
  {
    0xFF,0xB8,0xE8,0x00,0x00,0x00,0xE0,0x50,0x00,0x50,0x80,0xFF,0x40,0x90,0xC0,0x38,
    0x68,0x00,0x00,0xF7,0x00,0xD8,0x40,0x60,0xE8,0xE8,0xE8,0x78,0x78,0x78,0xFF,0xA0,
    0x00,0xB0,0x10,0x30,0x00,0x00,0x00,0xE8,0xD0,0x20,0x48,0x58,0x00,0xFF,0xFF,0xFF,
    0x60,0xA0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x98,0xE8,0x00,0x00,0xFE,0x00,0xA0,
    0xB8,0xFF,0xFF,0xC8,0xB8,0x40,0x40,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0xB0,
    0x00,0x00,0x00,0x90,0xD0,0xFF,0x00,0x00,0x00,0xA0,0xFF,0xF0,0x60,0xD0,0xE0,0x30,
    0x50,0x80,0x48,0xA0,0x68,0x00,0xF1,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0x00,0x00,
    0x00,0xA0,0x30,0x00,0x00,0x00,0x00,0x28,0x00,0xB8,0xFF,0x78,0x30,0x00,0x00,0x00,
    0x00,0x00,0x00,0x50,0xA0,0x00,0xB0,0xB0,0xB0,0x00,0x00,0x00,0xC8,0xF0,0x80,0x60,
    0x10,0xA0,0xFF,0xD8,0xA0,0xC0,0x70,0x00,0x00,0x00,0x00,0x40,0x60,0xF8,0x48,0xA8,
    0x10,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x60,0xB0,0x88,0x88,0x00,0x00,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0xe2c0a2be) // VS Platoon
{
  uint8 palette[192] =
  {
    0x80,0x80,0x80,0x00,0x00,0xbb,0x37,0x00,0xbf,0x84,0x00,0xa6,0xbb,0x00,0x6a,0x00,
    0x3e,0x00,0xb3,0x00,0x00,0xff,0x37,0x5e,0xff,0xff,0xff,0x00,0x3e,0x00,0x00,0x48,
    0x0d,0xb7,0x00,0x1e,0x00,0x2f,0x66,0xff,0xa2,0x33,0x05,0x05,0x05,0xff,0xff,0xff,
    0x00,0x95,0xff,0x00,0x59,0xff,0x44,0x3c,0xff,0xff,0xff,0xff,0xff,0x33,0xaa,0xff,
    0x37,0x5e,0xff,0x37,0x1a,0xd5,0x4b,0x00,0xc4,0x62,0x00,0x3c,0x7b,0x00,0x1e,0x84,
    0x15,0x00,0x95,0x66,0x00,0x84,0xc4,0x11,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,
    0xff,0xff,0xff,0x00,0x95,0xff,0x6f,0x84,0xff,0xd5,0x6f,0xff,0xff,0x77,0xcc,0x00,
    0x2f,0x66,0xff,0x7b,0x59,0xff,0x91,0x5f,0xff,0xa2,0x33,0x91,0x26,0x00,0x51,0xd9,
    0x6a,0x4d,0xd5,0xae,0x00,0xd9,0xff,0x66,0x66,0x66,0xff,0x7b,0x59,0x05,0x05,0x05,
    0xff,0xff,0xff,0x3c,0x7b,0x00,0xbb,0xbb,0xff,0x00,0x48,0x0d,0xff,0xbf,0xea,0xff,
    0xbf,0xcc,0xff,0xc4,0xb7,0xff,0x37,0x1a,0xff,0xd9,0xa2,0x00,0x59,0xff,0xae,0xee,
    0xb7,0xaa,0xf7,0xee,0xb3,0xee,0xff,0xdd,0xdd,0xdd,0xc4,0x62,0x00,0x11,0x11,0x11
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0xcbe85490) // VS Excitebike
{
  uint8 palette[192] =
  {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0xa8,0x10,0xff,
    0xff,0xff,0xa0,0xff,0xf0,0x38,0x68,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
    0xa0,0xb8,0xff,0x40,0x90,0xc0,0x00,0x00,0x00,0x40,0x40,0xff,0x00,0x00,0x00,0x88,
    0x88,0x00,0xc0,0x70,0x00,0x00,0x00,0x00,0x30,0x50,0x80,0x00,0x00,0x00,0x00,0x00,
    0x00,0x28,0x00,0xb8,0xe0,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xd8,0xa0,0x00,0x00,0x00,0xe8,
    0xd0,0x20,0xff,0xa0,0x00,0x00,0x00,0x00,0x98,0xe8,0x00,0x00,0x00,0x00,0x60,0xa0,
    0xff,0x00,0x00,0x00,0x40,0x60,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x90,0xd0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,
    0xf0,0x40,0xe8,0xd0,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x90,0x40,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x29155e0c) // VS Excitebike (Alt)
{
  uint8 palette[192] =
  {
    0x88,0x88,0x00,0x60,0x10,0xA0,0x40,0x90,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x20,0x00,0xB0,0xC0,0x70,0x00,0xB0,0xB0,0xB0,0x00,0x00,0x00,0x70,0xF0,
    0x40,0x00,0x00,0x00,0xFF,0xC8,0xB8,0xFF,0xD8,0xA0,0x48,0xA8,0x10,0xC8,0xF0,0x80,
    0xFF,0x60,0xB0,0x00,0x00,0x00,0x40,0x40,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xFF,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x80,
    0xFF,0x50,0xA0,0x00,0x98,0x20,0x78,0x00,0x00,0x00,0xA0,0xF0,0xA0,0x60,0xA0,0xFF,
    0x00,0x00,0x00,0x38,0x6C,0x00,0x78,0x40,0x00,0xA0,0x30,0x00,0x90,0x40,0xF0,0x00,
    0x00,0x00,0x78,0x78,0x78,0xD8,0x40,0x60,0x30,0x50,0x80,0x00,0x00,0x00,0x40,0x60,
    0xF8,0x75,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x90,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0xE0,0x50,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xFF,0xFF,0xFF,0xA0,0xFF,0xF0,0x00,0x00,0x00,0xFF,0xA0,0x00,0xA0,0x70,
    0xFF,0x90,0xD0,0xFF,0x98,0xE8,0x00,0x00,0x00,0x00,0xA0,0xB8,0xFF,0x38,0x68,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0xff5135a3) // VS Hogan's Alley
{
  uint8 palette[192] =
  {
    0xff,0xb8,0xe8,0x00,0x00,0x00,0xe0,0x50,0x00,0x50,0x80,0xff,0x40,0x90,0xc0,0x00,
    0x00,0x00,0x00,0x00,0x00,0xd8,0x40,0x60,0x00,0x00,0x00,0x78,0x78,0x78,0xff,0xa0,
    0x00,0xb0,0x10,0x30,0x98,0x20,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
    0x60,0xa0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x98,0xe8,0x00,0xa0,0xff,0xf0,0x00,
    0x00,0x00,0xff,0xc8,0xb8,0x40,0x40,0xff,0x00,0x00,0x00,0x70,0xe0,0x90,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0xb0,
    0x00,0x00,0x00,0x90,0xd0,0xff,0x00,0x00,0x00,0x70,0xf0,0x40,0x60,0xd0,0xe0,0x30,
    0x50,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0xe0,0xb0,
    0xff,0xa0,0x30,0x00,0x00,0x00,0x00,0xff,0x60,0xb0,0xff,0x78,0x30,0x00,0x00,0x00,
    0x00,0x00,0x00,0x50,0xa0,0x00,0xb0,0xb0,0xb0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xc0,0x70,0x00,0x00,0x00,0x00,0x40,0x60,0xf8,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x60,0xb0,0x88,0x88,0x00,0x00,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x07138c06) // VS Clu Clu Land
{
  uint8 palette[192] =
  {
    0x88,0x88,0x00,0x60,0x10,0xA0,0x40,0x90,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x20,0x00,0xB0,0xC0,0x70,0x00,0xB0,0xB0,0xB0,0x00,0x00,0x00,0x70,0xF0,
    0x40,0x00,0x00,0x00,0xFF,0xC8,0xB8,0xFF,0xD8,0xA0,0x48,0xA8,0x10,0xC8,0xF0,0x80,
    0xFF,0x60,0xB0,0x00,0x00,0x00,0x40,0x40,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xFF,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x80,
    0xFF,0x50,0xA0,0x00,0x98,0x20,0x78,0x00,0x00,0x00,0xA0,0xF0,0xA0,0x60,0xA0,0xFF,
    0x00,0x00,0x00,0x38,0x6C,0x00,0x78,0x40,0x00,0xA0,0x30,0x00,0x90,0x40,0xF0,0x00,
    0x00,0x00,0x78,0x78,0x78,0xD8,0x40,0x60,0x30,0x50,0x80,0x00,0x00,0x00,0x40,0x60,
    0xF8,0x75,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x90,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0xE0,0x50,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xFF,0xFF,0xFF,0xA0,0xFF,0xF0,0x00,0x00,0x00,0xFF,0xA0,0x00,0xA0,0x70,
    0xFF,0x90,0xD0,0xFF,0x98,0xE8,0x00,0x00,0x00,0x00,0xA0,0xB8,0xFF,0x38,0x68,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x43a357ef) // VS Ice Climber
{
  uint8 palette[192] =
  {
    0x88,0x88,0x00,0x60,0x10,0xA0,0x40,0x90,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x20,0x00,0xB0,0xC0,0x70,0x00,0xB0,0xB0,0xB0,0x00,0x00,0x00,0x70,0xF0,
    0x40,0x00,0x00,0x00,0xFF,0xC8,0xB8,0xFF,0xD8,0xA0,0x48,0xA8,0x10,0xC8,0xF0,0x80,
    0xFF,0x60,0xB0,0x00,0x00,0x00,0x40,0x40,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xFF,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x80,
    0xFF,0x50,0xA0,0x00,0x98,0x20,0x78,0x00,0x00,0x00,0xA0,0xF0,0xA0,0x60,0xA0,0xFF,
    0x00,0x00,0x00,0x38,0x6C,0x00,0x78,0x40,0x00,0xA0,0x30,0x00,0x90,0x40,0xF0,0x00,
    0x00,0x00,0x78,0x78,0x78,0xD8,0x40,0x60,0x30,0x50,0x80,0x00,0x00,0x00,0x40,0x60,
    0xF8,0x75,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x90,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0xE0,0x50,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xFF,0xFF,0xFF,0xA0,0xFF,0xF0,0x00,0x00,0x00,0xFF,0xA0,0x00,0xA0,0x70,
    0xFF,0x90,0xD0,0xFF,0x98,0xE8,0x00,0x00,0x00,0x00,0xA0,0xB8,0xFF,0x38,0x68,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x8192c804) // VS Super Mario Bros
{
  uint8 palette[192] =
  {
    0x88,0x88,0x00,0x00,0x00,0x00,0x40,0x90,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x30,0x60,0x40,0xc0,0x70,0x00,0xb0,0xb0,0xb0,0x00,0x00,0x00,0xd8,0x40,
    0xc0,0x00,0x00,0x00,0xff,0xc8,0xb8,0xff,0xd8,0xa0,0x48,0xa8,0x10,0x00,0x00,0x00,
    0xff,0x60,0xb0,0x00,0x00,0x00,0x40,0x40,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x80,
    0xff,0x50,0xa0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0xf0,0xa0,0x60,0xa0,0xff,
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x78,0x78,0x78,0xd8,0x40,0x60,0x30,0x50,0x80,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0xe0,0x50,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xff,0xff,0xff,0xa0,0xff,0xf0,0x00,0x00,0x00,0xff,0xa0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x98,0xe8,0x00,0x00,0x00,0x00,0x48,0xa0,0x68,0x38,0x68,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x8b60cc58) // VS Super Skater (Bootleg)
{
  uint8 palette[192] =
  {
    0x88,0x88,0x00,0x00,0x00,0x00,0x40,0x90,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x30,0x60,0x40,0xc0,0x70,0x00,0xb0,0xb0,0xb0,0x00,0x00,0x00,0xd8,0x40,
    0xc0,0x00,0x00,0x00,0xff,0xc8,0xb8,0xff,0xd8,0xa0,0x48,0xa8,0x10,0x00,0x00,0x00,
    0xff,0x60,0xb0,0x00,0x00,0x00,0x40,0x40,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x80,
    0xff,0x50,0xa0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0xf0,0xa0,0x60,0xa0,0xff,
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x78,0x78,0x78,0xd8,0x40,0x60,0x30,0x50,0x80,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0xe0,0x50,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xff,0xff,0xff,0xa0,0xff,0xf0,0x00,0x00,0x00,0xff,0xa0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x98,0xe8,0x00,0x00,0x00,0x00,0x48,0xa0,0x68,0x38,0x68,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0xec461db9) // VS Pinball
{
  uint8 palette[192] =
  {
    0xFF,0xB8,0xE8,0x00,0x00,0x00,0xE0,0x50,0x00,0x00,0x00,0x00,0x40,0x90,0xC0,0x00,
    0x00,0x00,0x00,0x00,0x00,0xFF,0x60,0xB0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xA0,
    0x00,0xB0,0x10,0x30,0x98,0x20,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
    0x60,0xA0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xFF,0xC8,0xB8,0x40,0x40,0xFF,0xA7,0x00,0x00,0x70,0xE0,0x90,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x90,0xD0,0xFF,0x00,0x00,0x00,0x70,0xF0,0x40,0x60,0xD0,0xE0,0x30,
    0x50,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0xE0,0xB0,
    0xFF,0xA0,0x30,0x00,0x00,0x00,0x00,0xFF,0x60,0xB0,0xFF,0x78,0x30,0x00,0x00,0x00,
    0x00,0x00,0x00,0x50,0xA0,0x00,0xB0,0xB0,0xB0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xFF,0xD8,0xA0,0xC0,0x70,0x00,0x00,0x00,0x00,0x60,0xA0,0xFF,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x60,0xB0,0x88,0x88,0x00,0x00,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0xe528f651) // VS Pinball (Alt)
{
  pad_swap = 2;
}

if(crc32() == 0x0b65a917) // VS Mach Rider
{
  uint8 palette[192] =
  {
	0x00,0x00,0x00,0xFF,0xA0,0x00,0x88,0x88,0x00,0x00,0x00,0x00,0xA0,0xF0,0xA0,0xFF,
	0x60,0xB0,0x00,0x00,0x00,0x90,0xD0,0xFF,0xE0,0x50,0x00,0x90,0x40,0xF0,0xFF,0xF0,
	0x90,0xE0,0xB0,0xFF,0xE8,0xE8,0xE8,0xA0,0x70,0xFF,0x00,0x00,0x00,0x30,0x60,0x40,
	0x00,0x00,0x00,0x60,0xA0,0xFF,0xA0,0x30,0x00,0x00,0x00,0x00,0x48,0xA0,0x68,0x98,
	0xE8,0x00,0x00,0x00,0x00,0x50,0x80,0xFF,0x00,0x00,0x00,0xF0,0x60,0xFF,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x58,0x00,0x00,0x00,0x00,0x60,0x10,0xA0,
	0x00,0x00,0x00,0xFF,0xC8,0xB8,0xFF,0x78,0x30,0xC0,0xB0,0xFF,0x40,0x60,0xF8,0x00,
	0x00,0x00,0xB0,0xB0,0xB0,0x28,0x00,0xB8,0xD8,0x40,0xC0,0x00,0x00,0x00,0x78,0x78,
	0x78,0x38,0x68,0x00,0x40,0x40,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
	0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xF0,0x40,0xC0,0x70,0x00,0x30,0x50,0x80,0x20,
	0x00,0xB0,0xD8,0x40,0x60,0x50,0xA0,0x00,0x00,0x00,0x00,0x60,0xD0,0xE0,0x78,0x40,
	0x00,0xFF,0xD8,0xA0,0x00,0x00,0x00,0xB0,0x10,0x30,0x00,0x00,0x00,0x00,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0xcc2c4b5d || // VS Stroke and Match Golf
   crc32() == 0x86167220)   // VS Stroke and Match Golf (Ladies Edition)
{
  uint8 palette[192] =
  {
    0x80,0x80,0x80,0xff,0x91,0x5f,0x37,0x00,0xbf,0x84,0x00,0xa6,0xbb,0x00,0x6a,0xb7,
    0x00,0x1e,0xb3,0x00,0x00,0x91,0x26,0x00,0xff,0x6f,0x99,0x00,0x3e,0x00,0x00,0x48,
    0x0d,0x00,0x3c,0x22,0x00,0x2f,0x66,0x00,0x00,0x00,0x05,0x05,0x05,0x3c,0x7b,0x00,
    0xc8,0xc8,0xc8,0x00,0x95,0xff,0x44,0x3c,0xff,0xb7,0x33,0xcc,0xff,0x33,0xaa,0xa6,
    0xbf,0x00,0xff,0x37,0x1a,0xd5,0x4b,0x00,0xc4,0x62,0x00,0x05,0x05,0x05,0x1e,0x84,
    0x15,0x00,0x95,0x66,0x00,0x84,0xc4,0x11,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,
    0xff,0xff,0xff,0xff,0xc4,0xb7,0x6f,0x84,0xff,0xd5,0x6f,0xff,0xff,0x77,0xcc,0xff,
    0x6f,0x99,0xc8,0xc8,0xc8,0xff,0x91,0x5f,0xff,0xa2,0x33,0xa6,0xbf,0x00,0x51,0xd9,
    0x6a,0x4d,0xd5,0xae,0xff,0xff,0xff,0x05,0x05,0x05,0x0d,0x0d,0x0d,0xff,0xff,0xff,
    0xff,0xff,0xff,0x84,0xbf,0xff,0xbb,0xbb,0xff,0xd0,0xbb,0xff,0xff,0xbf,0xea,0x00,
    0x00,0xbb,0xff,0xc4,0xb7,0xff,0xcc,0xae,0xff,0xd9,0xa2,0xcc,0xe1,0x99,0x91,0x26,
    0x00,0xaa,0xf7,0xee,0xb3,0xee,0xff,0xdd,0xdd,0xdd,0x11,0x11,0x11,0x11,0x11,0x11
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x46914e3e) // VS Soccer
{
  uint8 palette[192] =
  {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0xb0,0xb0,0x00,0x00,0x00,0xff,
    0xff,0xff,0x90,0xd0,0xff,0x00,0x00,0x00,0x20,0x00,0xb0,0x00,0x00,0x00,0xff,0xc8,
    0xb8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0xff,0xf0,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xff,0x50,0xa0,0x00,0x00,
    0x00,0x00,0xc0,0x70,0x00,0x00,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x00,0x00,0x00,
    0x00,0x28,0x00,0xb8,0xe0,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xd8,0xa0,0x00,0x00,0x00,0xff,
    0xa0,0x00,0xff,0x78,0x30,0xe8,0xe8,0xe8,0x00,0x00,0x00,0x98,0x20,0x78,0x50,0x80,
    0xff,0x00,0x00,0x00,0x40,0x60,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x60,0xd0,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0x70,
    0xf0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0xff,0xf0,0x90,0x90,0x40,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x50,0x80
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x70433f2c || // VS Battle City
   crc32() == 0x8d15a6e6)   // VS Battle City (Bootleg)
{
  uint8 palette[192] =
  {
    0x78,0x78,0x78,0xFF,0xA0,0x00,0xE0,0x50,0x00,0xFF,0xFF,0xFE,0x30,0x50,0x80,0x30,
    0x60,0x40,0x00,0x00,0x00,0xE0,0xB0,0xFF,0xFF,0xFF,0xFF,0x78,0x78,0x78,0xFF,0xA0,
    0x00,0xFF,0xFF,0xFE,0x98,0x20,0x78,0xA0,0x70,0xFF,0xFF,0xFF,0xFE,0x30,0x60,0x40,
    0xFF,0xFF,0xFE,0xFF,0xFF,0xFE,0x00,0x30,0x00,0x98,0xE8,0x00,0x48,0xA0,0x68,0x00,
    0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xFF,0x00,0x00,0x00,0xA0,0xFF,0xF0,0x00,0x00,
    0x00,0x00,0x00,0x00,0xE8,0xE8,0xE8,0xB0,0xB0,0xB0,0xFF,0xFF,0xFE,0x60,0x10,0xA0,
    0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x00,0xFF,0xC0,0xB0,0xFF,0x40,0x60,0x00,0x30,
    0x50,0x80,0x48,0xA0,0x68,0x00,0x00,0x00,0xD8,0x40,0xC0,0x00,0x00,0x00,0x78,0x78,
    0x78,0xA0,0x30,0x00,0x40,0x40,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFE,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x38,0x6C,0x00,0x30,0x50,0x80,0x00,
    0x00,0x00,0xA0,0xFF,0xF0,0xC0,0x70,0x00,0x00,0x00,0x00,0x20,0x00,0xB0,0x30,0x60,
    0x40,0x00,0x00,0x00,0xFC,0xF0,0x90,0x00,0x00,0x00,0x88,0x88,0x00,0xFF,0xFF,0xFE
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x8850924b) // VS Tetris
{
  uint8 palette[192] =
  {
    0x78,0x78,0x78,0xFF,0xA0,0x00,0xE0,0x50,0x00,0xFF,0xFF,0xFE,0x30,0x50,0x80,0x30,
    0x60,0x40,0x00,0x00,0x00,0xE0,0xB0,0xFF,0xFF,0xFF,0xFF,0x78,0x78,0x78,0xFF,0xA0,
    0x00,0xFF,0xFF,0xFE,0x98,0x20,0x78,0xA0,0x70,0xFF,0xFF,0xFF,0xFE,0x30,0x60,0x40,
    0xFF,0xFF,0xFE,0xFF,0xFF,0xFE,0x00,0x30,0x00,0x98,0xE8,0x00,0x48,0xA0,0x68,0x00,
    0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xFF,0x00,0x00,0x00,0xA0,0xFF,0xF0,0x00,0x00,
    0x00,0x00,0x00,0x00,0xE8,0xE8,0xE8,0xB0,0xB0,0xB0,0xFF,0xFF,0xFE,0x60,0x10,0xA0,
    0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x00,0xFF,0xC0,0xB0,0xFF,0x40,0x60,0x00,0x30,
    0x50,0x80,0x48,0xA0,0x68,0x00,0x00,0x00,0xD8,0x40,0xC0,0x00,0x00,0x00,0x78,0x78,
    0x78,0xA0,0x30,0x00,0x40,0x40,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFE,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x38,0x6C,0x00,0x30,0x50,0x80,0x00,
    0x00,0x00,0xA0,0xFF,0xF0,0xC0,0x70,0x00,0x00,0x00,0x00,0x20,0x00,0xB0,0x30,0x60,
    0x40,0x00,0x00,0x00,0xFC,0xF0,0x90,0x00,0x00,0x00,0x88,0x88,0x00,0xFF,0xFF,0xFE
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
  pad_swap = 1;
}

if(crc32() == 0xd99a2087) // VS Gradius
{
  uint8 palette[192] =
  {
    0xff,0xb8,0xe8,0x00,0x00,0x00,0xe0,0x50,0x00,0x00,0x00,0x00,0x40,0x90,0xc0,0x00,
    0x00,0x00,0x00,0x00,0x00,0xd8,0x40,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xa0,
    0x00,0xb0,0x10,0x30,0x98,0x20,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
    0x60,0xa0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xff,0xc8,0xb8,0x40,0x40,0xff,0x00,0x00,0x00,0x70,0xe0,0x90,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x90,0xd0,0xff,0x00,0x00,0x00,0x70,0xf0,0x40,0x60,0xd0,0xe0,0x30,
    0x50,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0xe0,0xb0,
    0xff,0xa0,0x30,0x00,0x00,0x00,0x00,0xff,0x60,0xb0,0xff,0x78,0x30,0x00,0x00,0x00,
    0x00,0x00,0x00,0x50,0xa0,0x00,0xb0,0xb0,0xb0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xc0,0x70,0x00,0x00,0x00,0x00,0x40,0x60,0xf8,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x88,0x88,0x00,0x00,0x00,0x00
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

if(crc32() == 0x1e438d52) // VS the Goonies
{
  uint8 palette[192] =
  {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0xb0,0xb0,0x00,0x00,0x00,0xff,
    0xff,0xff,0x90,0xd0,0xff,0x00,0x00,0x00,0x20,0x00,0xb0,0x00,0x00,0x00,0xff,0xc8,
    0xb8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0xff,0xf0,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xff,0x50,0xa0,0x00,0x00,
    0x00,0x00,0xc0,0x70,0x00,0x00,0x00,0x00,0x78,0x78,0x78,0x00,0x00,0x00,0x00,0x00,
    0x00,0x28,0x00,0xb8,0xe0,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xd8,0xa0,0x00,0x00,0x00,0xff,
    0xa0,0x00,0xff,0x78,0x30,0xe8,0xe8,0xe8,0x00,0x00,0x00,0x98,0x20,0x78,0x50,0x80,
    0xff,0x00,0x00,0x00,0x40,0x60,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x60,0xd0,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x00,0x70,
    0xf0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0xff,0xf0,0x90,0x90,0x40,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x50,0x80
  };
  memcpy(vs_palette, palette, 192);
  use_vs_palette = 1;
  calculate_palette();
  scr_mgr->assert_palette();
}

