#include "config.h"

#if WITH_VERTEX_SHADER

#include <stdio.h>
#include <GL/glew.h>
#include <Cg/cg.h>
#include <Cg/cgGL.h>
#include "ogl_shaders.h"


static CGprofile profile;
static CGcontext Context = NULL;
static CGprogram vertex_program = NULL;
static CGprogram fragment_program = NULL;
CGparameter vs_projection_mtx = NULL;
CGparameter vs_modelview_mtx = NULL;
CGparameter vs_texture_mtx[8];
CGparameter	vs_normal_mtx = NULL;
CGparameter	light_enabled[8];
CGparameter	lighting = NULL;

static void CheckCgError(void)
{
  CGerror err = cgGetError();

  if (err != CG_NO_ERROR)
   {
     printf("CG error: %s\n", cgGetErrorString(err));
     exit(1);
   }
}

CGprogram ogls_compile_program(CGprofile prof, const char *program_source_filename)
{
	CGprogram program;
	program = cgCreateProgramFromFile(Context, CG_SOURCE, program_source_filename, prof, NULL, NULL);
	CheckCgError();

//	fprintf(stderr, "LAST LISTING----%s----\n", cgGetLastListing(Context));
//	fprintf(stderr, "---- PROGRAM BEGIN ----\n%s---- PROGRAM END ----\n", cgGetProgramString(program, CG_COMPILED_PROGRAM));
	return program;
}
#define CWD ""

#define VS_REQUIRED_PROFILE	CG_PROFILE_ARBVP1

void ogl_init_shaders(void)
{
	if (cgGLIsProfileSupported(CG_PROFILE_VP30))
	{
		printf("Vertex Shaders 2.0 profile supported\n");
//		profile = CG_PROFILE_VP20;
	}
	if (cgGLIsProfileSupported(CG_PROFILE_VP20))
	{
		printf("Vertex Shaders 1.0 profile supported\n");
//		profile = CG_PROFILE_VP20;
	}
	if (cgGLIsProfileSupported(CG_PROFILE_ARBVP1))
	{
		printf("ARB Vertex 1.0 profile supported\n");
		profile = CG_PROFILE_ARBVP1;
	}
	else
	{
		fprintf(stderr, "Video card does not support vertex programs, exiting...\n");
		exit(-1);
	}

/*	if (cgGLIsProfileSupported(CG_PROFILE_FP30))
	{
		printf("Fragment Shaders 2.0 profile supported\n");
	}
*/

	Context = cgCreateContext();
	CheckCgError();

	vertex_program = ogls_compile_program(profile, "global_vertex_shader.cg");
//	fragment_program = ogls_compile_program(CG_PROFILE_FP30, "global_fragment_shader.cg");
//	fragment_program = ogls_compile_program(CG_PROFILE_ARBFP1, "global_fragment_shader.cg");
    cgGLLoadProgram(vertex_program);
    CheckCgError();

    vs_modelview_mtx	= cgGetNamedParameter(vertex_program, "vs_modelview_mtx");
	vs_projection_mtx	= cgGetNamedParameter(vertex_program, "vs_projection_mtx");
	vs_texture_mtx[0]	= cgGetNamedParameter(vertex_program, "vs_texture_mtx0");
	vs_texture_mtx[1]	= cgGetNamedParameter(vertex_program, "vs_texture_mtx1");
	vs_texture_mtx[2]	= cgGetNamedParameter(vertex_program, "vs_texture_mtx2");
	vs_texture_mtx[3]	= cgGetNamedParameter(vertex_program, "vs_texture_mtx3");
	vs_texture_mtx[4]	= cgGetNamedParameter(vertex_program, "vs_texture_mtx4");
	vs_texture_mtx[5]	= cgGetNamedParameter(vertex_program, "vs_texture_mtx5");
	vs_texture_mtx[6]	= cgGetNamedParameter(vertex_program, "vs_texture_mtx6");
	vs_texture_mtx[7]	= cgGetNamedParameter(vertex_program, "vs_texture_mtx7");
	vs_normal_mtx		= cgGetNamedParameter(vertex_program, "vs_normal_mtx");

	for(int i = 0 ; i < 8 ; i++)
	{
		char tmpname[20];
		sprintf(tmpname, "light%denabled", i);
		light_enabled[i] = cgGetNamedParameter(vertex_program, tmpname); 
	}
	lighting			= cgGetNamedParameter(vertex_program, "lighting");
    CheckCgError();


	cgGLBindProgram(vertex_program);
	CheckCgError();
/*
    cgGLLoadProgram(fragment_program);
    CheckCgError();
	cgGLBindProgram(fragment_program);
	CheckCgError();
	cgGLEnableProfile(CG_PROFILE_FP30);
	CheckCgError();
*/

/*  cgGLSetStateMatrixParameter(ModelViewProjParam, CG_GL_MODELVIEW_PROJECTION_MATRIX,
                                CG_GL_MATRIX_IDENTITY);

*/

//	cgGLEnableProfile(profile);
//	CheckCgError();
	ogl_enable_shader();

}

void ogl_disable_shader(void)
{
	cgGLDisableProfile(profile);
	CheckCgError();
}

void ogl_enable_shader(void)
{
	cgGLEnableProfile(profile);
	CheckCgError();
}

#pragma comment (lib, "cg")
#pragma comment (lib, "cgGL")
#else	// WITH_VERTEX_SHADER
void ogl_init_shaders(void)
{}
void ogl_disable_shader(void)
{}
void ogl_enable_shader(void)
{}

#endif	// WITH_VERTEX_SHADER
