// gxOGL.cpp : Defines the entry point for the DLL application.
//
#include <windows.h>

#include "graphics_processor/gx_cache.h"
#include "graphics_processor/texture_cache.h"
#include "graphics_processor/texture_environment.h"
#include "graphics_processor/fragment_shader_gen.h"
#include "graphics_processor/pbuffer.h"
#include "graphics_processor/display_message.h"
#include "pe_interface.h"
#include "ogl.h"
#include "ogl_shaders.h"
#include "gxOGL.h"
#include "debug/tracers.h"
#include <GL/glew.h>
#include "gx_fifo_interface.h"

gx_callbacks_t gx_cbs;
uint8 *gx_memory;

bool bSetupPixelFormat(HDC hdc);

#include "gxOGL.h"
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}


typedef enum
{
} gxcb_t;


bool CALLBACK GX_Init(uint8* mem)
{
	gx_memory = mem;
	if(gx_cache_init())
	{
		return 0;	
	}
	fsg_init();

	te_init();
	tc_init();

	pe_init();

	return true;
}


bool CALLBACK GX_Open(HWND wnd)
{
	ogl_init(wnd);
	ogl_info();

	dmsg_init();


#if WITH_PBUFFER
	pb_create_pbuffer(1024, 1024);
	pb_select_pbuffer(true);
#endif // WITH_PBUFFER
	// shader should be assigned to drawing context (dont ask me why)
	ogl_init_shaders();

	return true;
}

bool CALLBACK GX_Close(void)
{
	return true;
}

bool CALLBACK GX_Shutdown(void)
{
	GX_Close();
	te_close();
	return true;
}

bool CALLBACK GX_RegisterCallback(gxcb_t cbt)
{
	return true;
}

uint8 * CALLBACK GX_CacheGetTable(void)
{
	return gx_cache_table;
}

void CALLBACK GX_CacheSnoop(uint32 address)
{
	gx_cache_snoop(address);
}

void CALLBACK GX_CacheMarkInvalid(uint32 address, uint32 data)
{
	gx_cache_mark_invalid(address, data);
}


uint32 CALLBACK GX_PEReadRegister32(uint32 address)
{
	return pe_read_register32(address);
}

uint16 CALLBACK GX_PEReadRegister16(uint32 address)
{
	return pe_read_register16(address);
}

uint8 CALLBACK GX_PEReadRegister8(uint32 address)
{
	return pe_read_register8(address);
}

void CALLBACK GX_PEWriteRegister32(uint32 addr, uint32 data)
{
	pe_write_register32(addr, data);
}

void CALLBACK GX_PEWriteRegister16(uint32 addr, uint16 data)
{
	pe_write_register16(addr, data);
}

void CALLBACK GX_PEWriteRegister8(uint32 addr, uint8 data)
{
	pe_write_register8(addr, data);
}

bool pe_check_interrupt(void);

uint32 CALLBACK GX_PECheckInterrupt(void)
{
	return pe_check_interrupt();
}

void CALLBACK GX_WriteFifo256(uint8 * data)
{
	gx_write_fifo256(data);
}