#include "config.h"

#if WITH_PBUFFER

#include <windows.h>
#include <stdio.h>
#include <GL/glew.h>
#include <GL/wglew.h>
#include "system/types.h"
#include "pbuffer.h"
#include "wgl_helper.h"
#include "ogl_shaders.h"

typedef struct 
{
    HPBUFFERARB  hpbuffer;      // Handle to a pbuffer.
    HDC          hdc;           // Handle to a device context.
    HGLRC        hglrc;         // Handle to a GL rendering context.
    int          width;         // Width of the pbuffer
    int          height;        // Height of the pbuffer
} pbuffer_t;

#define MAX_ATTRIBS     256
#define MAX_PFORMATS    256
#define TEX_SIZE        256

static pbuffer_t pbuf;
static pbuffer_t *pbuffer = &pbuf;

static HDC		screen_hdc;
static HGLRC	screen_hglrc;

GLuint render_texture;

void pb_create_pbuffer(int width, int height)
{
    int     format;
    int     pformat[MAX_PFORMATS];
    unsigned int nformats;    int     iattributes[2*MAX_ATTRIBS];
    float   fattributes[2*MAX_ATTRIBS];
    int     nfattribs = 0;
    int     niattribs = 0;

	screen_hdc = wglGetCurrentDC();
	if (screen_hdc == NULL)
		wgl_error("wglGetCurrentDC");

	screen_hglrc = wglGetCurrentContext();
	if (screen_hglrc == NULL)
		wgl_error("wglGetCurrentContext");

    // Query for a suitable pixel format based on the specified mode.
    // Attribute arrays must be "0" terminated - for simplicity, first
    // just zero-out the array entire, then fill from left to right.
    memset(iattributes,0,sizeof(int)*2*MAX_ATTRIBS);
    memset(fattributes,0,sizeof(float)*2*MAX_ATTRIBS);
    // Since we are trying to create a pbuffer, the pixel format we
    // request (and subsequently use) must be "p-buffer capable".
    iattributes[niattribs  ] = WGL_DRAW_TO_PBUFFER_ARB;
    iattributes[++niattribs] = GL_TRUE;
    // we are asking for a pbuffer that is meant to be bound
    // as an RGBA texture - therefore we need a color plane
    iattributes[++niattribs] = WGL_BIND_TO_TEXTURE_RGB_ARB;
    iattributes[++niattribs] = GL_TRUE;
    iattributes[++niattribs  ] = WGL_SUPPORT_OPENGL_ARB;
    iattributes[++niattribs] = GL_TRUE;

    if ( !wglChoosePixelFormatARB(screen_hdc, iattributes, fattributes, MAX_PFORMATS, pformat, &nformats ) )
    {
        wgl_error("wglChoosePixelFormatARB");
    }

	if ( nformats <= 0 )
    {
        printf("pbuffer creation error:  Couldn't find a suitable pixel format.\n");
        exit(0);
    }
    format = pformat[0];

    // Set up the pbuffer attributes
    memset(iattributes,0,sizeof(int)*2*MAX_ATTRIBS);
    niattribs = 0;
    
	// the render texture format is RGBA
    iattributes[niattribs] = WGL_TEXTURE_FORMAT_ARB;
    iattributes[++niattribs] = WGL_TEXTURE_RGBA_ARB;
    // the render texture target is GL_TEXTURE_2D
    iattributes[++niattribs] = WGL_TEXTURE_TARGET_ARB;
    iattributes[++niattribs] = WGL_TEXTURE_2D_ARB;
    // ask to allocate room for the mipmaps
    iattributes[++niattribs] = WGL_MIPMAP_TEXTURE_ARB;
    iattributes[++niattribs] = FALSE;
    // ask to allocate the largest pbuffer it can, if it is
    // unable to allocate for the width and height
    iattributes[++niattribs] = WGL_PBUFFER_LARGEST_ARB;
    iattributes[++niattribs] = FALSE;
    
	// Create the p-buffer.
    pbuffer->hpbuffer = wglCreatePbufferARB(screen_hdc, format, width, height, iattributes );
    if ( pbuffer->hpbuffer == 0)
    {
		wgl_error("wglCreatePbufferARB");
    }

	// Get the device context.
    pbuffer->hdc = wglGetPbufferDCARB( pbuffer->hpbuffer );
    if ( pbuffer->hdc == 0)
    {
		wgl_error("wglGetPbufferDCARB");
    }

    // Create a gl context for the p-buffer.
    pbuffer->hglrc = wglCreateContext( pbuffer->hdc );
    if ( pbuffer->hglrc == 0)
    {
		wgl_error("wglCreateContext");
    }

    // Determine the actual width and height we were able to create.
    wglQueryPbufferARB( pbuffer->hpbuffer, WGL_PBUFFER_WIDTH_ARB, &pbuffer->width );
    wglQueryPbufferARB( pbuffer->hpbuffer, WGL_PBUFFER_HEIGHT_ARB, &pbuffer->height );
	fprintf(stderr, "pbuffer w: %d h: %d\n", pbuffer->width, pbuffer->height);

	glActiveTexture(GL_TEXTURE0_ARB);
    glGenTextures(1, &render_texture);
    glBindTexture(GL_TEXTURE_2D, render_texture);
	fprintf(stderr, "%d\n", render_texture);
	if(!wglReleaseTexImageARB(pbuffer->hpbuffer, WGL_FRONT_LEFT_ARB))
		wgl_error("wglReleaseTexImageARB");
}

/*
	glEnable(GL_TEXTURE_2D);
	glActiveTexture(GL_TEXTURE0_ARB);
    glBindTexture(GL_TEXTURE_2D, render_texture);
	if(active == true)
	{
		if (wglGetCurrentDC() != pbuffer->hdc)
		{
			if(!wglReleaseTexImageARB(pbuffer->hpbuffer, WGL_FRONT_LEFT_ARB))
				wgl_error("wglReleaseTexImageARB");

			if(!wglMakeCurrent(pbuffer->hdc, pbuffer->hglrc))
				wgl_error("wglMakeCurrent");
			//fprintf(stderr, "Selected PBuffer\n");
			printf("pbuffer: selected pbuffer\n");
		}
	}
	else
	{
		if (wglGetCurrentDC() != screen_hdc)
		{
			if(!wglMakeCurrent(screen_hdc, screen_hglrc))
				wgl_error("wglMakeCurrent");
			if (wglBindTexImageARB(pbuffer->hpbuffer, WGL_FRONT_LEFT_ARB) == FALSE)
				wgl_error("wglBindTexImageARB");
	//		fprintf(stderr, "Selected Screen\n");
			printf("pbuffer: selected screen\n");
		}
	}
*/
void pb_select_pbuffer(bool active)
{
	if(active == true)
	{
		if (wglGetCurrentDC() != pbuffer->hdc)
		{
			if(!wglMakeCurrent(pbuffer->hdc, pbuffer->hglrc))
				wgl_error("wglMakeCurrent");
			//fprintf(stderr, "Selected PBuffer\n");
			printf("pbuffer: selected pbuffer\n");
		}
	}
	else
	{
		if (wglGetCurrentDC() != screen_hdc)
		{
			if(!wglMakeCurrent(screen_hdc, screen_hglrc))
				wgl_error("wglMakeCurrent");
	//		fprintf(stderr, "Selected Screen\n");
			printf("pbuffer: selected screen\n");
		}
	}
}

void pb_copy_to_screen(void)
{
//	fprintf(stderr, "render...\n");
	ogl_disable_shader();
	
	glPushAttrib(GL_ENABLE_BIT | GL_VIEWPORT_BIT);
                            
	glDisable(GL_VERTEX_PROGRAM_ARB);
	glDisable(GL_FRAGMENT_PROGRAM_ARB);

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_TEXTURE_1D);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
	glDisable(GL_BLEND);
	glDisable(GL_COLOR_LOGIC_OP);
	glDisable(GL_COLOR_MATERIAL);
	glDisable(GL_NORMALIZE);
	glDisable(GL_LIGHTING);

	glViewport(0, 0, 640, 480);

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glMatrixMode(GL_TEXTURE);
	glPushMatrix();
	glLoadIdentity();		
	
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0,0, 640, 480);

	glTranslatef(0.0f,0.0f,-1.0f);

//	glClearColor(0,0,0,0);
//	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Clear The Screen And The Depth Buffer

//	glColor3f(0.0f, 1.0f, 0.0f);
//	glRectf(-1.0f, 1.0f, 0.f, -0.f);


    // and draw textured quad with our rendered texture
	glActiveTexture(GL_TEXTURE0_ARB);
    glBindTexture(GL_TEXTURE_2D, render_texture);
	if (wglBindTexImageARB(pbuffer->hpbuffer, WGL_FRONT_LEFT_ARB) == FALSE)
		wgl_error("wglBindTexImageARB");
    // notice that we don't need to call glTexImage2D
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,
                  GL_NEAREST);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
                  GL_NEAREST);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

	glColor4f(1.0f, 0.0f, 0.0f, 0);
    glEnable(GL_TEXTURE_2D);
    glBegin( GL_QUADS );
#if 1
		glTexCoord2f(0, 0);
		glVertex2f(-1, -1);
		glTexCoord2f(0, 1);
		glVertex2f(-1,  1);
		glTexCoord2f(1, 1);
		glVertex2f( 1,  1);
		glTexCoord2f(1, 0);
		glVertex2f( 1, -1);
#else
		glTexCoord2f(0, 0);
		glVertex2f(-0.f, -0.f);
		glTexCoord2f(0, 1);
		glVertex2f(-0.f,  0.9f);
		glTexCoord2f(1, 1);
		glVertex2f( 0.9f,  0.9f);
		glTexCoord2f(1, 0);
		glVertex2f( 0.9f, -0.f);
#endif
		glEnd();
    glDisable(GL_TEXTURE_2D);

	if(!wglReleaseTexImageARB(pbuffer->hpbuffer, WGL_FRONT_LEFT_ARB))
		wgl_error("wglReleaseTexImageARB");

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_TEXTURE);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	glPopAttrib();

	ogl_enable_shader();
}

#endif // WITH_PBUFFER