#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <GL/glew.h>
#include "display_message.h"
#include "ogl_shaders.h"
#include "system/types.h"
#include "wgl_helper.h"

GLuint	base;
#define DMSG_FONT_HEIGHT	14

void dmsg_init(void)
{
	HFONT	font;
	HFONT	oldfont;
	HDC		hDC;

	base = glGenLists(96);

	LOGFONT	lf;
	memset( &lf, 0, sizeof(lf) );

	strcpy( (LPSTR)&lf.lfFaceName, "Arial" );//MS Gothic" );
	lf.lfCharSet = DEFAULT_CHARSET;
	//lf.lfCharSet = SHIFTJIS_CHARSET;
	lf.lfHeight = DMSG_FONT_HEIGHT;
	lf.lfWeight = FW_BOLD;
	font = CreateFontIndirect( &lf );

	hDC = wglGetCurrentDC();

	oldfont = (HFONT)SelectObject(hDC, font);

	//printf("hDC = %08x Font %08x oldfont: %08x\n", (uint32)hDC, font, oldfont);
	wglUseFontBitmaps(hDC, 32, 96, base);
/*	if(!wglUseFontBitmaps(hDC, 32, 96, base))
	{
		wgl_error("wglUseFontBitmaps");
	}
*/	SelectObject(hDC, oldfont);
	DeleteObject(font);
}

void dmsg_printf(char *fmt, ...)
{
	//return;
	char tmpbuf[256];
	va_list marker;
	va_start(marker,fmt);
	vsprintf(tmpbuf, fmt, marker );
	va_end(marker);
	
	ogl_disable_shader();
	
	glPushAttrib(GL_ENABLE_BIT | GL_VIEWPORT_BIT);

	glDisable(GL_VERTEX_PROGRAM_ARB);
	glDisable(GL_FRAGMENT_PROGRAM_ARB);

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_TEXTURE_1D);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
	glDisable(GL_BLEND);
	glDisable(GL_COLOR_LOGIC_OP);
	glDisable(GL_COLOR_MATERIAL);
	glDisable(GL_NORMALIZE);
	glDisable(GL_LIGHTING);

	glViewport(0, 0, 640, 480);
//	glViewport(0, 0, 1024, 1024);

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glMatrixMode(GL_TEXTURE);
	glPushMatrix();
	glLoadIdentity();		
	
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0,0, 640, 480);
//	gluOrtho2D(0,0, 1024, 1024);

	glTranslatef(0.0f,0.0f,-1.0f);

	glColor3f(0.0f, 0.0f, 1.0f);
	glRectf(-1.0f, 1.0f, -0.8f, 0.9f);

	glColor3f(1.0f, 1.0f, 1.0f);
//	for(int i = 0 ; i < 20 ; i++)
	int i = 1;

	glRasterPos2f(-1.0f, 1.0f - ((2.0f/(480.0f/DMSG_FONT_HEIGHT)) * i) );

	glPushAttrib(GL_LIST_BIT);
	glListBase(base - 32);
	glCallLists((GLsizei)strlen(tmpbuf), GL_UNSIGNED_BYTE, tmpbuf);
	glPopAttrib();

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_TEXTURE);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	glPopAttrib();

	ogl_enable_shader();
}