#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <GL/glew.h>
#include "gp_defs.h"
#include "cp_regs.h"
#include "vertex_processor.h"
#include "debug/tracers.h"

uint32	gp_cp_regs[256];



void gp_cp_write_reg(uint32 reg, uint32 data)
{
	gp_cp_regs[reg] = data;
	syslog(CP,"CP_%02x   %08x\n", reg, data);

	switch(reg)
	{
	case 0xa0:
		vx_invalidate_cache(reg & 0xf);
		break;
	case 0xa1:
		vx_invalidate_cache(reg & 0xf);
		break;
	case 0xa2:
		vx_invalidate_cache(reg & 0xf);
		break;
	case 0xa4:
		vx_invalidate_cache(reg & 0xf);
		break;
	default:
		break;
	}
}

