// gxOGL.cpp : Defines the entry point for the DLL application.
//
#include <windows.h>

#include "graphics_processor/gx_cache.h"
#include "graphics_processor/texture_cache.h"
#include "graphics_processor/texture_environment.h"
//#include "graphics_processor/display_message.h"
#include "pe_interface.h"
#include "gxD3D.h"
#include "debug/tracers.h"
#include "gx_fifo_interface.h"
#include "d3d_fun.h"


gx_callbacks_t gx_cbs;
uint8 *gx_memory;

bool bSetupPixelFormat(HDC hdc);

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}


typedef enum
{
} gxcb_t;


bool CALLBACK GX_Init(uint8* mem)
{
#if 1
	log_trace_on[DXX] = true;
	log_trace_on[CP] = true;
	log_trace_on[BP] = true;
	log_trace_on[XF] = true;
	log_trace_on[VX] = true;
	log_trace_on[GX] = true;
#else
	log_trace_on[DXX] = false;
	log_trace_on[CP] = false;
	log_trace_on[BP] = false;
	log_trace_on[XF] = false;
	log_trace_on[VX] = false;
	log_trace_on[GX] = false;
#endif


	gx_memory = mem;
	if(gx_cache_init())
	{
		return 0;	
	}
	te_init();
	tc_init();

	pe_init();
	d3d_init();
	return true;
}


bool CALLBACK GX_Open(HWND wnd)
{

	//dmsg_init();
	d3d_open(wnd);
	return true;
}

bool CALLBACK GX_Close(void)
{
	return true;
}

bool CALLBACK GX_Shutdown(void)
{
	GX_Close();
	te_close();
	d3d_shutdown();
	return true;
}

bool CALLBACK GX_RegisterCallback(gxcb_t cbt)
{
	return true;
}

uint8 * CALLBACK GX_CacheGetTable(void)
{
	return gx_cache_table;
}

void CALLBACK GX_CacheSnoop(uint32 address)
{
	gx_cache_snoop(address);
}

void CALLBACK GX_CacheMarkInvalid(uint32 address, uint32 data)
{
	gx_cache_mark_invalid(address, data);
}


uint32 CALLBACK GX_PEReadRegister32(uint32 address)
{
	return pe_read_register32(address);
}

uint16 CALLBACK GX_PEReadRegister16(uint32 address)
{
	return pe_read_register16(address);
}

uint8 CALLBACK GX_PEReadRegister8(uint32 address)
{
	return pe_read_register8(address);
}

void CALLBACK GX_PEWriteRegister32(uint32 addr, uint32 data)
{
	pe_write_register32(addr, data);
}

void CALLBACK GX_PEWriteRegister16(uint32 addr, uint16 data)
{
	pe_write_register16(addr, data);
}

void CALLBACK GX_PEWriteRegister8(uint32 addr, uint8 data)
{
	pe_write_register8(addr, data);
}

bool pe_check_interrupt(void);

uint32 CALLBACK GX_PECheckInterrupt(void)
{
	return pe_check_interrupt();
}

void CALLBACK GX_WriteFifo256(uint8 * data)
{
	gx_write_fifo256(data);
}