#include "config.h"

#include <d3d9.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>		//	D_CHANGE
#include <malloc.h>
#include <windows.h>
#include "gp_defs.h"
#include "bp_regs.h"
#include "debug/tracers.h"
#include "texture_environment.h"
#include "gx_cache.h"
#include "texture_cache.h"
#include "texture_conversion.h"
#include "gxD3D.h"
#include "pe_interface.h"
#include "d3d_fun.h"

uint32	gp_bp_regs[256];

int	lookupTexName[8];

uint32	tx_mode0[8];

uint32	tx_paletted;

const uint32	bp_blend_sfactor_table[8] = 
{
	D3DBLEND_ZERO, 
	D3DBLEND_ONE, 
	D3DBLEND_DESTCOLOR, 
	D3DBLEND_INVDESTCOLOR,
	D3DBLEND_SRCALPHA, 
	D3DBLEND_INVSRCALPHA,
	D3DBLEND_DESTALPHA,
	D3DBLEND_INVDESTALPHA
};
const uint32	bp_blend_dfactor_table[8] = 
{
	D3DBLEND_ZERO, 
	D3DBLEND_ONE, 
	D3DBLEND_SRCCOLOR, 
	D3DBLEND_INVSRCCOLOR,
	D3DBLEND_SRCALPHA, 
	D3DBLEND_INVSRCALPHA,
	D3DBLEND_DESTALPHA,
	D3DBLEND_INVDESTALPHA
};
/*
const uint32	bp_logic_op_table[16] = 
{
	GL_CLEAR,
	GL_AND,
	GL_AND_REVERSE,
	GL_COPY,
	GL_AND_INVERTED,
	GL_NOOP,
	GL_XOR,
	GL_OR,
	GL_NOR,
	GL_EQUIV,
	GL_INVERT,
	GL_OR_REVERSE,
	GL_COPY_INVERTED,
	GL_OR_INVERTED,
	GL_NAND,
	GL_SET
};

*/
uint32 tex_width[8], tex_height[8], tex_fmt[8];

uint32	bp_tlut_addr;
uint8	bp_tmem[0x10000];
uint32	bp_tmem_maddr;

uint8	bp_tlut_rgba32[4 * 256];

uint8	tex_tlut_rgba32[4 * 256];



uint8 tex_fmt_size[16] = 
{
	1, 2, 2, 4, 4, 4, 8, 1,
	1, 2, 4, 0, 0, 0, 0, 0,
};




void tx_setmode(uint8 id)
{
	uint32 data = tx_mode0[id];

	uint32	s_wrap;
	uint32	t_wrap;
	uint32	filter;
	// TODO: Texture

	return;
	switch(data & 0x3)
	{
	case 0:
		s_wrap = D3DTADDRESS_CLAMP;
		break;
	case 1:
		s_wrap = D3DTADDRESS_WRAP;
		break;
	case 2:
		s_wrap = D3DTADDRESS_MIRROR;
		break;
	}

	switch((data >> 2) & 0x3)
	{
	case 0:
		t_wrap = D3DTADDRESS_CLAMP;
		break;
	case 1:
		t_wrap = D3DTADDRESS_WRAP;
		break;
	case 2:
		t_wrap = D3DTADDRESS_MIRROR;
		break;
	}

	// bit 7 - filter - SOMETHING WRONG
	if ( data & (1 << 7))
	{
/*		if ((tex_fmt[id] == TEX_FMT_C4 || tex_fmt[id] == TEX_FMT_C8))
		{
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		}
		else
		{
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		}
*/
		filter = D3DTEXF_LINEAR;

	}
	else
	{
		//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		filter = D3DTEXF_POINT;
	}


	g_pd3dDevice->SetSamplerState(id, D3DSAMP_ADDRESSU, s_wrap);
	g_pd3dDevice->SetSamplerState(id, D3DSAMP_ADDRESSV, t_wrap);
	g_pd3dDevice->SetSamplerState(id, D3DSAMP_MINFILTER, filter);
	g_pd3dDevice->SetSamplerState(id, D3DSAMP_MAGFILTER, filter);
}

void bp_set_texture_image(uint32 id, uint32 tex_addr)
{
	void	*tx_tex;
	void	*tbuf;

	tbuf = tc_check(tex_addr, tex_width[id] * tex_height[id] * tex_fmt_size[tex_fmt[id]] / 2, &tx_tex);
	
	tx_setmode(id);

	if(tbuf == NULL)
	{
		int w2, h2;
		tbuf = convert_tex(tex_addr + gx_memory, tex_width[id], tex_height[id], 0, tex_fmt[id]);
		calc_pow2(tex_width[id], tex_height[id], &w2, &h2);
		//g_pd3dDevice->CreateTexture(w2, h2, 0, 0, )
		tx_tex = txc_upload_texture(tex_fmt[id], tbuf);
		tc_store_entry(tex_addr, tbuf, tx_tex);
		//fprintf(stderr, "F: %d W %d H %d B %d S %x\n", tex_fmt[id], tex_width[id], tex_height[id], tex_fmt_size[tex_fmt[id]], tex_width[id] * tex_height[id] * tex_fmt_size[tex_fmt[id]] / 2);
		//fprintf(stderr, "\nMarkValid %08x %08x\n", bp_tex_addr, tex_width[id] * tex_height[id] * tex_fmt_size[tex_fmt[id]] / 2); 
		gx_cache_mark_valid(tex_addr, tex_width[id] * tex_height[id] * tex_fmt_size[tex_fmt[id]] / 2);
		// tbuf (converted texture) is no longer needed because it has been uploaded to video memory
		free(tbuf);
	}
	d3d_set_texture(id, tx_tex);
#if WITH_PALETTED_AT_SHADER
	if (tex_fmt[id] == TEX_FMT_C4 || tex_fmt[id] == TEX_FMT_C8)
	{
		tx_paletted |= (1 << id);
	}
	else
	{
		tx_paletted &= ~(1 << id);
	}
#endif // WITH_PALETTED_AT_SHADER
}

void gp_bp_write_reg32(uint32 reg, uint32 data)
{
	uint32 id;
	gp_bp_regs[reg] = data & 0x00ffffff;
	syslog(BP,"GP: BP_%02x %06x\n", reg, data & 0x00ffffff);
	switch(reg)
	{
	case 0x00:
		// ???? ???? ccss ss?? ???? ????
		// c - culling mode
		// s - active texture environment stages - 1

		te_active_stages = ((data >> 10) & 0xf) + 1;
		te_modified = true;

		// TODO: Culling
		switch((data >> 14) & 0x3)
		{
		case 0x0:
			g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
			break;
		case 0x1:
			g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);
			break;
		case 0x2:
			g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CW);
			break;
		case 0x3:
			g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
			break;
		}
		break;

	case 0x22:
		// TODO: Point Size
		/*
		glPointSize(((data >> 8) & 0xff)/6.0f);
		*/
		break;

	case 0x40:
		// ZMODE
		// bits 1-3 Depth Func
		// bit 0 - GL_DPETH_TEST (enable) 
		// bit 4 - glDepthMask (enable)
		// if GL_DEPTH_TEST should be disabled then disable DepthMask too

		syslog(BP, "DepthTest %s DepthMask %s\n", (data & 0x1)?"enable":"disable", (data & 0x10)?"enable":"disable");
		// TODO: ZMode
		if (data & 0x1)
		{
			g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);
			// this is tricky... modes are enums as in GL but in GX they start with 0
			// while in GL they start with 0x200 - defined as GL_NEVER
			g_pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_NEVER + ((data >> 1) & 0x7));
			//glDepthFunc(GL_NEVER + ((data >> 1) & 0x7));
			//glDepthMask((data >> 4) & 0x1);
		}
		else
		{
			g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
			//glDepthMask(GL_FALSE);
		}
		//syslog(BP,"Z-Mode en: %d mask: %d func %d\n", data & 0x1, (data >> 1) & 0x7, (data >> 4) & 0x1);
		break;
	case 0x41:
		// Blending
		// bit 0		- blending enabled
		// bit 5-7		- destination factor
		// bit 8-10		- source factor
		{

		// TODO: Blending
		uint32 sfactor;
		uint32 dfactor;
		sfactor = bp_blend_sfactor_table[(data >> 8) & 0x7];
		dfactor = bp_blend_dfactor_table[(data >> 5) & 0x7];
		syslog(BP,"Blending: %08x sf: %d df: %d\n", data, sfactor, dfactor);

		g_pd3dDevice->SetRenderState(D3DRS_SRCBLEND, sfactor);
		g_pd3dDevice->SetRenderState(D3DRS_DESTBLEND, dfactor);

		if(data & (1 << 11))
		{
// crazy taxi goes crazy on this !
//			syslog_warn(BP,("BlendOp set ???\n");
		}
/*		
		glBlendFunc(sfactor, dfactor);
		glLogicOp(bp_logic_op_table[(data >> 12) & 0xf]);
*/		
		g_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, (data & 0x1)?TRUE:FALSE);
/*
		if (data & (1 << 1))
		{
			glEnable(GL_COLOR_LOGIC_OP);
		}
		else
		{
			glDisable(GL_COLOR_LOGIC_OP);
		}
		*/
		}
		break;
	case 0xf3:
		// Alpha Test
		// TODO: Alpha Test
		/*

		{
		uint32 op0, op1, logic;

		logic = (data >> 22) & 0x3;
		op0 = (data >> 16) & 0x7;
		op1 = (data >> 19) & 0x7;
		op0 += GL_NEVER;
		op1 += GL_NEVER;

		if (op1 != GL_ALWAYS)
		{
// crazy taxi goes crazy on this !
//			syslog_warn(BP,("Alpha Test op2 != GL_ALWAYS logic: %d op1: %d ref1: %02x op2: %d ref2: %02x\n", logic, op0, (data >> 0) & 0xff, op1, (data >> 8) & 0xff);
		}
		if(op0 != GL_ALWAYS)
		{
			glEnable(GL_ALPHA_TEST);
			glAlphaFunc(op0, (data & 0xff)/255.0f);
		}
		else
		{
			glDisable(GL_ALPHA_TEST);
		}
		}
		*/
		break;

	case 0x47:
		printf("BP: Token B %06x\n", data);
		pe_write_register16(0x0e, (uint16)data); // tokens are only 16bit
		break;

	case 0x48:
		printf("BP: Token A %06x\n", data);
		pe_write_register16(0x0e, (uint16)data); // tokens are only 16bit
		break;

	case 0x50:
		{
			float a, r, g, b;
			a = ((gp_bp_regs[0x4f] >> 8) & 0xff) / 255.0f;
			r = ((gp_bp_regs[0x4f]) & 0xff) / 255.0f;
			g = ((gp_bp_regs[0x50] >> 8) & 0xff) / 255.0f;
			b = ((gp_bp_regs[0x50]) & 0xff) / 255.0f;
			// TODO: Clear Colour
			//glClearColor(r, g, b, a);
		}
		break;
	case 0x64:
		// transfer to tmem
		// memory address >> 5
		bp_tmem_maddr = (data << 5) & 0x01ffffff;
		break;
	case 0x65:
		{
		uint32 offset = data & 0x3ff;
		uint32 size = 2560;
		syslog(BP,"Transfer to TMEM %08x (%d) -> %04x\n", bp_tmem_maddr, size, offset);
		for (uint32 i = 0 ; i < size ; i++)
		{
			bp_tmem[offset + i] = gx_memory[bp_tmem_maddr + i];
		}
		}
		break;
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0xa0:
	case 0xa1:
	case 0xa2:
	case 0xa3:
		// TX_SETMODE0_In
		id = (reg & 0x3) + ((reg >= 0xa0)?4:0);
		tx_mode0[id] = data;
		// TODO: Active Texture
		//glActiveTexture(GL_TEXTURE0_ARB + id);
		tx_setmode(id);
		break;

	case 0x88:
	case 0x89:
	case 0x8a:
	case 0x8b:
	case 0xa8:
	case 0xa9:
	case 0xaa:
	case 0xab:
		// TX_SETIMAGE0_In
		// ffffhhhh hhhhhhww wwwwwwww
		// f - format, h - height, w - width
		id = (reg & 0x3) + ((reg >= 0xa8)?4:0);

		tex_width[id] = ((data & 0x3ff) + 1);
		tex_height[id] = ((data >> 10) & 0x3ff) + 1;
		tex_fmt[id] = ((data >> 20) & 0xf);
		syslog(BP,"TX_SETIMAGE0_I%d w: %d h: %d f: %d\n", id, tex_width[id], tex_height[id], tex_fmt[id]);
		break;

	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0xb4: // TX_SETIMAGE3_I4
	case 0xb5:
	case 0xb6:
	case 0xb7:
		// TX_SETIMAGE3_In
		syslog(BP,"texture %02x->%02x\n", reg, id);
		id = (reg & 0x3) + ((reg >= 0xb4)?4:0);
		bp_set_texture_image(id, (data << 5) & 0x01ffffff);
		break;

	case 0x98:
	case 0x99:
	case 0x9a:
	case 0x9b:
	case 0xb8:
	case 0xb9:
	case 0xba:
	case 0xbb:
		// TODO: Texture
		/*
		id = (reg & 0x3) + ((reg >= 0xb8)?4:0);

		bp_tlut_addr = data & 0x3ff;
		tex_convert_tlut((data >> 10) & 0xf, 256);
			
#if WITH_PALETTED_AT_SHADER
		glActiveTexture(GL_TEXTURE8_ARB + id);
		
		if (!lookupTexName[id])
			glGenTextures(1, &lookupTexName[id]);
		
		glBindTexture(GL_TEXTURE_1D, lookupTexName[id]);
		glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexImage1D(GL_TEXTURE_1D, 0, GL_RGBA, 256, 0, GL_RGBA, GL_UNSIGNED_BYTE, tex_tlut_rgba32);
//		glEnable(GL_TEXTURE_1D);
#else // WITH_PALETTED_AT_SHADER
		if (glColorTable)
		{
			glColorTable(GL_TEXTURE_2D, GL_RGBA, 256, GL_RGBA, GL_UNSIGNED_BYTE, tex_tlut_rgba32);
		}
#endif // WITH_PALETTED_AT_SHADER
		*/
		break;

	case 0xc0:
	case 0xc1:
	case 0xc2:
	case 0xc3:
	case 0xc4:
	case 0xc5:
	case 0xc6:
	case 0xc7:
	case 0xc8:
	case 0xc9:
	case 0xca:
	case 0xcb:
	case 0xcc:
	case 0xcd:
	case 0xce:
	case 0xcf:
	case 0xd0:
	case 0xd1:
	case 0xd2:
	case 0xd3:
	case 0xd4:
	case 0xd5:
	case 0xd6:
	case 0xd7:
	case 0xd8:
	case 0xd9:
	case 0xda:
	case 0xdb:
	case 0xdc:
	case 0xdd:
	case 0xde:
	case 0xdf:
		// Stage Operands for color and alpha
		{
		uint32 stage;
		stage = (reg - 0xc0) / 2;
		if (te_combiner_regs[reg - 0xc0] != data)
		{
			te_combiner_regs[reg - 0xc0] = data;
			tev_stage_modified = 1 << stage;
			te_modified = true;
		}
		}
		break;
	case 0xe0:
	case 0xe2:
	case 0xe4:
	case 0xe6:
		te_set_color_reg_ra(data, (reg - 0xe0) / 2);
		break;
	case 0xe1:
	case 0xe3:
	case 0xe5:
	case 0xe7:
		te_set_color_reg_gb(data, (reg - 0xe1) / 2);
		break;


	case 0x28:
	case 0x29:
	case 0x2a:
	case 0x2b:
	case 0x2c:
	case 0x2d:
	case 0x2e:
	case 0x2f:
		// Texture Coordinate, Texture Index, Color Selectors
		{
		uint32 stage;
		stage = (reg & 0x7) << 1;
		if (tev_stage[stage + 0] != (data & 0xfff))
		{
			tev_stage[stage + 0] = data & 0xfff;
			tev_stage_modified = 0x3 << stage;
			te_modified = true;
		}
		if (tev_stage[stage + 1] != ((data >> 12) & 0xfff))
		{
			tev_stage[stage + 1] = (data >> 12) & 0xfff;
			tev_stage_modified = 0x3 << stage;
			te_modified = true;
		}
		}
		break;

	case 0xf6:
	case 0xf7:
	case 0xf8:
	case 0xf9:
	case 0xfa:
	case 0xfb:
	case 0xfc:
	case 0xfd:
		// Konstant selector and color exchange
		// two stages per register
		//  4 -  8	Konst Color Stage +0
		//  9 - 13	Konst Alpha Stage +0
		// 14 - 18	Konst Color Stage +1
		// 19 - 23	Konst Alpha Stage +1
		{
		uint32	stage;
		stage = (reg - 0xf6) * 2;
		// now tev_konst will have 0000 00aa aaac cccc
		tev_konst[stage + 0] = (data >> 4) & 0x3ff;
		tev_konst[stage + 1] = (data >> 14) & 0x3ff;
		tev_konst_modified |= 0x3 << stage;
		te_modified = true;

		syslog(BP,"Stage: %d KC0 %s KA0 %s KC1 %s KA1 %s\n", (reg - 0xf6) * 2, te_kcsel[(data >> 4) & 0x1f], te_kasel[(data >> 9) & 0x1f], te_kcsel[(data >> 14) & 0x1f], te_kasel[(data >> 19) & 0x1f]);
		syslog(BP,"SWAP %d %d\n", (data >> 2) & 0x3, (data >> 0) & 0x3);
		uint32 swap_table_id;
		swap_table_id = (reg - 0xf6) / 2;
		if (reg & 0x1)
		{
			te_swap_table[swap_table_id] = (te_swap_table[swap_table_id] & 0xf0) | (data & 0x0f);
		}
		else
		{
			te_swap_table[swap_table_id] = (te_swap_table[swap_table_id] & 0x0f) | ((data << 4) & 0xf0);
		}
		}
		break;
	default:
		break;
	}
}

