/***************************************************************************
                      video_interface.c  -  description
                             -------------------
    begin                : 2004-6-18
    copyright            : (C) 2005 by Duddie & Tratax         
    email                : duddie@walla.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2005/05/29 - Pete
// - ogl_vsync handling
//
//*************************************************************************//

#include "stdafx.h"
#include "video_interface.h"
#include "ogl_generic.h"
#include "fps.h"
#define _IN_VIDREGS
#include "externals.h"

///////////////////////////////////////////////////////////////////////////
// GLOBALS + DEFINES

#define VI_REGS_SIZE    256

char vi_regs[VI_REGS_SIZE];
uint32 fb_addr  = 0;
uint16 fb_vtr   = 0;
uint16 fb_dcr   = 0;
uint32 fb_htr0  = 0;
uint32 fb_htr1  = 0;
uint16 fb_hsw   = 0;
uint16 fb_hsr   = 0;
uint16 fb_prgr  = 0;
uint32 fb_odd   = 0;
uint32 fb_even  = 0;

///////////////////////////////////////////////////////////////////////////
// CODE

static __inline uint32 byteswap32(uint32 data)
{
 __asm
  {
   mov eax, data
   bswap eax
  }
}

static __inline uint16 byteswap16(uint16 data)
{
 return (data<<8)|(data>>8);
}

///////////////////////////////////////////////////////////////////////////

void vi_init(void)
{
 int i;

 for (i = 0 ; i < VI_REGS_SIZE ; i++)
  {
   vi_regs[i] = 0;
  }
}

///////////////////////////////////////////////////////////////////////////

void vi_close(void)
{
}

///////////////////////////////////////////////////////////////////////////

void vi_write_register8(uint32 addr, uint8 data)
{
 VI_WRITE_UINT8(addr & 0xff, data);

 switch(addr & 0xff)
  {
   case VI_REG_DIR0:
   case VI_REG_DIR1:
   case VI_REG_DIR2:
   case VI_REG_DIR3:
    // if writing to those registers always clear INT stat
    if (VI_READ_UINT32(addr & 0xff) & 0x80000000)
     {
      VI_WRITE_UINT32(addr & 0xff, VI_READ_UINT32(addr & 0xff) & ~0x80000000);
     }
    break;

   case 0x1c:
    break;

   default:
    break;
  }
}

///////////////////////////////////////////////////////////////////////////

void vi_write_register16(uint32 addr, uint16 data)
{
 VI_WRITE_UINT16(addr & 0xff, data);

 switch(addr & 0xff)
  {
   case VI_REG_DCR:
    //printf("VI_REG_DCR set to: %x at: %x\n", data, CPUcurrmode->block_startPC);
    break;

   case VI_REG_DIR0:
    // if writing to those registers always clear INT stat
    if (VI_READ_UINT32(VI_REG_DIR0) & 0x80000000)
     {
      VI_WRITE_UINT32(VI_REG_DIR0, VI_READ_UINT32(VI_REG_DIR0) & ~0x80000000);
     }
    break;      

   case VI_REG_DIR1:
    // if writing to those registers always clear INT stat
    if (VI_READ_UINT32(VI_REG_DIR1) & 0x80000000)
     {
      VI_WRITE_UINT32(VI_REG_DIR1, VI_READ_UINT32(VI_REG_DIR1) & ~0x80000000);
     }
    break;      

   case VI_REG_DIR2:
    // if writing to those registers always clear INT stat
    // syslog(VI,"VI_REG_DIR2: e: %d v: %d\n", (data >> (28-16))&1, data & 0x3ff);  

    if (VI_READ_UINT32(VI_REG_DIR2) & 0x80000000)
     {
      VI_WRITE_UINT32(VI_REG_DIR2, VI_READ_UINT32(VI_REG_DIR2) & ~0x80000000);
     }
    break;      

   case VI_REG_DIR3:
    // if writing to those registers always clear INT stat
    // syslog(VI,"VI_REG_DIR3: e: %d v: %d\n", (data >> (28-16))&1, data & 0x3ff);  

    if (VI_READ_UINT32(VI_REG_DIR3) & 0x80000000)
     {
      VI_WRITE_UINT32(VI_REG_DIR3, VI_READ_UINT32(VI_REG_DIR3) & ~0x80000000);
     }
    break;      

   case 0x1c:
    break;

   default:
    break;
  }
}

///////////////////////////////////////////////////////////////////////////

void vi_write_register32(uint32 addr, uint32 data)
{
 VI_WRITE_UINT32(addr & 0xff, data);

 switch(addr & 0xff)
  {
   case VI_REG_DIR0:
   case VI_REG_DIR1:
   case VI_REG_DIR2:
   case VI_REG_DIR3:
    // if writing to those registers always clear INT stat
    if (VI_READ_UINT32(addr & 0xff) & 0x80000000)
     {
      VI_WRITE_UINT32(addr & 0xff, VI_READ_UINT32(addr & 0xff) & ~0x80000000);
     }
    break;

   case 0x1c:
    break;

   default:
    break;
  }
}

///////////////////////////////////////////////////////////////////////////

uint8 vi_read_register8(uint32 addr)
{
 uint8 data;

 data = VI_READ_UINT8(addr & 0xff);

 switch(addr & 0xff)
  {
   case 0x02:
    //data |= 1;
    break;

   case 0x2c:
    //fb_addr = VI_READ_UINT32(0x1c);
    //fb_addr &= 0x00fffe00;
    //sdl_update_display(fb_addr);
    break;

   case 0x6e:
    //printf("Entering CPU Disassembly mode\n");
    //gCPU.log_opcodes = true;
    break;

   default:
    break;
  }
 return data;
}

///////////////////////////////////////////////////////////////////////////

uint16 vi_read_register16(uint32 addr)
{
 uint16 data;

 data = VI_READ_UINT16(addr & 0xff);

 switch(addr & 0xff)
  {
   case VI_REG_DCR:
    //printf("VI_REG_DCR  read: %x at %x\n", data, CPUcurrmode->block_startPC);
    break;

   case 0x2c:
    //fb_addr = VI_READ_UINT32(0x1c);
    //fb_addr &= 0x00fffe00;
    //sdl_update_display(fb_addr);
    break;

   case 0x6e:
    //printf("Entering CPU Disassembly mode\n");
    //gCPU.log_opcodes = true;
    break;

   default:
    break;
  }
 return data;
}

///////////////////////////////////////////////////////////////////////////

uint32 vi_read_register32(uint32 addr)
{
 uint32 data;

 data = VI_READ_UINT32(addr & 0xff);

 switch(addr & 0xff)
  {
   case 0x02:
    //data |= 1;
    break;

   case 0x2c:
    //fb_addr = VI_READ_UINT32(0x1c);
    //fb_addr &= 0x00fffe00;
    //sdl_update_display(fb_addr);
    break;

   case 0x6e:
    //printf("Entering CPU Disassembly mode\n");
    //gCPU.log_opcodes = true;
    break;

   default:
    break;
  }
 return data;
}

///////////////////////////////////////////////////////////////////////////

bool vi_check_interrupt(void)
{
 uint16 irq_stat;int i;

 //syslog(VI,"%d check irq\n", VI_READ_UINT16(VI_REG_VCT));

 irq_stat = 0;
    
 for(i = 0 ; i < 4 ; i++)
  {
   irq_stat |= VI_READ_UINT16(VI_REG_DIR0_VCT + (i * 4));
  }

 if (irq_stat & 0x8000) 
  {
   //auxprintf("got %d\n",VI_READ_UINT16(VI_REG_VCT));
   return true;
  }

 return false;
}

///////////////////////////////////////////////////////////////////////////

// duddie: 0...511, 294 top mmmm..........

// funny vals, keep in mind: 
// on NTSC, there are 525 lines, and 480 active ones
// on PAL,  there are 625 lines, and 574 active
// PAL: (fb_dcr&0x300)==0x100

// 264 ... 525
// non-interlaced: 1-263

#define MAX_LINE_PAL  625
#define END_LINE_PAL  313      
//#define END_LINE_PAL 1


#define MAX_LINE_NTSC 525
#define END_LINE_NTSC 263
//#define END_LINE_NTSC 272
//#define END_LINE_NTSC 1


int max_lines = MAX_LINE_NTSC;
int end_line  = END_LINE_NTSC;

void vi_next_scanline(void)
{
 uint16 current_line;
 int i;

 current_line = VI_READ_UINT16(VI_REG_VCT);
 current_line++;

// DUDDIE:
// current_line &= 0x1ff;

// Pete:
 if(current_line>max_lines) current_line=1;

// DUDDIE:
// if (current_line == 0x126)

// Pete:
 fb_dcr  = VI_READ_UINT16(0x02);

 if(current_line == 1 || current_line == end_line)
  {
   if (current_line == end_line && !(fb_dcr&4))
    {
     //CheckFrameRate();
    }
   else
    {
     fb_addr = VI_READ_UINT32(0x1c);
     fb_addr &= 0x00fffe00;
     fb_vtr  = VI_READ_UINT16(0x00);
     fb_htr0 = VI_READ_UINT32(0x04);
     fb_htr1 = VI_READ_UINT32(0x08);
     fb_odd  = VI_READ_UINT32(0x0c)&0x3ff;
     fb_even = VI_READ_UINT32(0x10)&0x3ff;
     fb_hsw  = VI_READ_UINT16(0x48);
     fb_hsr  = VI_READ_UINT16(0x4a);
     fb_prgr = VI_READ_UINT16(0x6c);

     ogl_vsync();
    }

   if((fb_dcr&0x300)==0x100)
        {max_lines=MAX_LINE_PAL; end_line=END_LINE_PAL;}
   else {max_lines=MAX_LINE_NTSC;end_line=END_LINE_NTSC;}
  }

 VI_WRITE_UINT16(VI_REG_VCT, current_line);

 for(i = 0 ; i < 4 ; i++)
  {
   // careful DIRn_VCT is higher 16 bits of DIRn
   uint16 dir_vct;

   // Display Interrupt Regs are specaed by 4 bytes
   dir_vct = VI_READ_UINT16(VI_REG_DIR0_VCT + (i * 4));

   if (dir_vct & 0x1000)
    {
     // interrupt for this register is enabled
     if ((dir_vct & 0x3ff) == current_line)
      {
       // generate irq and store reg
       dir_vct |= 0x8000;
       VI_WRITE_UINT16(VI_REG_DIR0_VCT + (i * 4), dir_vct);
      }
    }
  }
}

///////////////////////////////////////////////////////////////////////////
