/***************************************************************************
                       texture_cache.c  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2005 by Duddie
    email                : duddie@walla.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2005/05/29 - Pete
// - framebuffer textures support (not complete yet)
//
//*************************************************************************//

#include "stdafx.h"
#include "texture_cache.h"
#include "gx_cache.h"
#define _IN_TEXCACHE
#include "externals.h"

///////////////////////////////////////////////////////////////////////////
// GLOBALS + DEFINES

typedef struct
{
 uint32  addr;
 int     tex;
} texture_cache_entry_t;

#define TC_BLOCK_SIZE 32

texture_cache_entry_t tc_cache[24 * 1024 * 1024 / TC_BLOCK_SIZE];

///////////////////////////////////////////////////////////////////////////
// CODE

void tc_init(void)
{
 uint32 i;

 for(i = 0 ; i < 24 * 1024 * 1024 / TC_BLOCK_SIZE ; i++)
  {
   tc_cache[i].addr = 0xffffffff;
   tc_cache[i].tex = 0;
  }
}

///////////////////////////////////////////////////////////////////////////

void tc_close(void)
{
 uint32 i;

 for(i = 0 ; i < 24 * 1024 * 1024 / TC_BLOCK_SIZE ; i++)
  {
   if(tc_cache[i].tex != 0)
    {
     glDeleteTextures(1, (GLuint *)&tc_cache[i].tex);
     tc_cache[i].tex=0;
    }
  }
}

///////////////////////////////////////////////////////////////////////////

void tc_invalidate_entry(uint32 tex_addr)
{
 uint32 cache_entry = tex_addr / TC_BLOCK_SIZE;

 tc_cache[cache_entry].addr = 0xffffffff;

 if(tc_cache[cache_entry].tex)
  {
   glDeleteTextures(1, (GLuint *)&tc_cache[cache_entry].tex);
   tc_cache[cache_entry].tex=0;
  }
}

///////////////////////////////////////////////////////////////////////////

bool tc_check(uint32 tex_addr, uint32 tex_size, uint32 *tex_name)
{
 uint32 cache_entry = tex_addr / TC_BLOCK_SIZE;

#ifdef AUX_NOTEXCACHE
//if(GetAsyncKeyState(VK_SHIFT)&32768)
 {
  tc_invalidate_entry(tex_addr);
  glGenTextures(1, tex_name);
  return false;
 }
#endif

 if (tc_cache[cache_entry].addr != 0xffffffff &&
     tc_cache[cache_entry].addr == tex_addr)
  {
   // cache hit, now check if valid
   if(0 == gx_cache_check(tex_addr, tex_size))
    {
     // cache hit, texture is cached
     *tex_name = tc_cache[cache_entry].tex;
     return true;
    }

   // part of texture has been invalidated
   tc_invalidate_entry(tex_addr);
  }

 // not cached, create new texture    
 glGenTextures(1, tex_name);

 return false;
}

///////////////////////////////////////////////////////////////////////////

void tc_store_entry(uint32 tex_addr, void *pc_addr, uint32 tex)
{
 uint32 cache_entry = tex_addr / TC_BLOCK_SIZE;

 if(tc_cache[cache_entry].addr != 0xffffffff)
  {
   //fprintf(stderr, "texture cache not empty %08x (new: %08x), strange! DEBUG!\n", tc_cache[cache_entry].addr, tex_addr);
   tc_invalidate_entry(tex_addr);
  }

 tc_cache[cache_entry].tex  = tex;
 tc_cache[cache_entry].addr = tex_addr;
}

///////////////////////////////////////////////////////////////////////////

bool tc_check_fbtex(uint32 tex_addr, int wid, int hei, uint32 *tex_name)
{
 uint32 cache_entry = tex_addr / TC_BLOCK_SIZE;

 if (tc_cache[cache_entry].addr != 0xffffffff &&
     tc_cache[cache_entry].addr == tex_addr)
  {
   if(tc_cache[cache_entry].tex)
    {
     int owid,ohei;

     glBindTexture(GL_TEXTURE_2D,tc_cache[cache_entry].tex);
     glGetTexLevelParameteriv(GL_TEXTURE_2D,0,GL_TEXTURE_WIDTH,&owid);
     glGetTexLevelParameteriv(GL_TEXTURE_2D,0,GL_TEXTURE_HEIGHT,&ohei);

     // get x/y size... if same as new: ok, re-use texture
     if(owid==wid && ohei==hei)
      {
       *tex_name=tc_cache[cache_entry].tex;
       return true;
      }
    }
  }

 tc_invalidate_entry(tex_addr);

 // not cached, create new texture    
 glGenTextures(1, tex_name);
 glBindTexture(GL_TEXTURE_2D, *tex_name);
 memset(pbTransferBuf,0,wid*hei*4);

 //glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, wid, hei, 0, GL_RGBA, GL_UNSIGNED_BYTE,pbTransferBuf);

 glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, wid, hei, 0, GL_BGRA_EXT, GL_UNSIGNED_BYTE,pbTransferBuf);


// glTexImage2D(GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT24_ARB, wid, hei, 0, GL_DEPTH_COMPONENT, GL_FLOAT,0);

 tc_cache[cache_entry].tex  = *tex_name;
 tc_cache[cache_entry].addr = tex_addr;

 return false;
}

///////////////////////////////////////////////////////////////////////////
