/***************************************************************************
                        ogl_generic.c  -  description
                             -------------------
    begin                : 21.05.2005
    copyright            : (C) 2005 by Pete Bernert
    email                : BlackDove@addcom.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2005/06/02 - Pete
// - changed framebuffer texture handling, so it works on both NV + ATI
//
// 2005/05/30 - Pete
// - added screen centering and "black screen" detection
//
// 2005/05/29 - Pete
// - framebuffer textures support (not complete yet)
//
// 2005/05/28 - Pete
// - added pure YCbYCr->XFB display support (needed for many demos, slow)
//
// 2005/05/23 - Pete
// - added keyboard handling for plugin menu
//
// 2005/05/21 - Pete
// - heart and sould of the new plugin: real EFB/XFB handling
//
//*************************************************************************//

#include "stdafx.h"
#include "fps.h"
#include "ogl_generic.h"
#include "texture_environment.h"
#include "texture_conversion.h"
#include "texture_cache.h"
#include "vertex_processor.h"
#include "gx_cache.h"
#define _IN_OGLGENERIC
#include "externals.h"

#ifdef AUX_ENABLE
#define SMALLDEBUG
#include <dbgout.h>           
#endif
                
///////////////////////////////////////////////////////////////////////////
// GLOBALS

// currently: two XFB pbuffers... maybe we will need more in the future

#define MAX_XFB_NUM 2

//#define NO_XFB_BUFFERS

#define GETEXT( function, ftype, name ) function = (ftype)wglGetProcAddress( name );

// WGL_ARB_extensions_string
PFNWGLGETEXTENSIONSSTRINGARBPROC		wglGetExtensionsStringARB_Ex = NULL;

// WGL_ARB_pbuffer
PFNWGLCREATEPBUFFERARBPROC				wglCreatePbufferARB_Ex    = NULL;
PFNWGLGETPBUFFERDCARBPROC				wglGetPbufferDCARB_Ex     = NULL;
PFNWGLRELEASEPBUFFERDCARBPROC			wglReleasePbufferDCARB_Ex = NULL;
PFNWGLDESTROYPBUFFERARBPROC				wglDestroyPbufferARB_Ex   = NULL;
PFNWGLQUERYPBUFFERARBPROC				wglQueryPbufferARB_Ex     = NULL;

// WGL_ARB_pixel_format
PFNWGLGETPIXELFORMATATTRIBIVARBPROC		wglGetPixelFormatAttribivARB_Ex = NULL;
PFNWGLGETPIXELFORMATATTRIBFVARBPROC		wglGetPixelFormatAttribfvARB_Ex = NULL;
PFNWGLCHOOSEPIXELFORMATARBPROC			wglChoosePixelFormatARB_Ex      = NULL;

// WGL_ARB_render_texture
PFNWGLBINDTEXIMAGEARBPROC				wglBindTexImageARB_Ex     = NULL;
PFNWGLRELEASETEXIMAGEARBPROC			wglReleaseTexImageARB_Ex  = NULL;
PFNWGLSETPBUFFERATTRIBARBPROC			wglSetPbufferAttribARB_Ex = NULL;

// GL_ARB_multitexture
PFNGLMULTITEXCOORD2FVARBPROC            glMultiTexCoord2fvARB_Ex = NULL;
PFNGLMULTITEXCOORD3FVARBPROC            glMultiTexCoord3fvARB_Ex = NULL;
PFNGLMULTITEXCOORD1FARBPROC             glMultiTexCoord1fARB_Ex  = NULL;
PFNGLMULTITEXCOORD2FARBPROC             glMultiTexCoord2fARB_Ex  = NULL;
PFNGLMULTITEXCOORD3FARBPROC             glMultiTexCoord3fARB_Ex  = NULL;
PFNGLMULTITEXCOORD4FARBPROC             glMultiTexCoord4fARB_Ex  = NULL;
PFNGLACTIVETEXTUREARBPROC               glActiveTextureARB_Ex    = NULL;
PFNGLCLIENTACTIVETEXTUREARBPROC         glClientActiveTextureARB_Ex = NULL; 

// ARB program
PFNGLGENPROGRAMSARBPROC                glGenProgramsARB_Ex            = 0;
PFNGLDELETEPROGRAMSARBPROC             glDeleteProgramsARB_Ex         = 0;
PFNGLBINDPROGRAMARBPROC                glBindProgramARB_Ex            = 0;
PFNGLPROGRAMSTRINGARBPROC              glProgramStringARB_Ex          = 0;
PFNGLPROGRAMENVPARAMETER4FARBPROC      glProgramEnvParameter4fARB_Ex  = 0;
PFNGLPROGRAMENVPARAMETER4FVARBPROC     glProgramEnvParameter4fvARB_Ex = 0;
PFNGLGETPROGRAMIVARBPROC               glGetProgramivARB_Ex           = 0;

HGLRC          rcGX=0;
HDC            hdcGX=0;
HWND           hWGX=0;
HMENU          hGXMenu=0;
bool           bChangeWinMode=false;
static WNDPROC old_winproc=0;
int            iWindowMode=1;
int            iResX=640;
int            iResY=480;
int            iColDepth=32;
int            iChangeRes=0;
int            iFBUpload=3;
BYTE *         pbTransferBuf=0;
BYTE *         pbTransferBufEx=0;

#define EFB_DX 1024
#define EFB_DY  512

typedef struct PBUFFERTag
{
 HPBUFFERARB hPB;
 HDC         hDC;
 HGLRC       hRC;
 GLuint      tex;
 uint32      fb_addr;
 int         fb_height;
 uint32      efb_copied;
 int         usage_count;
} PBUFFER;

PBUFFER pbuf_EFB;
PBUFFER pbuf_XFB[2];
PBUFFER pbuf_ETX;

///////////////////////////////////////////////////////////////////////////
// CODE

LRESULT CALLBACK key_winproc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
 switch(message)
  {
   case WM_KEYDOWN:

    if(wParam==VK_ESCAPE && iChangeRes==1)             // hack for switching back on fullscreen mode
     {
      te_close();
      tc_close();
      ogl_close();
     }
    break;

   case WM_SYSKEYUP:
    if(wParam==VK_RETURN) bChangeWinMode=true;
    break;

   case WM_KEYUP:

    if(wParam==(WPARAM)VK_DELETE) 
     {
      if(ulKeybits&KEY_SHOWFPS) ulKeybits&=~KEY_SHOWFPS;
      else                      ulKeybits|= KEY_SHOWFPS;
     }

    if(wParam==(WPARAM)VK_INSERT) 
     {
      bInitCap = TRUE; 
      iUseFrameLimit=!iUseFrameLimit;
     }
    break;

  }

 if(old_winproc) return old_winproc(hwnd,message,wParam,lParam);
 
 return DefWindowProc(hwnd,message,wParam,lParam);
}

///////////////////////////////////////////////////////////////////////////

void ChangeDesktop()
{
 DEVMODE dv;long lRes,iTry=0;                      

 while(iTry<10)
  {
   memset(&dv,0,sizeof(DEVMODE));
   dv.dmSize=sizeof(DEVMODE);
   dv.dmBitsPerPel=iColDepth;
   dv.dmPelsWidth=iResX;
   dv.dmPelsHeight=iResY;

   dv.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

   lRes=ChangeDisplaySettings(&dv,0); 

   if(lRes==DISP_CHANGE_SUCCESSFUL) return;
   iTry++;Sleep(10);
  }
}

///////////////////////////////////////////////////////////////////////////

BOOL bSetupPixelFormat(HDC hDC)
{
 static PIXELFORMATDESCRIPTOR pfd = 
  {
   sizeof(PIXELFORMATDESCRIPTOR),    // size of this pfd
    1,                               // version number
    PFD_DRAW_TO_WINDOW |             // support window
      PFD_SUPPORT_OPENGL |           // support OpenGL
      PFD_DOUBLEBUFFER,              // double buffered
    PFD_TYPE_RGBA,                   // RGBA type
    32,                              // color depth
    0, 0, 0, 0, 0, 0,                // color bits ignored
    0,                               // no alpha buffer
    0,                               // shift bit ignored
    0,                               // no accumulation buffer
    0, 0, 0, 0,                      // accum bits ignored
    0,                               // no z-buffer    
    0,                               // no stencil buffer
    0,                               // no auxiliary buffer
    PFD_MAIN_PLANE,                  // main layer
    0,                               // reserved
    0, 0, 0                          // layer masks ignored
  };
 int pixelformat;

 // well, let's choose the format

 if((pixelformat=ChoosePixelFormat(hDC, &pfd))==0)     
  {
   MessageBox(NULL, "ChoosePixelFormat failed", "Error", MB_OK);
   return FALSE;
  }

 // and try to set it

 if(SetPixelFormat(hDC, pixelformat, &pfd) == FALSE)
  {
   MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK);
   return FALSE;
  }

 return TRUE;
}

///////////////////////////////////////////////////////////////////////////

void InitOpenGLExts(void)
{
 char *extensions    = (char*)glGetString(GL_EXTENSIONS);
 char *wglextensions = NULL;
 
 GETEXT(wglGetExtensionsStringARB_Ex,PFNWGLGETEXTENSIONSSTRINGARBPROC,"wglGetExtensionsStringARB");

 if(wglGetExtensionsStringARB_Ex)
  wglextensions = (char*)wglGetExtensionsStringARB_Ex(wglGetCurrentDC());

 if(!wglextensions)
  {MessageBox(NULL,"No WGL extensions!","gxPeteOGL",MB_OK);gpu_exit(0,14);}

 if(strstr(wglextensions,"WGL_ARB_pbuffer"))
  {
   GETEXT( wglCreatePbufferARB_Ex,   PFNWGLCREATEPBUFFERARBPROC,     "wglCreatePbufferARB" );
   GETEXT( wglGetPbufferDCARB_Ex,    PFNWGLGETPBUFFERDCARBPROC,      "wglGetPbufferDCARB" );
   GETEXT( wglReleasePbufferDCARB_Ex,PFNWGLRELEASEPBUFFERDCARBPROC,  "wglReleasePbufferDCARB" );
   GETEXT( wglDestroyPbufferARB_Ex,  PFNWGLDESTROYPBUFFERARBPROC,    "wglDestroyPbufferARB" );
   GETEXT( wglQueryPbufferARB_Ex,    PFNWGLQUERYPBUFFERARBPROC,      "wglQueryPbufferARB" );
  }
 else {MessageBox(NULL,"Missing pbuffer extension!","gxPeteOGL",MB_OK);gpu_exit(0,15);}

 if(strstr(wglextensions,"WGL_ARB_pixel_format"))
  {
   GETEXT( wglGetPixelFormatAttribivARB_Ex, PFNWGLGETPIXELFORMATATTRIBIVARBPROC,  "wglGetPixelFormatAttribivARB" );
   GETEXT( wglGetPixelFormatAttribfvARB_Ex, PFNWGLGETPIXELFORMATATTRIBFVARBPROC,  "wglGetPixelFormatAttribfvARB" );
   GETEXT( wglChoosePixelFormatARB_Ex,      PFNWGLCHOOSEPIXELFORMATARBPROC,       "wglChoosePixelFormatARB" );
  }
 else {MessageBox(NULL,"Missing pixel format extension!","gxPeteOGL",MB_OK);gpu_exit(0,16);}

 if(strstr(wglextensions,"WGL_ARB_render_texture"))
  {
   GETEXT( wglBindTexImageARB_Ex,     PFNWGLBINDTEXIMAGEARBPROC,     "wglBindTexImageARB" );
   GETEXT( wglReleaseTexImageARB_Ex,  PFNWGLRELEASETEXIMAGEARBPROC,  "wglReleaseTexImageARB" );
   GETEXT( wglSetPbufferAttribARB_Ex, PFNWGLSETPBUFFERATTRIBARBPROC, "wglSetPbufferAttribARB" );
  }
 else 
  {MessageBox(NULL,"Missing render-texture extension!","gxPeteOGL",MB_OK);gpu_exit(0,17);}
 
 if(strstr(extensions, "GL_ARB_multitexture") && 
    strstr(extensions, "GL_EXT_texture_env_combine"))
  {   
   int maxTexInfo;

   // mmm... Duddie's stuff need 16 texture image units, and 8 texture coord sets... ok

   glGetIntegerv( GL_MAX_TEXTURE_IMAGE_UNITS_ARB, &maxTexInfo );
   if(maxTexInfo<16)
    {MessageBox(NULL,"sixteen texture image units required!","gxPeteOGL",MB_OK);gpu_exit(0,18);}

   glGetIntegerv( GL_MAX_TEXTURE_COORDS_ARB, &maxTexInfo );
   if(maxTexInfo<8)
    {MessageBox(NULL,"eight texture coord sets required!","gxPeteOGL",MB_OK);gpu_exit(0,19);}

   GETEXT( glMultiTexCoord2fvARB_Ex, PFNGLMULTITEXCOORD2FVARBPROC,   "glMultiTexCoord2fvARB" );
   GETEXT( glMultiTexCoord3fvARB_Ex, PFNGLMULTITEXCOORD3FVARBPROC,   "glMultiTexCoord3fvARB" );
   GETEXT( glMultiTexCoord1fARB_Ex,  PFNGLMULTITEXCOORD1FARBPROC,    "glMultiTexCoord1fARB" );
   GETEXT( glMultiTexCoord2fARB_Ex,  PFNGLMULTITEXCOORD2FARBPROC,    "glMultiTexCoord2fARB" );
   GETEXT( glMultiTexCoord3fARB_Ex,  PFNGLMULTITEXCOORD3FARBPROC,    "glMultiTexCoord3fARB" );
   GETEXT( glMultiTexCoord4fARB_Ex,  PFNGLMULTITEXCOORD4FARBPROC,    "glMultiTexCoord4fARB" );
   GETEXT( glActiveTextureARB_Ex,    PFNGLACTIVETEXTUREARBPROC,      "glActiveTextureARB" );
   GETEXT( glClientActiveTextureARB_Ex, PFNGLCLIENTACTIVETEXTUREARBPROC, "glClientActiveTextureARB" );     
  }
 else {MessageBox(NULL,"Missing multitexture extension!","gxPeteOGL",MB_OK);gpu_exit(0,20);}

 if(strstr( extensions, "GL_ARB_vertex_program" ) &&
    strstr( extensions, "GL_ARB_fragment_program" ))
  {
   GETEXT( glGenProgramsARB_Ex,PFNGLGENPROGRAMSARBPROC,           "glGenProgramsARB" );
   GETEXT( glDeleteProgramsARB_Ex,PFNGLDELETEPROGRAMSARBPROC,     "glDeleteProgramsARB" );
   GETEXT( glBindProgramARB_Ex,PFNGLBINDPROGRAMARBPROC,           "glBindProgramARB" );
   GETEXT( glProgramStringARB_Ex,PFNGLPROGRAMSTRINGARBPROC,       "glProgramStringARB" );
   GETEXT( glProgramEnvParameter4fARB_Ex,PFNGLPROGRAMENVPARAMETER4FARBPROC, "glProgramEnvParameter4fARB" );
   GETEXT( glProgramEnvParameter4fvARB_Ex,PFNGLPROGRAMENVPARAMETER4FVARBPROC,"glProgramEnvParameter4fvARB" );
   GETEXT( glGetProgramivARB_Ex,PFNGLGETPROGRAMIVARBPROC,          "glGetProgramivARB" );
  }
 else {MessageBox(NULL,"Missing shader extension!","gxPeteOGL",MB_OK);gpu_exit(0,21);}
}

//GLuint depthtex;

///////////////////////////////////////////////////////////////////////////

void Create_EFB_PBuffer(int x,int y, HDC hdc)
{
 int nx,ny;
 unsigned int nFormat = 0;
 signed int pixelFormat;

 int pbAttribute1[] =
  {
   WGL_TEXTURE_FORMAT_ARB, WGL_TEXTURE_RGBA_ARB, 
   WGL_TEXTURE_TARGET_ARB, WGL_TEXTURE_2D_ARB,
   WGL_MIPMAP_TEXTURE_ARB, GL_FALSE, 
   0
  };

 int pfAttribute1[] =
  {
   WGL_SUPPORT_OPENGL_ARB,  TRUE,
   WGL_DRAW_TO_PBUFFER_ARB, TRUE,
   WGL_BIND_TO_TEXTURE_RGBA_ARB, TRUE,
   WGL_RED_BITS_ARB,   8,
   WGL_GREEN_BITS_ARB, 8,
   WGL_BLUE_BITS_ARB,  8,
   WGL_ALPHA_BITS_ARB, 8,
   WGL_DEPTH_BITS_ARB, 24,
   WGL_DOUBLE_BUFFER_ARB, FALSE, 
   0
  };

 int * pfAttribute,* pbAttribute;

 pfAttribute=pfAttribute1; pbAttribute=pbAttribute1;

 pbuf_EFB.hPB=NULL;
 pbuf_EFB.hDC=NULL;
 pbuf_EFB.hRC=NULL;
 pbuf_EFB.tex=0;
 pbuf_EFB.fb_addr=0;
 pbuf_EFB.fb_height=480;
 pbuf_EFB.efb_copied=0;
 pbuf_EFB.usage_count=0;

 wglChoosePixelFormatARB_Ex(hdc,pfAttribute,NULL,1,&pixelFormat,&nFormat);

 if(nFormat==0)
  {
   MessageBox(NULL,"No pbuffer pixel format available!","gxPeteOGL",MB_OK);
   gpu_exit(0,22);
   return;
  }

 pbuf_EFB.hPB=wglCreatePbufferARB_Ex(hdc,pixelFormat,x,y,pbAttribute);
 pbuf_EFB.hDC=wglGetPbufferDCARB_Ex(pbuf_EFB.hPB);
 pbuf_EFB.hRC=wglCreateContext(pbuf_EFB.hDC);

 if(!pbuf_EFB.hPB)
  {
   MessageBox(NULL,"No pbuffer available!","gxPeteOGL",MB_OK);
   gpu_exit(0,23);
   return;
  }

 wglQueryPbufferARB_Ex(pbuf_EFB.hPB,WGL_PBUFFER_WIDTH_ARB, &nx);
 wglQueryPbufferARB_Ex(pbuf_EFB.hPB,WGL_PBUFFER_HEIGHT_ARB,&ny);

 if(!(x==nx && y==ny))
  {
   MessageBox(NULL,"Wrong pbuffer size!","gxPeteOGL",MB_OK);
   gpu_exit(0,24);
   return;
  }

 wglShareLists(pbuf_EFB.hRC,rcGX);

 /////////////////////////////////////////
/*
 glGenTextures(1,&depthtex);
 glBindTexture(GL_TEXTURE_2D,depthtex);

 glTexImage2D(GL_TEXTURE_2D,0,GL_DEPTH_COMPONENT24_ARB,x,y,0,GL_DEPTH_COMPONENT, GL_FLOAT,0);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
*/
 /////////////////////////////////////////

 glGenTextures(1,&pbuf_EFB.tex);
 glBindTexture(GL_TEXTURE_2D,pbuf_EFB.tex);

 glTexImage2D(GL_TEXTURE_2D,0,4,x,y,0,GL_RGBA,GL_UNSIGNED_BYTE,0);
 
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
}

///////////////////////////////////////////////////////////////////////////

void Create_ETX_PBuffer(int x,int y, HDC hdc)
{
 int nx,ny;
 unsigned int nFormat = 0;
 signed int pixelFormat;

 int pbAttribute1[] =
  {
   WGL_PBUFFER_LARGEST_ARB,GL_FALSE,
   0
  };

 int pfAttribute1[] =
  {
   WGL_SUPPORT_OPENGL_ARB,  TRUE,
   WGL_DRAW_TO_PBUFFER_ARB, TRUE,
   WGL_RED_BITS_ARB,   8,
   WGL_GREEN_BITS_ARB, 8,
   WGL_BLUE_BITS_ARB,  8,
   WGL_ALPHA_BITS_ARB, 8,
   WGL_DEPTH_BITS_ARB, 0,
   WGL_DOUBLE_BUFFER_ARB, FALSE, 
   0
  };

 int * pfAttribute,* pbAttribute;

 pfAttribute=pfAttribute1; pbAttribute=pbAttribute1;

 pbuf_ETX.hPB=NULL;
 pbuf_ETX.hDC=NULL;
 pbuf_ETX.hRC=NULL;
 pbuf_ETX.tex=0;
 pbuf_ETX.fb_addr=0;
 pbuf_ETX.fb_height=0;
 pbuf_ETX.efb_copied=0;
 pbuf_ETX.usage_count=0;

#ifdef NO_XFB_BUFFERS
 return;
#endif

 wglChoosePixelFormatARB_Ex(hdc,pfAttribute,NULL,1,&pixelFormat,&nFormat);

 if(nFormat==0)
  {
   MessageBox(NULL,"No pbuffer pixel format available!","gxPeteOGL",MB_OK);
   gpu_exit(0,25);
   return;
  }

 pbuf_ETX.hPB=wglCreatePbufferARB_Ex(hdc,pixelFormat,x,y,pbAttribute);
 pbuf_ETX.hDC=wglGetPbufferDCARB_Ex(pbuf_ETX.hPB);
 pbuf_ETX.hRC=wglCreateContext(pbuf_ETX.hDC);

 if(!pbuf_ETX.hPB)
  {
   MessageBox(NULL,"No pbuffer available!","gxPeteOGL",MB_OK);
   gpu_exit(0,26);
   return;
  }

 wglQueryPbufferARB_Ex(pbuf_ETX.hPB,WGL_PBUFFER_WIDTH_ARB, &nx);
 wglQueryPbufferARB_Ex(pbuf_ETX.hPB,WGL_PBUFFER_HEIGHT_ARB,&ny);

 if(!(x==nx && y==ny))
  {
   MessageBox(NULL,"Wrong pbuffer size!","gxPeteOGL",MB_OK);
   gpu_exit(0,27);
   return;
  }

 wglShareLists(pbuf_ETX.hRC,pbuf_EFB.hRC);
}

///////////////////////////////////////////////////////////////////////////

void Create_XFB_PBuffer(int x,int y, HDC hdc)
{
 int nx=0,ny=0,idx;
 unsigned int nFormat = 0;
 signed int pixelFormat=0;

 int pbAttribute1[] =
  {
   WGL_TEXTURE_FORMAT_ARB, WGL_TEXTURE_RGBA_ARB, 
   WGL_TEXTURE_TARGET_ARB, WGL_TEXTURE_2D_ARB,
   WGL_MIPMAP_TEXTURE_ARB, GL_FALSE, 
   0
  };

 int pfAttribute1[] =
  {
   WGL_SUPPORT_OPENGL_ARB,  TRUE,
   WGL_DRAW_TO_PBUFFER_ARB, TRUE,
   WGL_BIND_TO_TEXTURE_RGBA_ARB, TRUE,
   WGL_RED_BITS_ARB,   8,
   WGL_GREEN_BITS_ARB, 8,
   WGL_BLUE_BITS_ARB,  8,
   WGL_ALPHA_BITS_ARB, 8,
   WGL_DEPTH_BITS_ARB, 0,
   WGL_DOUBLE_BUFFER_ARB, FALSE, 
   0
  };

 int * pfAttribute=0,* pbAttribute=0;

 for(idx=0;idx<MAX_XFB_NUM;idx++)
  {
   pbuf_XFB[idx].hPB=NULL;
   pbuf_XFB[idx].hDC=NULL;
   pbuf_XFB[idx].hRC=NULL;
   pbuf_XFB[idx].tex=0;
   pbuf_XFB[idx].fb_addr=0;
   pbuf_XFB[idx].fb_height=0;
   pbuf_XFB[idx].efb_copied=0;
   pbuf_XFB[idx].usage_count=0;

#ifndef NO_XFB_BUFFERS

   pfAttribute=pfAttribute1; pbAttribute=pbAttribute1;

   wglChoosePixelFormatARB_Ex(hdc,pfAttribute,NULL,1,&pixelFormat,&nFormat);

   if(nFormat==0)
    {
     MessageBox(NULL,"No xfb pixel format available!","gxPeteOGL",MB_OK);
     gpu_exit(0,28);
     return;
    }

   pbuf_XFB[idx].hPB=wglCreatePbufferARB_Ex(hdc,pixelFormat,x,y,pbAttribute);
   pbuf_XFB[idx].hDC=wglGetPbufferDCARB_Ex(pbuf_XFB[idx].hPB);
   pbuf_XFB[idx].hRC=wglCreateContext(pbuf_XFB[idx].hDC);

   if(!pbuf_XFB[idx].hPB)
    {
     MessageBox(NULL,"No xfb pbuffer available!","gxPeteOGL",MB_OK);
     gpu_exit(0,29);
     return;
    }

   wglQueryPbufferARB_Ex(pbuf_XFB[idx].hPB,WGL_PBUFFER_WIDTH_ARB, &nx);
   wglQueryPbufferARB_Ex(pbuf_XFB[idx].hPB,WGL_PBUFFER_HEIGHT_ARB,&ny);

   if(!(x==nx && y==ny))
    {
     MessageBox(NULL,"Wrong xfb pbuffer size!","gxPeteOGL",MB_OK);
     gpu_exit(0,30);
     return;
    }

   wglShareLists(pbuf_XFB[idx].hRC,rcGX);
   wglShareLists(pbuf_XFB[idx].hRC,pbuf_EFB.hRC);

   glGenTextures(1,&pbuf_XFB[idx].tex);
   glBindTexture(GL_TEXTURE_2D,pbuf_XFB[idx].tex);
   glTexImage2D(GL_TEXTURE_2D,0,4,x,y,0,GL_RGBA,GL_UNSIGNED_BYTE,0);
   glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);

#endif
  }
}


///////////////////////////////////////////////////////////////////////////

void InitPBContext(PBUFFER * pb)
{
 if(!pb->hPB) return;

 wglMakeCurrent(pb->hDC,pb->hRC);

 glViewport(0,0,EFB_DX,EFB_DY);
 glScissor (0,0,EFB_DX,EFB_DY);                    
 glEnable(GL_SCISSOR_TEST);                       

 glMatrixMode(GL_PROJECTION);
 glLoadIdentity();
 glOrtho(0,EFB_DX,EFB_DY,0,-1,1);

 glDisable(GL_DEPTH_TEST);         
 glDisable(GL_ALPHA_TEST);
 glDisable(GL_FOG);              
 glDisable(GL_LIGHTING);  
 glDisable(GL_LOGIC_OP);
 glDisable(GL_STENCIL_TEST);  
 glDisable(GL_TEXTURE_1D);
 glDisable(GL_TEXTURE_2D);
 glDisable(GL_CULL_FACE);
 glDisable(GL_BLEND);

 glPixelTransferi(GL_RED_SCALE, 1);                    // to be sure:
 glPixelTransferi(GL_RED_BIAS, 0);                     // init OGL vals
 glPixelTransferi(GL_GREEN_SCALE, 1);
 glPixelTransferi(GL_GREEN_BIAS, 0);
 glPixelTransferi(GL_BLUE_SCALE, 1);
 glPixelTransferi(GL_BLUE_BIAS, 0);
 glPixelTransferi(GL_ALPHA_SCALE, 1);
 glPixelTransferi(GL_ALPHA_BIAS, 0);                                                  

/////////////////////////////////

//   glEnable(GL_LINE_SMOOTH);
//   glEnable(GL_POLYGON_SMOOTH);
//   glEnable(GL_POINT_SMOOTH);
//   glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
//   glHint(GL_POINT_SMOOTH_HINT,GL_NICEST);
//   glHint(GL_POLYGON_SMOOTH_HINT,GL_NICEST);

/////////////////////////////////

 glClearColor(0.0f, 0.0f, 0.0f, 0.0f); 
 glClear(GL_COLOR_BUFFER_BIT);
 glAlphaFunc(GL_GREATER,0.49f);
}

///////////////////////////////////////////////////////////////////////////

void DestroyPBuffer(void)
{
 int idx;

 if(pbuf_EFB.tex)    glDeleteTextures(1,&pbuf_EFB.tex);
 pbuf_EFB.tex=0;

 for (idx=0;idx<MAX_XFB_NUM;idx++)
  {
   if(pbuf_XFB[idx].tex) glDeleteTextures(1,&pbuf_XFB[idx].tex);
   pbuf_XFB[idx].tex=0;
  }

 if(pbuf_ETX.hPB)
  {
   wglDeleteContext(pbuf_ETX.hRC);
   wglReleasePbufferDCARB_Ex(pbuf_ETX.hPB,pbuf_ETX.hDC);
   wglDestroyPbufferARB_Ex(pbuf_ETX.hPB);

   pbuf_ETX.hPB=NULL;
   pbuf_ETX.hDC=NULL;
   pbuf_ETX.hRC=NULL;
  }

 if(pbuf_EFB.hPB)
  {
   wglDeleteContext(pbuf_EFB.hRC);
   wglReleasePbufferDCARB_Ex(pbuf_EFB.hPB,pbuf_EFB.hDC);
   wglDestroyPbufferARB_Ex(pbuf_EFB.hPB);

   pbuf_EFB.hPB=NULL;
   pbuf_EFB.hDC=NULL;
   pbuf_EFB.hRC=NULL;
  }

 for(idx=0;idx<MAX_XFB_NUM;idx++)
  {
   if(pbuf_XFB[idx].hPB)
    {
     wglDeleteContext(pbuf_XFB[idx].hRC);
     wglReleasePbufferDCARB_Ex(pbuf_XFB[idx].hPB,pbuf_XFB[idx].hDC);
     wglDestroyPbufferARB_Ex(pbuf_XFB[idx].hPB);

     pbuf_XFB[idx].hPB=NULL;
     pbuf_XFB[idx].hDC=NULL;
     pbuf_XFB[idx].hRC=NULL;
    }
  }
}

///////////////////////////////////////////////////////////////////////////

void window_init(HWND wnd)
{
 HDC hdc;RECT r;DEVMODE dv;

 hWGX = wnd;                                           // store hwnd

 if(!old_winproc)
  {      
   old_winproc=(WNDPROC)GetWindowLong(hWGX,GWL_WNDPROC);
   SetWindowLong(hWGX,GWL_WNDPROC,(long)key_winproc);
  }

 memset(&dv,0,sizeof(DEVMODE));
 dv.dmSize=sizeof(DEVMODE);
 EnumDisplaySettings(NULL,ENUM_CURRENT_SETTINGS,&dv);

 if(iWindowMode)                                       // win mode?
  {
   DWORD dw=GetWindowLong(hWGX,GWL_STYLE);             // -> adjust wnd style
   dw&=~WS_THICKFRAME;
   dw|=WS_BORDER|WS_CAPTION;//|CS_OWNDC;
   SetWindowLong(hWGX,GWL_STYLE,dw);

   hGXMenu=GetMenu(hWGX);                              // -> hide menu
   if(hGXMenu!=NULL) SetMenu(hWGX,NULL);
   ShowWindow(hWGX,SW_SHOWNORMAL);

   MoveWindow(hWGX,                                    // -> center wnd
      GetSystemMetrics(SM_CXFULLSCREEN)/2-iResX/2,
      GetSystemMetrics(SM_CYFULLSCREEN)/2-iResY/2,
      iResX+GetSystemMetrics(SM_CXFIXEDFRAME)+3,
      iResY+GetSystemMetrics(SM_CYFIXEDFRAME)+
      GetSystemMetrics(SM_CYCAPTION)+3,
      TRUE);
   UpdateWindow(hWGX);                                 // -> let windows do some update

   if(dv.dmBitsPerPel==16 || dv.dmBitsPerPel==32)
    iColDepth=dv.dmBitsPerPel;
  }
 else                                                  // no window mode:
  {
   if(dv.dmBitsPerPel!=(unsigned int)iColDepth ||
      dv.dmPelsWidth !=(unsigned int)iResX ||
      dv.dmPelsHeight!=(unsigned int)iResY)
    iChangeRes=1;
   if(iChangeRes) ChangeDesktop();                     // -> had to do an own func because of the MS 'optimizations'

   SetWindowLong(hWGX,GWL_STYLE,CS_OWNDC);             // -> adjust wnd style after
                
   hGXMenu=GetMenu(hWGX);                              // -> hide menu
   if(hGXMenu!=NULL) SetMenu(hWGX,NULL);               
   ShowWindow(hWGX,SW_SHOWMAXIMIZED);                  // -> max mode
  }

 r.left=r.top=0;r.right=iResX;r.bottom=iResY;          // black init
 hdc = GetDC(hWGX);
 FillRect(hdc,&r,(HBRUSH)GetStockObject(BLACK_BRUSH));
 ReleaseDC(hWGX,hdc);
}

///////////////////////////////////////////////////////////////////////////

void context_init(void)
{
 GLfloat fv[4]={1.0f,1.0f,1.0f,1.0f};                    // use full ambient light
// GLfloat fv[4]={0.5f,0.5f,0.5f,1.0f};
// GLfloat fv[4]={0.20f,0.20f,0.20f,1.0f};
// GLfloat fv[4]={0.0f,0.0f,0.0f,1.0f};
 int idx;

 hdcGX = GetDC(hWGX);                        
 
 bSetupPixelFormat(hdcGX);

 rcGX = wglCreateContext(hdcGX); 
 wglMakeCurrent(hdcGX,rcGX);

 InitOpenGLExts();

 Create_EFB_PBuffer(EFB_DX,EFB_DY,hdcGX);
 Create_XFB_PBuffer(EFB_DX,EFB_DY,hdcGX);
 Create_ETX_PBuffer(EFB_DX,EFB_DY,pbuf_EFB.hDC);

 glViewport(0,0,iResX,iResY);
 glScissor (0,0,iResX,iResY);                    
 glEnable(GL_SCISSOR_TEST);                       

 glMatrixMode(GL_PROJECTION);
 glLoadIdentity();
 glOrtho(0,iResX,iResY,0,-1,1);

 glDisable(GL_DEPTH_TEST);         
 glDisable(GL_ALPHA_TEST);
 glDisable(GL_FOG);       
 glDisable(GL_LIGHTING);  
 glDisable(GL_LOGIC_OP);
 glDisable(GL_STENCIL_TEST);  
 glDisable(GL_TEXTURE_1D);
 glDisable(GL_TEXTURE_2D);
 glDisable(GL_CULL_FACE);
 glDisable(GL_BLEND);

 glPixelTransferi(GL_RED_SCALE, 1);  
 glPixelTransferi(GL_RED_BIAS, 0);   
 glPixelTransferi(GL_GREEN_SCALE, 1);
 glPixelTransferi(GL_GREEN_BIAS, 0);
 glPixelTransferi(GL_BLUE_SCALE, 1);
 glPixelTransferi(GL_BLUE_BIAS, 0);
 glPixelTransferi(GL_ALPHA_SCALE, 1);
 glPixelTransferi(GL_ALPHA_BIAS, 0);                                                  

 glClearColor(0.0f, 0.0f, 0.0f, 0.0f); 
 glClear(GL_COLOR_BUFFER_BIT);
 glAlphaFunc(GL_GREATER,0.49f);

 SwapBuffers(hdcGX);

 glClear(GL_COLOR_BUFFER_BIT);

 SwapBuffers(hdcGX);

 glEnable( GL_TEXTURE_2D );

 glFlush();                                          
 glFinish();                     

 InitFPS();
 MakeFPSMenu();

 for(idx=0;idx<MAX_XFB_NUM;idx++)                      // init XFB buffers
  InitPBContext(&pbuf_XFB[idx]);

 InitPBContext(&pbuf_ETX);                             // init EFB texture
 InitPBContext(&pbuf_EFB);                             // activate EFB at last

 vx_create_shader();

 glLightModelfv(GL_LIGHT_MODEL_AMBIENT,fv);

 ReleaseDC(hWGX,hdcGX);
 hdcGX=NULL;
}

///////////////////////////////////////////////////////////////////////////

void ogl_init(HWND wnd)
{
 pbTransferBuf=(BYTE *)malloc(1024*1024*4);
 pbTransferBufEx=(BYTE *)malloc(1024*1024*4);
 window_init(wnd);
 context_init();
}

///////////////////////////////////////////////////////////////////////////

void ogl_close(void)
{
 if(pbTransferBuf) free(pbTransferBuf);
 pbTransferBuf=0;

 if(pbTransferBufEx) free(pbTransferBufEx);
 pbTransferBufEx=0;

 hdcGX = GetDC(hWGX);                        

 wglMakeCurrent(hdcGX,rcGX);

 DestroyPBuffer();

 KillFPSMenu();

 wglMakeCurrent(NULL,NULL);                        

 if(rcGX) wglDeleteContext(rcGX);
 rcGX=NULL;

 if(hdcGX) ReleaseDC(hWGX,hdcGX);
 hdcGX=NULL;

 if(iChangeRes)                                        // change res back
  ChangeDisplaySettings(NULL,0);

 if(hGXMenu)                                           // set menu again
  SetMenu(hWGX,hGXMenu);                               

 if(old_winproc)
  SetWindowLong(hWGX,GWL_WNDPROC,(long)old_winproc);  
 old_winproc = 0;
}

///////////////////////////////////////////////////////////////////////////
// transfer EFB to texture. 
// FIXME: no zbuffer transfers right now (maybe WGL_NV_render_depth_texture, eh?)

void ogl_finish_efb_texture(void)
{
 int iTexWid,iTexHei,iEfbWid,iEfbHei;//,idx,idc,iCheck;
 float dl,dr,db,dt;
 float sl,sr,sb,st;
 RECT r;
 uint32 tex;
 
 if(vx_started) 
  {
#ifdef AUX_ILLEGALCALLS
   auxprintf("illegal efb texture\n");
#endif
   glEnd();
  }

 iEfbWid=efb_info.right+1;
 iEfbHei=efb_info.bottom+1;

#ifdef AUX_ENABLE
if(GetAsyncKeyState(VK_SHIFT)&32768)
 auxprintf("render tex %08x, %d,%d,%d,%d\n",efb_info.xfb_address,
  efb_info.left,
  efb_info.top,
  iEfbWid,
  iEfbHei);
#endif

 // we assume 32 bit RGBA format for now (*4)
 gx_cache_mark_valid(efb_info.xfb_address,iEfbWid*iEfbHei*4);

 // we need a pow2 render texture, so for example:640x480 -> 1024x512
 calc_pow2(iEfbWid,iEfbHei,&iTexWid,&iTexHei);

 // we only have a 1024*512 pbuffer area, so check limits 
 if(iTexWid>EFB_DX)  iTexWid=EFB_DX;
 if(iTexHei>EFB_DY)  iTexHei=EFB_DY;

 // create/reuse texture, and put it in cache
 tc_check_fbtex(efb_info.xfb_address,iTexWid,iTexHei,&tex);
                  
/*           
 glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT24_ARB ,
                     efb_info.left,
                     efb_info.top+32,//+efb_info.bottom,
                     iEfbWid,
                     iEfbHei,0);
 return;
*/

#ifdef NO_XFB_BUFFERS
 // texture is still bound, so we can just copy here
 // beware: without pbuffer, we cannot scale correctly to POW2... and 
 // the tetxure will be up-side-down
 glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 
                     0,0,
                     efb_info.left,
                     efb_info.top+32,//+efb_info.bottom,
                     iEfbWid,
                     iEfbHei);
 if(vx_started) {glBegin(vx_started-1);vx_started=0;}
 return;
#endif

 // do the dirty work:

 wglMakeCurrent(pbuf_ETX.hDC,pbuf_ETX.hRC);

 glBindTexture(GL_TEXTURE_2D,pbuf_EFB.tex);
 //glBindTexture(GL_TEXTURE_2D,depthtex);

 wglBindTexImageARB_Ex(pbuf_EFB.hPB,WGL_FRONT_LEFT_ARB);

 glColor4ub(0xff,0xff,0xff,0xff) ;

 r.left   = efb_info.left;
 r.top    = efb_info.top;
 r.right  = efb_info.right+r.left+1;
 r.bottom = efb_info.bottom+r.top+1;

 r.top=479-r.top;                                      // mmm... fixme: we assume 480 y size always
 r.bottom=479-r.bottom;

 sl=(float)(r.left)/(float)EFB_DX;
 sr=(float)(r.right)/(float)EFB_DX;
 st=(float)(r.top)/(float)EFB_DY;
 sb=(float)(r.bottom)/(float)EFB_DY;

 dl=0;
 dr=iTexWid;
 dt=iTexHei;
 db=0;

 glEnable(GL_TEXTURE_2D);

 glBegin( GL_TRIANGLE_STRIP );
    glTexCoord2f(sl,sb);
    glVertex2i(dl,db);

    glTexCoord2f(sl,st);
    glVertex2i(dl,dt);

    glTexCoord2f(sr,sb);
    glVertex2i(dr,db);

    glTexCoord2f(sr,st);
    glVertex2i(dr,dt);
 glEnd();

 wglReleaseTexImageARB_Ex(pbuf_EFB.hPB,WGL_FRONT_LEFT_ARB);

 glBindTexture(GL_TEXTURE_2D, tex);

/*
 glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 
                     0,0,
                     0,0,
                     iTexWid,
                     iTexHei);
*/

 glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 
                     0,0,
                     0,EFB_DY-iTexHei,
                     iTexWid,
                     iTexHei);

 wglMakeCurrent(pbuf_EFB.hDC,pbuf_EFB.hRC);

 if(vx_started) {glBegin(vx_started-1);vx_started=0;}
}

///////////////////////////////////////////////////////////////////////////
// transfer main emu YCbYCr memory to our XFB buffer

void ogl_transfer_YCbYCr_to_xfb(int idx)
{
 int x,y;uint32 * ps;uint32 * pd;
 int Cr,Cb;int R1,R2,G1,G2,B1,B2;
 uint32 Y1,Y2;

 // auxprintf("-> %x\n",fb_addr);

 wglMakeCurrent(pbuf_XFB[idx].hDC,pbuf_XFB[idx].hRC);

 // fill pbTransferBuf with RGBA values

 ps=(uint32 *)(gx_memory+fb_addr);
 pd=(uint32 *)pbTransferBuf;

 for(y=0;y<pbuf_XFB[idx].fb_height;y++)
  {
   for(x=0;x<320;x++)
    {
     Cb=(*ps>>24);
     Y1=(*ps>>16)&0xFF;
     Cr=(*ps>>8) &0xFF;
     Y2=(*ps)    &0xFF;

     R1=Y1+1.371f*(Cr-128);
     if(R1<0) R1=0; else if(R1>255) R1=255;

     G1=Y1-0.698f*(Cr-128)-0.336f*(Cb-128);
     if(G1<0) G1=0; else if(G1>255) G1=255;

     B1=Y1+1.732f*(Cb-128);
     if(B1<0) B1=0; else if(B1>255) B1=255;

     R2=Y2+1.371f*(Cr-128);
     if(R2<0) R2=0; else if(R2>255) R2=255;

     G2=Y2-0.698f*(Cr-128)-0.336f*(Cb-128);
     if(G2<0) G2=0; else if(G2>255) G2=255;

     B2=Y2+1.732f*(Cb-128);
     if(B2<0) B2=0; else if(B2>255) B2=255;

     *pd=((R2<<16)|(G2<<8)|(B2));
     pd++;
     *pd=((R1<<16)|(G1<<8)|(B1));
     pd++;

     ps++;
    }
  }

 glRasterPos2i(0,480);
 glDrawPixels(640,pbuf_XFB[idx].fb_height,GL_RGBA,GL_UNSIGNED_BYTE,pbTransferBuf);

// not needed, after this func there will be always a context switch + swap
//  wglMakeCurrent(pbuf_EFB.hDC,pbuf_EFB.hRC);
}

///////////////////////////////////////////////////////////////////////////
// make backbuffer black, swap

void ogl_finish_xfb_black(void)
{
 hdcGX = GetDC(hWGX);                        
 wglMakeCurrent(hdcGX,rcGX);

 glClear(GL_COLOR_BUFFER_BIT);

 DisplayFPSMenu();

 SwapBuffers(hdcGX);

 wglMakeCurrent(pbuf_EFB.hDC,pbuf_EFB.hRC);

 ReleaseDC(hWGX,hdcGX);
 hdcGX=NULL;
}

///////////////////////////////////////////////////////////////////////////
// transfer xfb[idx]->backbuffer, swap

void ogl_finish_xfb_render(int idx)
{
 float dl,dr,db,dt;
 float sl,sr,sb,st;
 RECT r;

 // do "black screen" detection

 if((((fb_odd)==0 && (fb_even)==0)) ||
    (fb_addr!=0x200000 &&                              // HACK! acube demo sets big odd/even values... dunno how that's possible... well, it's using this fb_addr, so we let it run
     ((fb_odd)>=0x1F0 && (fb_even)>=0x1F0)))
  {
   ogl_finish_xfb_black();
//   if(vx_started) {glBegin(vx_started-1);vx_started=0;}
   return;
  }

 hdcGX = GetDC(hWGX);                        

 wglMakeCurrent(hdcGX,rcGX);
 glBindTexture(GL_TEXTURE_2D,pbuf_XFB[idx].tex);
 wglBindTexImageARB_Ex(pbuf_XFB[idx].hPB,WGL_FRONT_LEFT_ARB);
 
 glColor4ub(0xff,0xff,0xff,0xff) ;

 r.left=0; 
 r.right=640;
 r.top=EFB_DY-pbuf_XFB[idx].fb_height;
 r.bottom=EFB_DY;

 sl=(float)(r.left)/(float)EFB_DX;
 sr=(float)(r.right)/(float)EFB_DX;
 st=(float)(r.top)/(float)EFB_DY;
 sb=(float)(r.bottom)/(float)EFB_DY;

 dl=0;
 dr=iResX;
 dt=0;
 db=iResY;

 glEnable(GL_TEXTURE_2D);

 glBegin( GL_TRIANGLE_STRIP );
    glTexCoord2f(sl,sb);
    glVertex2i(dl,db);

    glTexCoord2f(sl,st);
    glVertex2i(dl,dt);

    glTexCoord2f(sr,sb);
    glVertex2i(dr,db);

    glTexCoord2f(sr,st);
    glVertex2i(dr,dt);
 glEnd();

 wglReleaseTexImageARB_Ex(pbuf_XFB[idx].hPB,WGL_FRONT_LEFT_ARB);

 DisplayFPSMenu();

 SwapBuffers(hdcGX);

 wglMakeCurrent(pbuf_EFB.hDC,pbuf_EFB.hRC);

 ReleaseDC(hWGX,hdcGX);
 hdcGX=NULL;
}


///////////////////////////////////////////////////////////////////////////
// clear EFB

void ogl_finish_efb_clear(void)
{
 glDisable(GL_SCISSOR_TEST);                       
 glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
 glEnable(GL_SCISSOR_TEST);                       
}

///////////////////////////////////////////////////////////////////////////
// transfer efb->xfb[idx]

/*
 if(GetAsyncKeyState(VK_SHIFT)&32768)
  auxprintf("efb %08x: %d;%d,%d,%d,%d\n",efb_info.xfb_address,efb_info.yscale,efb_info.left,efb_info.top,efb_info.right,efb_info.bottom);
*/
/*
if(GetAsyncKeyState(VK_SHIFT)&32768)
 for(idx=0;idx<MAX_XFB_NUM;idx++)
  auxprintf("efb %d,%x,%x,%x\n",idx,pbuf_XFB[idx].fb_addr,fb_addr,efb_info.xfb_address);
*/
/*
if(GetAsyncKeyState(VK_SHIFT)&32768)
 auxprintf("efb -> %d\n",idx);
*/

///////////////////////////////////////////////////////////////////////////

void ogl_finish_efb_render(void)
{
 int idx,iClear=0,iAdjust;
 float dl,dr,db,dt;
 float sl,sr,sb,st;
 RECT r;

 if(vx_started) 
  {
#ifdef AUX_ILLEGALCALLS
   auxprintf("illegal efb render\n");
#endif
   glEnd();
  }

 for(idx=0;idx<MAX_XFB_NUM;idx++)                      // we assume that the xfb display are is always 640x480... that's wrong for sure
  {
   if(pbuf_XFB[idx].fb_addr &&
      efb_info.xfb_address>=pbuf_XFB[idx].fb_addr &&   
      efb_info.xfb_address< pbuf_XFB[idx].fb_addr+(640*pbuf_XFB[idx].fb_height*2))
    break;
  }

 if(idx==MAX_XFB_NUM)                                  // nothing found: we use least-used XFB 
  {
   int iCheck=10000,idc;

   idx=1;
   for(idc=0;idc<MAX_XFB_NUM;idc++)                    // loop for searching the least used xfb
    {
     if(pbuf_XFB[idc].usage_count<=iCheck) 
      {iCheck=pbuf_XFB[idc].usage_count;idx=idc;}
    }

   pbuf_XFB[idx].fb_addr=efb_info.xfb_address;
   pbuf_XFB[idx].fb_height=480;

   iClear=1;
  }

 pbuf_XFB[idx].efb_copied=60;
 pbuf_XFB[idx].usage_count=10000;
                                                        
#ifdef NO_XFB_BUFFERS
 hdcGX = GetDC(hWGX);                        
 wglMakeCurrent(hdcGX,rcGX);
#else
 wglMakeCurrent(pbuf_XFB[idx].hDC,pbuf_XFB[idx].hRC);
#endif

 glBindTexture(GL_TEXTURE_2D,pbuf_EFB.tex);
 wglBindTexImageARB_Ex(pbuf_EFB.hPB,WGL_FRONT_LEFT_ARB);

 glColor4ub(0xff,0xff,0xff,0xff) ;

 iAdjust=480-pbuf_XFB[idx].fb_height;
 if(iAdjust<0) iAdjust=0;

 r.left   = efb_info.left;
 r.top    = efb_info.top+iAdjust;
 r.right  = efb_info.right;
 r.bottom = efb_info.bottom+iAdjust;

/*
 r.left=0;
 r.top=0;
 r.bottom=480;
 r.right=640;
*/
//160,319,120,239 (0)

// r.right=640;

#ifdef AUX_ENABLE
if(GetAsyncKeyState(VK_SHIFT)&32768)
 auxprintf("%d,%d,%d,%d (%d)\n",r.left,r.right,r.top,r.bottom,iAdjust);
#endif

 sl=(float)(r.left)/(float)EFB_DX;
 sr=(float)(r.right)/(float)EFB_DX;
 st=(float)(r.top)/(float)EFB_DY;
 sb=(float)(r.bottom)/(float)EFB_DY;

 dl=0;
 dr=r.right-r.left;//640;
 dt=0;
 db=r.bottom-r.top;//480;

#ifdef NO_XFB_BUFFERS
 dt=db;db=0;
#endif

 if(iClear) glClear(GL_COLOR_BUFFER_BIT); 

 glEnable(GL_TEXTURE_2D);

 glBegin( GL_TRIANGLE_STRIP );
    glTexCoord2f(sl,sb);
    glVertex2i(dl,db);

    glTexCoord2f(sl,st);
    glVertex2i(dl,dt);

    glTexCoord2f(sr,sb);
    glVertex2i(dr,db);

    glTexCoord2f(sr,st);
    glVertex2i(dr,dt);
 glEnd();

 wglReleaseTexImageARB_Ex(pbuf_EFB.hPB,WGL_FRONT_LEFT_ARB);

 wglMakeCurrent(pbuf_EFB.hDC,pbuf_EFB.hRC);

 if(vx_started) {glBegin(vx_started-1);vx_started=0;}

#ifdef NO_XFB_BUFFERS
 ReleaseDC(hWGX,hdcGX);
 hdcGX=NULL;
#endif
}

///////////////////////////////////////////////////////////////////////////
// VSYNC (XFB -> BACKBUFFER, SWAP)

/*
 if(GetAsyncKeyState(VK_SHIFT)&32768)
  auxprintf("vsync %08x\n",fb_addr);
*/
/*
 if(GetAsyncKeyState(VK_SHIFT)&32768)
  auxprintf("%04X;%04X;%08X;%08X;%04X;%04X\n",(uint32)fb_vtr,(uint32)fb_dcr,fb_htr0,fb_htr1,(uint32)fb_hsw,(uint32)fb_hsr);
*/
/*
if(GetAsyncKeyState(VK_SHIFT)&32768)
 for(idx=0;idx<MAX_XFB_NUM;idx++)
  auxprintf("check %d,%x,%x,%d\n",idx,pbuf_XFB[idx].fb_addr,fb_addr,pbuf_XFB[idx].efb_copied);
*/
/*
if(GetAsyncKeyState(VK_SHIFT)&32768)
 auxprintf("check -> %d\n",idx);
*/
/*
if(GetAsyncKeyState(VK_SHIFT)&32768)
 auxprintf("Xchk -> %d\n",idx);
*/
//auxprintf("check %d,%x,%x,%d\n",idx,pbuf_XFB[idx].fb_addr,fb_addr,pbuf_XFB[idx].efb_copied);

//if(GetAsyncKeyState(VK_SHIFT)&32768)
// auxprintf("%d,%04X,%04X;%04X;%08X;%08X;%04X;%04X\n",fb_prgr,fb_dcr&0x300,(uint32)fb_vtr,(uint32)fb_dcr,fb_htr0,fb_htr1,(uint32)fb_hsw,(uint32)fb_hsr);
//if((fb_hsr&0x1ff)!=0x100) auxprintf(">SCALE: %x\n",(fb_hsr&0x1ff));
//auxprintf("%08X,%08X,%08X\n",fb_odd,fb_even,fb_addr);

///////////////////////////////////////////////////////////////////////////

void ogl_vsync(void)         
{
 int idx,idc,idz,iSwap=0,iHei;uint32 max_copy;

 CheckFrameRate();

 //if(vx_started) glEnd();                             // needed!
 if(vx_started) 
  {
#ifdef AUX_ILLEGALCALLS
//   auxprintf("illegal vsync\n");
#endif             
   return;                                             // or even better: we don't do swap
  }

#ifdef NO_XFB_BUFFERS
 hdcGX = GetDC(hWGX);                        
 wglMakeCurrent(hdcGX,rcGX);
 DisplayFPSMenu();
 SwapBuffers(hdcGX);
 wglMakeCurrent(pbuf_EFB.hDC,pbuf_EFB.hRC);
 ReleaseDC(hWGX,hdcGX);
 hdcGX=NULL;
 if(vx_started) {glBegin(vx_started-1);vx_started=0;}
 return;
#endif


 // 1. check in a loop, if one of our pbuf_XFB[] has the start address
 //    in "fb_addr" is the to-be-displayed start address
 //    in "fb_vtr"  is the height
 //    and the width? dunno... set it to fixed 640 right now

 // FIXME: *2 is only correct in interlace(efb 60Hz) or double-strike mode... and it's 
 // not correct to already set it here... we should do the *2 in last stage, before swap
 // in interlace (efb 30 Hz) mode, do an 1:1 display 

 iHei=(fb_vtr&0x3ff0)>>3;                              // mmm... *2 seems to be correct
 if(iHei==0) iHei=480;                                 // can happen (acube demo)
 if(iHei>EFB_DY) iHei=EFB_DY;                          // we only have a 512 height buffer for now

//auxprintf("hei %d\n",iHei);

//iHei=480;

 for(idx=0;idx<MAX_XFB_NUM;idx++)
  {
   if(pbuf_XFB[idx].fb_addr &&                         // we assume that the xfb display are is always 640x480... that's wrong for sure
      pbuf_XFB[idx].fb_addr>=fb_addr &&                
      pbuf_XFB[idx].fb_addr< fb_addr+(640*iHei*2))
      //&& pbuf_XFB[idx].efb_copied==60)
    break;
  }

 // 1a : not correct, but it will solve certain problems which can occurr because of my uncomplete fbaddress handling
 //      beware, that this loop will make the above search nearly always useless

//if(idx==MAX_XFB_NUM)
//{
 max_copy=59;idz=-1;

 for(idc=0;idc<MAX_XFB_NUM;idc++)
  {
   if(pbuf_XFB[idc].efb_copied>=max_copy) 
    {max_copy=pbuf_XFB[idc].efb_copied;idz=idc;}
  }

 if(idz!=-1) {idx=idz;}
//}

 // 1b : still nothing found

 if(idx==MAX_XFB_NUM)                                  // no xfb pbuffer for this address found
  {
   int iCheck=10000;

   idx=1;
   for(idc=0;idc<MAX_XFB_NUM;idc++)                    // loop for searching the least used xfb
    {
     if(pbuf_XFB[idc].usage_count<=iCheck) 
      {iCheck=pbuf_XFB[idc].usage_count;idx=idc;}
    }

   pbuf_XFB[idx].fb_addr=fb_addr;                      // -> sel the least used xfb
   pbuf_XFB[idx].efb_copied=0;
  }

 // 2. check, if a efb transfer happened before, or if we have to transfer some main mem -> xfb buffer, or if we do nothing

 pbuf_XFB[idx].fb_height=iHei;

 if(pbuf_XFB[idx].efb_copied==60)                      // efb/gfx transfer before this vsync
  {
   iSwap=1;
   pbuf_XFB[idx].efb_copied=59;
  }
 else
 if(pbuf_XFB[idx].efb_copied==0 && iFBUpload)          // no efb/gfx transfer to this buffer yet?
  {
   iSwap=1;
   pbuf_XFB[idx].usage_count=10000;
   pbuf_XFB[idx].efb_copied=iFBUpload-1;               // change this value for more/less uploads
   ogl_transfer_YCbYCr_to_xfb(idx);
  }
 else                                                  // we are delaying swaps until something happens
  {
   pbuf_XFB[idx].efb_copied--;
  }                       

 pbuf_XFB[idx].usage_count--;

 if(iSwap==1)
  {
   pbuf_EFB.fb_addr=fb_addr;                           // store last xfb address (mayve I can use that later)
   ogl_finish_xfb_render(idx);                         // do the real transfer+swap
  }

 if(vx_started) {glBegin(vx_started-1);vx_started=0;}
}

///////////////////////////////////////////////////////////////////////////
