/***************************************************************************
                          gx_cache.c  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2005 by Duddie
    email                : duddie@walla.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
//*************************************************************************//

#include "stdafx.h"
#include "gx_cache.h"
#define _IN_GXCACHE
#include "externals.h"

///////////////////////////////////////////////////////////////////////////
// GLOBALS

uint8 *gx_cache_table;

///////////////////////////////////////////////////////////////////////////
// DEFINES

#define GX_CACHE_SIZE ((24*1024*1024)>>GX_CACHE_BLOCKSHIFT)

///////////////////////////////////////////////////////////////////////////
// CODE

int gx_cache_init(void)
{
 gx_cache_table = (uint8 *)malloc(GX_CACHE_SIZE);
 if(gx_cache_table == NULL)
  {
// printf("[GX] failed to allocate memory for gx cache table\n");
   return -1;
  }

// printf("[GX] allocated %d for gx cache table (blocksize: %d bytes)\n", GX_CACHE_SIZE, GX_CACHE_BLOCKSIZE);

 // mark whole table as empty
 memset(gx_cache_table, 0xff, GX_CACHE_SIZE);

 return 0;
}

///////////////////////////////////////////////////////////////////////////

void gx_cache_snoop(uint32 address)
{
/*  
 if ( (address > 0x1e59a0) && (address < 0x1f59a0))
  {
        fprintf(stderr, "snoop: %08x\n", address);
  }
*/  

 gx_cache_table[address>>GX_CACHE_BLOCKSHIFT] = 0xff;
}

///////////////////////////////////////////////////////////////////////////

void gx_cache_mark_valid(uint32 address, uint32 size)
{
 uint32 address_walker, address_end;
    
 address_walker = address;
 address_end = address+size;
 do
  {
   // mark as in-use
   gx_cache_table[address_walker>>GX_CACHE_BLOCKSHIFT] = 0;
   address_walker += GX_CACHE_BLOCKSIZE;
  }
 while(address_walker < address_end);
}

///////////////////////////////////////////////////////////////////////////

void gx_cache_mark_invalid(uint32 address, uint32 size)
{
 uint32 address_walker, address_end;
    
 address_walker = address;
 address_end = address+size;

 do
 {
  // mark as dirty
  gx_cache_table[address_walker>>GX_CACHE_BLOCKSHIFT] = 0xff;
  address_walker += GX_CACHE_BLOCKSIZE;
 }
 while(address_walker < address_end);
}

///////////////////////////////////////////////////////////////////////////

uint8 gx_cache_check(uint32 address, uint32 size)
{
 uint32 address_walker, address_end;
 uint8 dirty = 0;

 address_walker = address;
 address_end = address+size;

 do
  {
   // check if modified (0xff means modified)
   dirty |= gx_cache_table[address_walker>>GX_CACHE_BLOCKSHIFT];
   address_walker += GX_CACHE_BLOCKSIZE;
  }
 while(address_walker < address_end);       

 return dirty;
}

///////////////////////////////////////////////////////////////////////////
