/*====================================================================

filename:     ppc_disasm.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once
#include "system/types.h"
//
// simplified interface to debugger
//

int GekkoDisassemble(
    char *  opcodeStr, 
    char *  operandStr, 
    uint32     opcode, 
    uint32     curInstAddr, 
    uint32  *  nextInstAddr);

//
// returned opcode types (for high-lighting etc)
//

#define BRANCH_OPCODE       1
#define LDST_OPCODE         2

/*
 *  Usage example 1 (simple) :
 *  --------------------------
 *
 *   char buf[64], opStr[16], parmStr[32];
 *   uint32 target;
 *
 *   GekkoDisassemble(opStr, parmStr, opcode, PC, &target);
 *   sprintf(buf, "%-10s %s", opStr, parmStr);    
 *
 *   printf("%.8X  %.8X  %s\n", PC, opcode, buf);
 *
 *  Usage example 2 (opcode type information) :
 *  -------------------------------------------
 *
 *   type = GekkoDisassemble(opStr, parmStr, opcode, PC, &target);
 *   if(type == BRANCH_OPCODE)
 *   {
 *       printf("%-12s%s", opStr, parmStr);
 *       printf(" <-- this is branch to %.8X address\n", target);
 *   }
 *   else printf("%-12s%s\n", opStr, parmStr);
 *
 */
