/*====================================================================

filename:     pad.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
// data layout:
//
// pad_datah: 
// bit: button
// 28: BUTTON_START
// 27: BUTTON_X
// 26: BUTTON_Y
// 25: BUTTON_B
// 24: BUTTON_A
// 22: BUTTON_L
// 21: BUTTON_R
// 20: BUTTON_Z
// 19: BUTTON_UP
// 18: BUTTON_DOWN
// 17: BUTTON_RIGHT
// 16: BUTTON_LEFT
// 8-15: Analog X
// 0-7: Analog Y
//
// pad_datal: 
// bit: button
// 24-31: Analog CX
// 16-23: Analog CY
// 8-15: Analog L
// 0-7: Analog R
//
// Analog is 0-128-255 unsigned data 128 middle, for triggers it is 0-255 255 means fully pressed
//
struct pad_data
{
	uint32 connected; // 1 when connected, 0 not connected
	uint32 pad_datah;
	uint32 pad_datal;
};

bool pad_read(void);

