/*====================================================================

filename:     ipl_rom.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#include "system/types.h"
#include "ipl_rom.h"

#define IPL_ROM_SIZE (2*1024*1024)
uint8 *ipl_rom;

struct ipl_file
{
	char	*filename;
	uint32	addr;
};

struct ipl_file ipl_files[] = 
{
	{"fonts/lucida16.yay",	0x1aff00},
	{"fonts/arial16.yay",	0x1fcf00},
	{NULL, 0}
};

void ipl_init(void)
{
	FILE *in;
	size_t size;
	int i;

	ipl_rom = (uint8 *)malloc(IPL_ROM_SIZE);
	i = 0;
	while(ipl_files[i].filename)
	{
		in = fopen(ipl_files[i].filename, "rb");
		if (!in)
		{
			printf("Cannot open required file: %s\n", ipl_files[i].filename);
			exit(0);
		}
		size = fread(ipl_rom + ipl_files[i].addr, 1, 200000, in);
		if (size == 0)
			size = fread(ipl_rom + ipl_files[i].addr, 1, 20000, in);
		fclose(in);
		printf("Loaded %s of size %d to IPL ROM\n", ipl_files[i].filename, size);
		i++;
	}
}

void ipl_close(void)
{
	free(ipl_rom);
	ipl_rom = NULL;
}