/*====================================================================

filename:     video_interface.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include <stdio.h>

#include "config.h"

#include "system/types.h"
#include "plugins/gx_plugin.h"

void vi_write_register8(uint32 addr, uint8 data)
{
	GX_VIWriteRegister8(addr, data);
}
void vi_write_register16(uint32 addr, uint16 data)
{
	GX_VIWriteRegister16(addr, data);
}
void vi_write_register32(uint32 addr, uint32 data)
{
	GX_VIWriteRegister32(addr, data);
}

uint8 vi_read_register8(uint32 addr)
{
	return GX_VIReadRegister8(addr);
}
uint16 vi_read_register16(uint32 addr)
{
	return GX_VIReadRegister16(addr);
}
uint32 vi_read_register32(uint32 addr)
{
	return GX_VIReadRegister32(addr);
}

bool vi_check_interrupt(void)
{
	return GX_VICheckInterrupt();
}

void vi_next_scanline(void)
{
	GX_VINextScanline();
}