/*====================================================================

filename:     serial_interface_defines.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once

#define SI_REGS_SIZE	256


#define SI_REG_UINT32(A)	*((uint32 *)(si_regs + (A)))
#define SI_REG_UINT16(A)	*((uint16 *)(si_regs + (A)))
#define SI_REG_UINT8(A)		*((uint8 *)(si_regs + (A)))

#define SI_WRITE_UINT32(A, D)	SI_REG_UINT32(A) = byteswap32((D))
#define SI_WRITE_UINT16(A, D)	SI_REG_UINT16(A) = byteswap16((D))
#define SI_WRITE_UINT8(A, D)	SI_REG_UINT8(A) = (uint8)(D)

#define SI_READ_UINT32(A)		(byteswap32(SI_REG_UINT32(A)))
#define SI_READ_UINT16(A)		(byteswap16(SI_REG_UINT16(A)))
#define SI_READ_UINT8(A)		(SI_REG_UINT8(A))


// COMCSR register bits
#define	SI_TCINT_BIT		(31)
#define SI_TCINT			(1 << SI_TCINT_BIT)
#define SI_TCINTMASK_BIT	(30)
#define SI_TCINTMASK		(1 << SI_TCINTMASK_BIT)
#define	SI_RDSTINT_BIT		(28)
#define SI_RDSTINT			(1 << SI_RDSTINT_BIT)
#define SI_RDSTINTMASK_BIT	(27)
#define SI_RDSTINTMASK		(1 << SI_RDSTINTMASK_BIT)
#define SI_TSTART_BIT		(0)
#define SI_TSTART			(1 << SI_TSTART_BIT)
#define SI_CHANNEL_BIT		(1)

// SR register bits
#define SI_RDST0_BIT		(29)
#define	SI_RDST0			(1 << SI_RDST0_BIT)
#define SI_RDST1_BIT		(21)
#define	SI_RDST1			(1 << SI_RDST1_BIT)
#define SI_RDST2_BIT		(13)
#define	SI_RDST2			(1 << SI_RDST2_BIT)
#define SI_RDST3_BIT		(5)
#define	SI_RDST3			(1 << SI_RDST3_BIT)

#define	SI_REG_C0_OUTBUF	(0x00)
#define	SI_REG_C0_INBUFH	(0x04)
#define	SI_REG_C0_INBUFL	(0x08)
#define	SI_REG_C1_OUTBUF	(0x0c)
#define	SI_REG_C1_INBUFH	(0x10)
#define	SI_REG_C1_INBUFL	(0x14)
#define	SI_REG_C2_OUTBUF	(0x18)
#define	SI_REG_C2_INBUFH	(0x1c)
#define	SI_REG_C2_INBUFL	(0x20)
#define	SI_REG_C3_OUTBUF	(0x24)
#define	SI_REG_C3_INBUFH	(0x28)
#define	SI_REG_C3_INBUFL	(0x2c)

#define	SI_REG_POLL			(0x30)
#define	SI_REG_COMCSR		(0x34)
#define	SI_REG_SR			(0x38)

#define	SI_REG_EXILCK		(0x3c)

// 128 bytes of communication RAM
#define	SI_REG_BUF			(0x80)
