/*====================================================================

filename:     pe_interface.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include "system/types.h"
#include "pe_interface.h"
#include "hardware/hw_io.h"
#include "hardware/memory_interface.h"

#include "plugins/gx_plugin.h"

/*
#define PE_REGS_SIZE	256
char pe_regs[PE_REGS_SIZE];
no more PE_Regs
*/
/* GX_Init will initalize PEregs
void pe_init(void)
{
	int i;
	for (i = 0 ; i < PE_REGS_SIZE ; i++)
	{
		pe_regs[i] = 0;
	}
}

void pe_close(void)
{
}

extern bool pe_finished;


#define PE_REG_UINT32(A)	*((uint32 *)(pe_regs + (A)))
#define PE_REG_UINT16(A)	*((uint16 *)(pe_regs + (A)))
#define PE_REG_UINT8(A)		*((uint8 *)(pe_regs + (A)))

#define PE_WRITE_UINT32(A, D)	PE_REG_UINT32(A) = byteswap32((D))
#define PE_WRITE_UINT16(A, D)	PE_REG_UINT16(A) = byteswap16((D))
#define PE_WRITE_UINT8(A, D)	PE_REG_UINT8(A) = (uint8)(D)

#define PE_READ_UINT32(A)		(byteswap32(PE_REG_UINT32(A)))
#define PE_READ_UINT16(A)		(byteswap16(PE_REG_UINT16(A)))
#define PE_READ_UINT8(A)		(PE_REG_UINT8(A))

void pe_write_register8(uint32 addr, uint8 data)
{
	PE_WRITE_UINT8(addr & 0xff, data);
	switch(addr & 0xff)
	{
	case 0x0a:
		if (data & 0x08) pe_finished = false;
		break;
	default:
		break;
	}
}

void pe_write_register16(uint32 addr, uint16 data)
{
	PE_WRITE_UINT16(addr & 0xff, data);
	switch(addr & 0xff)
	{
	case 0x0a:
		if (data & 0x08) pe_finished = false;
		break;
	default:
		break;
	}
}

void pe_write_register32(uint32 addr, uint32 data)
{
	PE_WRITE_UINT32(addr & 0xff, data);
	switch(addr & 0xff)
	{
	case 0x0a:
		if (data & 0x08) pe_finished = false;
		break;
	default:
		break;
	}
}

uint8 pe_read_register8(uint32 addr)
{
	uint8 data;
	data = PE_READ_UINT8(addr & 0xff);

	switch(addr & 0xff)
	{
	case 0x0a:
		if (pe_finished)
			data |= 0x04;
		break;
	default:
		break;
	}
	return data;
}

uint16 pe_read_register16(uint32 addr)
{
	uint16 data;
	data = PE_READ_UINT16(addr & 0xff);

	switch(addr & 0xff)
	{
	case 0x0a:
		if (pe_finished)
			data |= 0x04;
		break;
	default:
		break;
	}
	return data;
}

uint32 pe_read_register32(uint32 addr)
{
	uint32 data;
	data = PE_READ_UINT32(addr & 0xff);

	switch(addr & 0xff)
	{
	case 0x0a:
		if (pe_finished)
			data |= 0x04;
		break;
	default:
		break;
	}
	return data;
}
*/

void pe_write_register8(uint32 addr, uint8 data)
{
	GX_PEWriteRegister8(addr, data);
}
void pe_write_register16(uint32 addr, uint16 data)
{
	GX_PEWriteRegister16(addr, data);
}
void pe_write_register32(uint32 addr, uint32 data)
{
	GX_PEWriteRegister32(addr, data);
}

uint8 pe_read_register8(uint32 addr)
{
	return GX_PEReadRegister8(addr);
}
uint16 pe_read_register16(uint32 addr)
{
	return GX_PEReadRegister16(addr);
}
uint32 pe_read_register32(uint32 addr)
{
	return GX_PEReadRegister32(addr);
}