/*====================================================================

filename:     memory_interface.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
// memory interface for GC 
// takes care of memory map
// 
//
#include "system/types.h"

// direct access to GC main memory is NOT recommended!
extern uint8 *gMemory;

// allocates and initialises memory
int mem_init(void);

// debug memory access (does not modify data and reports illegal areas)
bool mem_peek32(uint32 address, uint32 *data);
bool mem_peek8(uint32 address, uint8 *data);

// memory access routines
uint8 mem_read8(uint32 address);
uint16 mem_read16(uint32 address);
uint32 mem_read32(uint32 address);
uint32 mem_iread(uint32 address);
void mem_write8(uint32 address, uint8 val);
void mem_write16(uint32 address, uint16 val);
void mem_write32(uint32 address, uint32 val);


// byte swapping to go from little endian to big endian
static inline uint32 byteswap32(uint32 data)
{
	__asm
	{
		mov	eax, data
		bswap eax
	}
}

static inline uint64 byteswap64(uint64 data)
{
	return (((uint64)byteswap32((uint32)data)) << 32) | (uint64)byteswap32((uint32)(data >> 32));
}

static inline uint16 byteswap16(uint16 data)
{
	return (data<<8)|(data>>8);
}

