/*====================================================================

filename:     hw_io.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include "system/types.h"
#include <stdlib.h>
#include <string.h>
#include "hardware/serial_interface.h"
#include "hardware/video_interface.h"
#include "hardware/dsp_interface.h"
#include "hardware/processor_interface.h"
#include "hardware/dvd_interface.h"
#include "hardware/external_interface.h"
#include "hardware/audio_interface.h"
#include "hardware/pe_interface.h"
#include "hardware/command_processor_interface.h"

#include "cpu/trx_ppc_cpu.h"

#include "debug/tracers.h"

#define IO_MEM_ACCESS_OK 0

void wpar_set(void);
extern uint32 wpar_hasdata;
// IO routines assume that addresses REALLY ARE in IO address range, it does not validate input for speed reasons!
uint8 mem_read_io8(uint32 address);
uint16 mem_read_io16(uint32 address);
uint32 mem_read_io32(uint32 address);
void mem_write_io8(uint32 address, uint8 val);
void mem_write_io16(uint32 address, uint16 val);
void mem_write_io32(uint32 address, uint32 val);
