#pragma once

#define EXI_REGS_SIZE	256


#define EXI_REG_CPR0	0x00
#define EXI_REG_MAR0	0x04
#define EXI_REG_LEN0	0x08
#define EXI_REG_CR0		0x0c
#define EXI_REG_DATA0	0x10

#define EXI_REG_CPR1	0x14
#define EXI_REG_MAR1	0x18
#define EXI_REG_LEN1	0x1c
#define EXI_REG_CR1		0x20
#define EXI_REG_DATA1	0x24

#define EXI_REG_CPR2	0x28
#define EXI_REG_MAR2	0x2c
#define EXI_REG_LEN2	0x30
#define EXI_REG_CR2		0x34
#define EXI_REG_DATA2	0x38


#define EXI_EXTINT_BIT		(11)
#define	EXI_EXTINT			(1 << EXI_EXTINT_BIT)
#define	EXI_EXTINTMASK_BIT	(10)
#define	EXI_EXTINTMASK		(1 << EXI_EXTINTMASK_BIT)
#define EXI_TCINT_BIT		(3)
#define	EXI_TCINT			(1 << EXI_TCINT_BIT)
#define	EXI_TCINTMASK_BIT	(2)
#define	EXI_TCINTMASK		(1 << EXI_TCINTMASK_BIT)
#define EXI_EXIINT_BIT		(1)
#define	EXI_EXIINT			(1 << EXI_EXIINT_BIT)
#define	EXI_EXIINTMASK_BIT	(0)
#define	EXI_EXIINTMASK		(1 << EXI_EXIINTMASK_BIT)


#define EXI_REG_UINT32(A)	*((uint32 *)(exi_regs + (A)))
#define EXI_REG_UINT16(A)	*((uint16 *)(exi_regs + (A)))
#define EXI_REG_UINT8(A)		*((uint8 *)(exi_regs + (A)))

#define EXI_WRITE_UINT32(A, D)	EXI_REG_UINT32(A) = byteswap32((D))
#define EXI_WRITE_UINT16(A, D)	EXI_REG_UINT16(A) = byteswap16((D))
#define EXI_WRITE_UINT8(A, D)	EXI_REG_UINT8(A) = (uint8)(D)

#define EXI_READ_UINT32(A)		(byteswap32(EXI_REG_UINT32(A)))
#define EXI_READ_UINT16(A)		(byteswap16(EXI_REG_UINT16(A)))
#define EXI_READ_UINT8(A)		(EXI_REG_UINT8(A))

