/*
 *  GCMDiskHeader.h
 *  gcmtool
 *
 *  Created by spike on Mon May 24 2004.
 *  Copyright (c) 2004 Sadistech. All rights reserved.
 *
 */

#ifndef _GCM_DISK_HEADER_H_
#define _GCM_DISK_HEADER_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "GCMutils.h"
#include "system/types.h"

typedef struct gcm_disk_header_struct {
	char	systemID;
	char	gameID[GCM_GAME_ID_LENGTH + 1];
	char	regionCode;
	char	makerCode[GCM_MAKER_CODE_LENGTH + 1];
	char	diskID;
	char	version;
	char	streaming;
	char	streamBufSize;
	uint32		unknown1;				// ? seems to be (c2 33 9f 3d) in all files
	char	gameName[GCM_GAME_NAME_LENGTH];
	uint32		debugMonitorOffset;		// ?
	uint32		debugMonitorAddress;	// ?
	uint32		dolOffset;
	uint32		fstOffset;
	uint32		fstSize;
	uint32		fstSizeMax;
	uint32		userPosition;			// ?
	uint32		userLength;				// ?
	uint32		unknown2;				// ?
}GCMDiskHeaderStruct;

//functions...
void GCMDiskHeaderStructToRaw(GCMDiskHeaderStruct *dh, char *buf);
GCMDiskHeaderStruct *GCMRawDiskHeaderToStruct(char *rawHeader);
void GCMFreeDiskHeaderStruct(GCMDiskHeaderStruct *dh);

#ifdef __cplusplus
};
#endif

#endif /* _GCM_DISK_HEADER_H_ */