/*====================================================================

filename:     gdsp_interpreter.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once

#define	DSP_IRAM_SIZE	(0x1000)
#define DSP_IRAM_MASK	(0x0fff)
#define	DSP_IROM_SIZE	(0x1000)
#define DSP_IROM_MASK	(0x0fff)
#define	DSP_DRAM_SIZE	(0x1000)
#define DSP_DRAM_MASK	(0x0fff)
#define	DSP_DROM_SIZE	(0x1000)
#define DSP_DROM_MASK	(0x0fff)

#define	DSP_RESET_VECTOR	(0x8000)

#define ENABLE_PARANOID	(1)

#define DSP_STACK_DEPTH	0x20
#define DSP_STACK_MASK	0x1f

typedef struct dsp_t
{
	uint16	r[32];
	uint16	pc;
	uint16	err_pc;
	uint16	*iram;
	uint16	*dram;
	uint16	*irom;
	uint16	*drom;
	uint8	*cpu_ram;
	uint16	cr;
	uint16	loop;
	uint8	reg_stack_ptr[4];
	// lets make stack depth to 32 for now
	uint16	reg_stack[4][DSP_STACK_DEPTH];
	void	(*irq_request)(void);
} dsp_t;

extern dsp_t *dsp;


void gdsp_init(void);
void gdsp_reset(void);
bool gdsp_load_rom(char *fname);
// steps through DSP code, returns false if error occured
bool gdsp_step(void);
bool gdsp_run(void);
bool gdsp_runx(uint16 cnt);
void gdsp_stop(void);

void	gdsp_write_cr(uint16 val);
uint16	gdsp_read_cr(void);

uint16 *gdsp_get_iram(void);
uint16 *gdsp_get_irom(void);
uint16 *gdsp_get_dram(void);
uint16 *gdsp_get_drom(void);
