/*====================================================================

filename:     dol_file.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include <stdlib.h>
#include <stdio.h>

#include "system/types.h"
#include "debug/tracers.h"

uint32 ht_int(uint32 x)
{
	return ((x >> 24) & 0xff) | ((x >> 8) & 0xff00) | ((x << 8) & 0xff0000) | ((x << 24) & 0xff000000);
}


#define DOL_DEBUG_LOAD		1

#define DOL_TEXT_SECTIONS	7
#define	DOL_DATA_SECTIONS	11
typedef struct
{
	uint32	text_fpos[DOL_TEXT_SECTIONS];
	uint32	data_fpos[DOL_DATA_SECTIONS];
	uint32	text_addr[DOL_TEXT_SECTIONS];
	uint32	data_addr[DOL_DATA_SECTIONS];
	uint32	text_size[DOL_TEXT_SECTIONS];
	uint32	data_size[DOL_DATA_SECTIONS];
	uint32	bss_addr;
	uint32	bss_size;
	uint32	entry_point;
} dol_header_t;

int	dol_load_file(char *filename, void *mem, uint32 &entry_point)
{
	FILE *in;
	dol_header_t	header;
	int i;
	if (filename == NULL)
	{
		return 0;
	}

	in = fopen(filename, "rb");
	if(!in)
	{
		return 0;
	}
	fseek(in, 0, SEEK_SET);
	fread(&header, 1, sizeof(header), in);

#if DOL_DEBUG_LOAD
	for (i = 0 ; i < DOL_TEXT_SECTIONS ; i++)
	{

		syslog(LOAD,"[T%x] %08x (%08x) -> %08x\n", i, ht_int(header.text_fpos[i]), ht_int(header.text_size[i]), ht_int(header.text_addr[i]));
		fseek(in, ht_int(header.text_fpos[i]), SEEK_SET);
		fread( ((unsigned char*)mem) + (ht_int(header.text_addr[i]) & 0x0fffffff), 1, ht_int(header.text_size[i]), in); 
	}
	for (i = 0 ; i < DOL_DATA_SECTIONS ; i++)
	{
		syslog(LOAD,"[D%x] %08x (%08x) -> %08x\n", i, ht_int(header.data_fpos[i]), ht_int(header.data_size[i]), ht_int(header.data_addr[i]));
		fseek(in, ht_int(header.data_fpos[i]), SEEK_SET);
		fread( ((unsigned char*)mem) + (ht_int(header.data_addr[i]) & 0x0fffffff), 1, ht_int(header.data_size[i]), in); 
	}
	syslog(LOAD,"[BSS] %08x (%08x)\n", i, header.bss_addr, header.bss_size);
	syslog(LOAD,"[ENTRY] %08x\n", ht_int(header.entry_point)); 
	entry_point = ht_int(header.entry_point);
#endif
	fclose(in);
	return 1;
}
