/*====================================================================

filename:     trx_ppc_rec_fpu_ps_opcodes_sse2.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once

void psc_start(void);
uint32 psc_end(void);
void psc_flushall(void);

// 512 bytes of SSE state save
__declspec(align(16)) typedef struct xmm_state_s
{
	uint64 data[64];
}xmm_state;

__declspec(align(16)) typedef struct pair_o_singles
{
	double low;
	double high;
}paired_single;

typedef struct pair_o_uint64
{
	uint64 low;
	uint64 high;
}paired_uint64;

extern paired_single trx_ps[];
extern xmm_state xmm_save;

int has_sse2(void);

//fpu
void trx_ppc_gen_sse2_fresx(void);
void trx_ppc_gen_sse2_fdivx(void);
void trx_ppc_gen_sse2_faddx(void);
void trx_ppc_gen_sse2_fmsubx(void);
void trx_ppc_gen_sse2_fmaddx(void);
void trx_ppc_gen_sse2_fnmsubx(void);
void trx_ppc_gen_sse2_fnmaddx(void);
void trx_ppc_gen_sse2_fdivsx(void);
void trx_ppc_gen_sse2_fsubsx(void);
void trx_ppc_gen_sse2_faddsx(void);
void trx_ppc_gen_sse2_fmulsx(void);
void trx_ppc_gen_sse2_fmaddsx(void);
void trx_ppc_gen_sse2_fmsubsx(void);
void trx_ppc_gen_sse2_fnmsubsx(void);
void trx_ppc_gen_sse2_fnmaddsx(void);
void trx_ppc_gen_sse2_fselx(void);
void trx_ppc_gen_sse2_fcmpu(void);
void trx_ppc_gen_sse2_fctiwzx(void);
void trx_ppc_gen_sse2_fctiwx(void);
void trx_ppc_gen_sse2_frsqrtex(void);
void trx_ppc_gen_sse2_fcmpo(void);
void trx_ppc_gen_sse2_mtfsb1x(void);
void trx_ppc_gen_sse2_mtfsb0x(void);
void trx_ppc_gen_sse2_mffsx(void);
void trx_ppc_gen_sse2_mcrfs(void);
void trx_ppc_gen_sse2_mtfsfx(void);
void trx_ppc_gen_sse2_fnegx(void);
void trx_ppc_gen_sse2_fmrx(void);
void trx_ppc_gen_sse2_fabsx(void);
void trx_ppc_gen_sse2_fnabsx(void);
void trx_ppc_gen_sse2_fsubx(void);
void trx_ppc_gen_sse2_fmulx(void);
void trx_ppc_gen_sse2_frspx(void);
void trx_ppc_gen_sse2_lfs(void);
void trx_ppc_gen_sse2_lfsu(void);
void trx_ppc_gen_sse2_lfsx(void);
void trx_ppc_gen_sse2_lfsux(void);
void trx_ppc_gen_sse2_lfd(void); 
void trx_ppc_gen_sse2_lfdu(void); 
void trx_ppc_gen_sse2_lfdx(void); 
void trx_ppc_gen_sse2_lfdux(void); 
void trx_ppc_gen_sse2_stfs(void); 
void trx_ppc_gen_sse2_stfsu(void);
void trx_ppc_gen_sse2_stfsx(void);
void trx_ppc_gen_sse2_stfsux(void);
void trx_ppc_gen_sse2_stfd(void);
void trx_ppc_gen_sse2_stfdu(void);
void trx_ppc_gen_sse2_stfdx(void);
void trx_ppc_gen_sse2_stfdux(void);
void trx_ppc_gen_sse2_stfiwx(void);
// decoding
void trx_ppc_gen_sse2_group59(void);
void trx_ppc_gen_sse2_group63(void);
void trx_ppc_gen_sse2_gekko(void);
void trx_ppc_gen_sse2_dcbz_l(void);
// gekko
void trx_ppc_gen_sse2_psq_l(void);
void trx_ppc_gen_sse2_psq_lu(void);
void trx_ppc_gen_sse2_psq_st(void);
void trx_ppc_gen_sse2_psq_stu(void);
void trx_ppc_gen_sse2_psq_lx(void);
void trx_ppc_gen_sse2_psq_lux(void);
void trx_ppc_gen_sse2_psq_stx(void);
void trx_ppc_gen_sse2_psq_stux(void);
void trx_ppc_gen_sse2_ps_cmpu0(void);
void trx_ppc_gen_sse2_ps_cmpo0(void);
void trx_ppc_gen_sse2_ps_cmpu1(void);
void trx_ppc_gen_sse2_ps_cmpo1(void);
void trx_ppc_gen_sse2_ps_neg(void);
void trx_ppc_gen_sse2_ps_mr(void); 
void trx_ppc_gen_sse2_ps_nabs(void);
void trx_ppc_gen_sse2_ps_abs(void); 
void trx_ppc_gen_sse2_ps_sum0(void);
void trx_ppc_gen_sse2_ps_sum1(void);
void trx_ppc_gen_sse2_ps_muls0(void);
void trx_ppc_gen_sse2_ps_muls1(void);
void trx_ppc_gen_sse2_ps_madds0(void);
void trx_ppc_gen_sse2_ps_madds1(void);
void trx_ppc_gen_sse2_ps_merge00(void);
void trx_ppc_gen_sse2_ps_merge01(void);
void trx_ppc_gen_sse2_ps_merge10(void);
void trx_ppc_gen_sse2_ps_merge11(void);
void trx_ppc_gen_sse2_ps_div(void);
void trx_ppc_gen_sse2_ps_sub(void);
void trx_ppc_gen_sse2_ps_add(void);
void trx_ppc_gen_sse2_ps_sel(void);
void trx_ppc_gen_sse2_ps_mul(void);
void trx_ppc_gen_sse2_ps_rsqrte(void);
void trx_ppc_gen_sse2_ps_msub(void);
void trx_ppc_gen_sse2_ps_madd(void);
void trx_ppc_gen_sse2_ps_nmsub(void);
void trx_ppc_gen_sse2_ps_nmadd(void);
