/*====================================================================

filename:     trx_ppc_int.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
extern struct TRX_PPC_Registers trxCPUint;
extern double *trx_int_ps0_double;
extern double *trx_int_ps1_double;
extern uint64 *trx_int_ps0_int;
extern uint64 *trx_int_ps1_int;

extern uint8 (*mem_read8_int)(uint32 address);
extern uint16 (*mem_read16_int)(uint32 address);
extern uint32 (*mem_read32_int)(uint32 address);
extern void (*mem_write8_int)(uint32 address, uint8 val);
extern void (*mem_write16_int)(uint32 address, uint16 val);
extern void (*mem_write32_int)(uint32 address, uint32 val);

void trx_cpu_interpret_single(void);

void trx_int_step(void);
void trx_int_runcpu(void);
void trx_int_run(void);