/*====================================================================

filename:     asm_x86.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
/*
 * x86 instruction assembler.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "system/types.h"
#include "trx_ppc_rec.h"
#include "asm_x86.h"

#define putb(x) *(translation_memory+translation_pos) = (x); translation_pos++;
#define putw(x) *((uint16 *)(translation_memory+translation_pos)) = (uint16)(x); translation_pos+=2;
#define putd(x) *((uint32 *)(translation_memory+translation_pos)) = (uint32)(x); translation_pos+=4;

uint32 gen_asm_total = 0;

void gen_asm(uint32 opcode, uint32 arg1, uint32 arg2, uint32 arg3)
{
	gen_asm_total++;

	switch(opcode)
	{	
	case SETC_R8: // setc xl
		putb(0x0f); putb(0x92); putb(0xc0+ arg1);break;
	case OR_R8R8: // or xl,xl
		putb(0x0a); putb(0xc0+ arg1*8 + arg2);break;
	case MOV_MR8: // mov byte ptr [mem], xl
		putb(0x88); putb(5+arg2*8); putd(arg1);break;		
	case MOV_RR: // mov exx, exx
		putb(0x8b); putb(0xc0+ arg1*8 + arg2); break;
	case MOV_RM: // mov exx, dword ptr [mem]
		if(arg2 == EAX){
		putb(0xa3);putd(arg2);break;
		}else{
		putb(0x8b); putb(5+arg1*8); putd(arg2);break;
		}
	case MOV_MR: // mov dword ptr [mem], exx
		if(arg2 == EAX){
		putb(0xa3);putd(arg1);break;
		}else{
		putb(0x89); putb(5+arg2*8); putd(arg1);break;
		}
	case MOV_RI32: // mov exx, 0x12345678
		putb(0xb8+arg1); putd(arg2); break;
	case MOV_RMRI32: // mov exx, [0x12345678 + exx]
		putb(0x8b); putb(0x80+(arg1*8)+arg2); putd(arg3); break;
	case MOV_MRRI32: // mov [0x12345678 + exx], exx
		putb(0x89); putb(0x80+(arg1*8)+arg2); putd(arg3); break;
	case MOV_R8MRI32: // mov xl, byte ptr [0x12345678 + exx]
		putb(0x8a); putb(0x80+(arg1*8)+arg2); putd(arg3); break;
	case MOV_M8RRI32: // mov byte ptr [0x12345678 + exx], xl
		putb(0x88); putb(0x80+(arg1*8)+arg2); putd(arg3); break;
	case MOV_R16MRI32: // mov xx, word ptr [0x12345678 + exx]
		putb(0x66); putb(0x8b); putb(0x80+(arg1*8)+arg2); putd(arg3); break;
	case MOV_M16RRI32: // mov word ptr [0x12345678 + exx], xx
		putb(0x66); putb(0x89); putb(0x80+(arg1*8)+arg2); putd(arg3); break;
	case MOV_M32I32: // mov dword ptr [mem], val32
		putb(0xc7); putb(0x5); putd(arg1); putd(arg2);break;
	case CMP_M32I8: // 0040AB72 83 3D D0 5E 46 00 00 cmp dword ptr [ddebug (465ED0h)],0 
		putb(0x83); putb(0x3d); putd(arg1); putb(arg2);break;
	case SUB_M32I8: // 0040AB75 83 2D D0 5E 46 00 08 sub         dword ptr [memlocation (465ED0h)],8 
		putb(0x83); putb(0x2d); putd(arg1); putb(arg2);break;
	case SUB_M32I32: // 0040AB7C 81 2D D0 5E 46 00 00 04 00 00 sub         dword ptr [memlocation (465ED0h)],400h 
		putb(0x81); putb(0x2d); putd(arg1); putd(arg2);break;
	case MOVSX3216_RR: // movsx exx, ex
		putb(0x0f); putb(0xbf); putb(0xc0+ arg1*8 + arg2); break;
	case MOVSX328_RR: // movsx exx, el
		putb(0x0f); putb(0xbe); putb(0xc0+ arg1*8 + arg2); break;
	case TEST_RR: // test exx, exx
		putb(0x85); putb(0xc0+ arg1*8 + arg2); break;
	case BSR_RR: // bsr exx, exx
		putb(0x0f); putb(0xbd); putb(0xc0+ arg1*8 + arg2); break;
	case XOR_RR: // xor exx, exx
		putb(0x33); putb(0xc0+ arg1*8 + arg2); break;
	case XOR_RI32: // xor exx, 0x12345678
		putb(0x81); putb(0xf0+arg1); putd(arg2);break;
	case XOR_RM: // xor exx, dword ptr [mem]
		putb(0x33); putb(5+arg1*8); putd(arg2);break;
	case SUB_RR: // sub exx, exx
		putb(0x2b); putb(0xc0+ arg1*8 + arg2); break;
	case SUB_RI32: // sub exx, 0x12345678
		putb(0x81); putb(0xe8+arg1); putd(arg2);break;
	case SUB_RM: // sub exx, dword ptr [mem]
		putb(0x2b); putb(5+arg1*8); putd(arg2);break;
	case OR_RR: // or exx, exx
		putb(0x0b); putb(0xc0+ arg1*8 + arg2); break;
	case OR_RI32: // or exx, 0x12345678
		putb(0x81); putb(0xc8+arg1); putd(arg2);break;
	case OR_RM: // or exx, dword ptr [mem]
		putb(0x0b); putb(5+arg1*8); putd(arg2);break;
	case ADD_RI32: // add exx, 0x12345678
		putb(0x81); putb(0xc0+arg1); putd(arg2);break;
	case ADD_RI8: // add exx, 0x12
		putb(0x83); putb(0xc0+arg1); putb(arg2);break;
	case ADD_RM: // add exx, dword ptr [mem]
		putb(0x03); putb(5+arg1*8); putd(arg2);break;
	case ADD_MRI32I8: // 0040AB72 83 81 78 56 34 12 01 add         dword ptr [ecx+12345678h],1 
		putb(0x83); putb(0x80+arg1); putd(arg2); putb(arg3);break;
	case ADD_RR: // add exx, exx
		putb(0x03); putb(0xc0+ arg1*8 + arg2); break;
	case AND_RI32: // and exx, 0x12345678
		putb(0x81); putb(0xe0+arg1); putd(arg2);break;
	case AND_RM: // and exx, dword ptr [mem]
		putb(0x23); putb(5+arg1*8); putd(arg2);break;
	case AND_RR: // and exx, exx
		putb(0x23); putb(0xc0+ arg1*8 + arg2); break;
	case CMP_RI32: // cmp exx, 0x12345678
		putb(0x81); putb(0xf8+arg1); putd(arg2);break;
	case CMP_RM: // cmp exx, dword ptr [mem]
		putb(0x3B); putb(5+arg1*8); putd(arg2);break;
	case CMP_RR: // cmp exx, exx
		putb(0x3b); putb(0xc0+ arg1*8 + arg2); break;
	case ADC_RM: // adc exx, dword ptr [mem]
		putb(0x13); putb(5+arg1*8); putd(arg2);break;
	case ROL_RI8: // rol exx,immediate
		putb(0xc1); putb(0xc0+arg1); putb(arg2); break;
	case ROL_CL: // rol exx,cl
		putb(0xd3); putb(0xc0+arg1);break;
	case SHL_RI8: // shl exx,immediate
		putb(0xc1); putb(0xe0+arg1); putb(arg2); break;
	case SHL_CL: // shl exx,cl
		putb(0xd3); putb(0xe0+arg1);break;
	case SHR_RI8: // shr exx,immediate
		putb(0xc1); putb(0xe8+arg1); putb(arg2); break;
	case SHR_CL: // shr exx,cl
		putb(0xd3); putb(0xe8+arg1);break;
	case SAR_RI8: // sar exx,immediate
		putb(0xc1); putb(0xf8+arg1); putb(arg2); break;
	case SAR_CL: // sar exx,cl
		putb(0xd3); putb(0xf8+arg1);break;
	case CMOVG_M: // cmovg exx, mem
		putb(0x0f); putb(0x4f); putb(5+arg1*8); putd(arg2);break;
	case CMOVL_M: // cmovl exx, mem
		putb(0x0f); putb(0x4c); putb(5+arg1*8); putd(arg2);break;
	case CMOVA_M: // cmova exx, mem
		putb(0x0f); putb(0x47); putb(5+arg1*8); putd(arg2);break;
	case CMOVB_M: // cmovb exx, mem
		putb(0x0f); putb(0x42); putb(5+arg1*8); putd(arg2);break;
	case CMOVE_M: // cmove exx, mem
		putb(0x0f); putb(0x44); putb(5+arg1*8); putd(arg2);break;
	case CMOVNE_M: // cmovne exx, mem
		putb(0x0f); putb(0x45); putb(5+arg1*8); putd(arg2);break;
	case CMOVP_M: // cmovp exx, mem
		putb(0x0f); putb(0x4a); putb(5+arg1*8); putd(arg2);break;
	case CMOVE_R: // cmove exx, exx
		putb(0x0f); putb(0x44);  putb(0xc0+ arg1*8 + arg2); break;
	case CMOVNE_R: // cmovne exx, exx
		putb(0x0f); putb(0x45);  putb(0xc0+ arg1*8 + arg2); break;
	case SETC_M: // setc mem
		putb(0x0f); putb(0x92); putb(05); putd(arg1);break;
	case SETNE_M: // setne mem
		putb(0x0f); putb(0x95); putb(05); putd(arg1);break;
	case INC_R: // inc exx
		putb(0x40+arg1);break;
	case NOT_R: // not exx
		putb(0xf7); putb(0xd0+arg1);break;
	case NEG_R: // neg exx
		putb(0xf7); putb(0xd8+arg1);break;
	case POP_R: // pop exx
		putb(0x58+arg1);break;
	case PUSH_R: // push exx
		putb(0x50+arg1);break;
	case PUSH_I32: // push 0x12345678
		putb(0x68); putd(arg1);break;
	case JNE_I8: // jne <offset 8>
		putb(0x75); putb(arg1);break;
	case JNE_I32: // jne <offset 32>
		putb(0x0f); putb(0x85); putd(arg1);break;
	case JE_I8: // je <offset 8>
		putb(0x74); putb(arg1);break;
	case JAE_I8: // jae <offset 8>
		putb(0x73); putb(arg1);break;
	case JS_I8: // js <offset 8>
		putb(0x78); putb(arg1);break;
	case JS_I32: // js <offset 32>
		putb(0x0f); putb(0x88); putd(arg1); break;
	case JMP_I8: // jmp <offset 8>
		putb(0xeb); putb(arg1);break;
	case MUL_R: // mul exx
		putb(0xf7); putb(0xe0+arg1);break;
	case DIV_R: // div exx
		putb(0xf7); putb(0xf0+arg1);break;
	case IDIV_R: // idiv exx
		putb(0xf7); putb(0xf8+arg1);break;
	case IMUL_R: // imul exx
		putb(0xf7); putb(0xe8+arg1);break;
	case BSWAP_R: // bswap exx
		putb(0x0f); putb(0xc8+arg1);break;
	case CALL_M: // call dword ptr [mem]
		{
			uint32 offset = arg1 - (uint32)(&translation_memory[translation_pos+5]); 
			putb(0xe8); putd(offset);break;
		}
	case JMP_M: // 0040AB86 E9 45 B3 05 00   jmp         memlocation (465ED0h) 
		{
			uint32 offset = arg1 - (uint32)(&translation_memory[translation_pos+5]); 
			putb(0xe9); putd(offset);break;
		}
	case CALL_R: // call exx
		putb(0xff); putb(0xd0+arg1); break;
	case JMP_R: // 0040AB75 FF E0            jmp         eax  
		putb(0xff); putb(0xe0+arg1); break;
	case RET: // ret
		putb(0xc3);break;
	case BREAK:	// int 3h
		putb(0xcc);break;
	case FLD32_M: // fld dword ptr mem
		putb(0xd9); putb(0x05); putd(arg1);break;
	case FLD64_M: // fld qword ptr mem
		putb(0xdd); putb(0x05); putd(arg1);break;
	case FSTP32_M: // fstp dword ptr mem
		putb(0xd9); putb(0x1D); putd(arg1);break;
	case FSTP64_M: // fstp qword ptr mem
		putb(0xdd); putb(0x1D); putd(arg1);break;
	case FISTP64_M: // fistp qword ptr mem
		putb(0xdf); putb(0x3D); putd(arg1);break;
	case FISTP32_M: // 0040AB72 DB 1D F0 7E 46 00 fistp       dword ptr [ddebug (467EF0h)] 
		putb(0xdb); putb(0x1d); putd(arg1);break;
	case FST32_M: // fst dword ptr mem
		putb(0xd9); putb(0x15); putd(arg1);break;
	case FST64_M: // fst qword ptr mem
		putb(0xdd); putb(0x15); putd(arg1);break;
	case FLD1: // fld1 (load 1.0f onto float stack)
		putb(0xd9); putb(0xe8); break;
	case FLDZ: // fldz (load 0.0f onto float stack)
		putb(0xd9); putb(0xee); break;
	case FCHS: // fchs (change sign)
		putb(0xd9); putb(0xe0); break;
	case FUCOMIP: // fucomip ST, ST(argv1) (compare unordered and set alu flags)
		putb(0xdf); putb(0xe8+arg1); break;
	case FSUB64_M: // fsub qword ptr mem
		putb(0xdc); putb(0x25); putd(arg1);break;
	case FADD64_M: // fadd qword ptr mem
		putb(0xdc); putb(0x05); putd(arg1);break;
	case FMUL64_M: // fmul qword ptr mem
		putb(0xdc); putb(0x0d); putd(arg1);break;
	case FDIV64_M: // fdiv qword ptr mem
		putb(0xdc); putb(0x35); putd(arg1);break;
	case FSQRT:	// fsqrt
		putb(0xd9); putb(0xfa); break;
	case FDIV: // fdiv
		putb(0xDE); putb(0xF9); break;
	case FCMOVB_M: // fcmovb st(0), st(i)
		putb(0xda); putb(0xc0+arg1); break;
	case FCMOVU_M: // fcmovu st(0), st(i)
		putb(0xda); putb(0xd8+arg1); break;
	case FCMOVNB_M: // fcmovnb st(0), st(i)
		putb(0xdb); putb(0xc0+arg1); break;
	case FPOP: // fstp st(0), st(0)
		putb(0xdd); putb(0xd8); break;
	case FNSTCW_M: // fnstcw <word ptr>
		putb(0xd9); putb(0xd3); putd(arg1); break;
	case FLDCW_M: // fldcw <word ptr>
		putb(0xd9); putb(0x2d); putd(arg1); break;
	case CDQ: // cdq (sign extend to 64bit for idiv's
		putb(0x99); break;
	case MOV_R8I8: // B0 12            mov         al,12h
		putb(0xb0+arg1); putb(arg2); break;
	case SUB_R8R8: // 0040AA7C 2A C1            sub         al,cl 
		putb(0x2a); putb(0xc0+ arg1*8 + arg2); break;
	case MOV_R8R8: // 0040AA86 8A C0            mov         al,al 
		putb(0x8a); putb(0xc0+ arg1*8 + arg2); break;
	case SETNE_R8: // 0040AA92 0F 95 C0         setne       al   
		putb(0x0f); putb(0x95); putb(0xc0 + arg1); break;
	case TEST_R8R8: // 0040AA9B 84 C0            test        al,al 
		putb(0x84); putb(0xc0+ arg1*8 + arg2); break;
	case XCHG_R8R8: // 0040AA9B 86 C0            xchg        al,al 
		putb(0x86); putb(0xc0+ arg1*8 + arg2); break;
	case MOVAPD_RM: // 0040D2C2 66 0F 28 05 08 4C 48 00 movapd      xmm0,xmmword ptr [trx_ps (484C08h)] 
		putb(0x66); putb(0x0f); putb(0x28); putb(0x5+(arg1*8)); putd(arg2);break;
	case MOVAPD_RMRI32: // 0040AB72 66 0F 28 82 78 56 34 12 movapd      xmm0,xmmword ptr [edx+12345678h] 
		putb(0x66); putb(0x0f); putb(0x28); putb(0x80+(arg1*8)+arg2);putd(arg3);break;
	case MOVAPD_MR: // 0040D2C2 66 0F 29 05 08 4C 48 00 movapd      xmmword ptr [trx_ps (484C08h)], xmm0 
		putb(0x66); putb(0x0f); putb(0x29); putb(0x5+(arg2*8)); putd(arg1);break;
	case MOVAPD_RR: // 0040D2E2 66 0F 28 C1      movapd      xmm0,xmm1 
		putb(0x66); putb(0x0f); putb(0x28); putb(0xc0+(arg1*8)+arg2);break;		
	case MOVLPD_RM: // 0040D2D2 66 0F 12 05 D8 58 46 00 movlpd      xmm0,qword ptr [ddebug (4658D8h)] 
		putb(0x66); putb(0x0f); putb(0x12); putb(0x5+(arg1*8)); putd(arg2);break;
	case MOVLPD_MR: // 0040D2EA 66 0F 13 05 D8 58 46 00 movlpd      qword ptr [ddebug (4658D8h)],xmm0 
		putb(0x66); putb(0x0f); putb(0x13); putb(0x5+(arg2*8)); putd(arg1);break;
	case MOVHPD_RM: // 0040D2D2 66 0F 16 05 D8 58 46 00 movhpd      xmm0,qword ptr [ddebug (4658D8h)] 
		putb(0x66); putb(0x0f); putb(0x16); putb(0x5+(arg1*8)); putd(arg2);break;
	case MOVHPD_MR: // 0040D302 66 0F 17 0D D8 58 46 00 movhpd      qword ptr [ddebug (4658D8h)],xmm1 
		putb(0x66); putb(0x0f); putb(0x17); putb(0x5+(arg2*8)); putd(arg1);break;
	case DIVSD_RR: // 0040AD42 F2 0F 5E C1      divsd       xmm0,xmm1 
		putb(0xf2); putb(0x0f); putb(0x5e); putb(0xc0+ arg1*8 + arg2); break;
	case SHUFPD_RR: //0040AD46 66 0F C6 C1 00   shufpd      xmm0,xmm1,0 
		putb(0x66); putb(0x0f); putb(0xc6); putb(0xc0+ arg1*8 + arg2); putb(arg3); break;
	case SUBSD_RR: // 0040AD5A F2 0F 5C C1      subsd       xmm0,xmm1 
		putb(0xf2); putb(0x0f); putb(0x5c); putb(0xc0+ arg1*8 + arg2); break;
	case MOVSD_RR: // 0040AD5E F2 0F 10 C1      movsd       xmm0,xmm1 
		putb(0xf2); putb(0x0f); putb(0x10); putb(0xc0+ arg1*8 + arg2); break;
	case MULSD_RR: // 0040AD62 F2 0F 59 C1      mulsd       xmm0,xmm1 
		putb(0xf2); putb(0x0f); putb(0x59); putb(0xc0+ arg1*8 + arg2); break;
	case XORPD_RM: //0040AD42 66 0F 57 05 70 B0 46 00 xorpd       xmm0,xmmword ptr [ddebug (46B070h)]   
		putb(0x66); putb(0x0f); putb(0x57); putb(0x5+(arg1*8)); putd(arg2);break;
	case CVTSD2SS_RR: // 0040AD6A F2 0F 5A C1      cvtsd2ss    xmm0,xmm1 
		putb(0xf2); putb(0x0f); putb(0x5a); putb(0xc0+ arg1*8 + arg2); break;
	case CVTSS2SD_RR: // 0040AB72 F3 0F 5A C0      cvtss2sd    xmm0,xmm0 
		putb(0xf3); putb(0x0f); putb(0x5a); putb(0xc0+ arg1*8 + arg2); break;
	case ANDPD_RM: // 0040AD72 66 0F 54 05 70 B0 46 00 andpd       xmm0,xmmword ptr [ddebug (46B070h)] 
		putb(0x66); putb(0x0f); putb(0x54); putb(0x5+(arg1*8)); putd(arg2);break;
	case ORPD_RM: // 0040AD4A 66 0F 56 05 70 B0 46 00 orpd        xmm0,xmmword ptr [ddebug (46B070h)] 
		putb(0x66); putb(0x0f); putb(0x56); putb(0x5+(arg1*8)); putd(arg2);break;
	case ADDSD_RR: // 0040AD7A F2 0F 58 C1      addsd       xmm0,xmm1 
		putb(0xf2); putb(0x0f); putb(0x58); putb(0xc0+ arg1*8 + arg2); break;
	case SQRTSD_RR: // 0040AD7E F2 0F 51 C1      sqrtsd      xmm0,xmm1 
		putb(0xf2); putb(0x0f); putb(0x51); putb(0xc0+ arg1*8 + arg2); break;
	case UCOMISD_RR: // 0040AD82 66 0F 2E C1      ucomisd     xmm0,xmm1 
		putb(0x66); putb(0x0f); putb(0x2e); putb(0xc0+ arg1*8 + arg2); break;
	case CVTTSD2SI_RR: // 0040AD86 F2 0F 2C C1      cvttsd2si   eax,xmm1 
		putb(0xf2); putb(0x0f); putb(0x2c); putb(0xc0+ arg1*8 + arg2); break;
	case CVTSD2SI_RR: // 0040AD8A F2 0F 2D C1      cvtsd2si    eax,xmm1 
		putb(0xf2); putb(0x0f); putb(0x2d); putb(0xc0+ arg1*8 + arg2); break;
	case MULPD_RR: // 0040AD8E 66 0F 59 C1      mulpd       xmm0,xmm1 
		putb(0x66); putb(0x0f); putb(0x59); putb(0xc0+ arg1*8 + arg2); break;
	case SUBPD_RR: // 0040AD92 66 0F 5C C1      subpd       xmm0,xmm1 
		putb(0x66); putb(0x0f); putb(0x5c); putb(0xc0+ arg1*8 + arg2); break;
	case ADDPD_RR: // 0040AD96 66 0F 58 C1      addpd       xmm0,xmm1 
		putb(0x66); putb(0x0f); putb(0x58); putb(0xc0+ arg1*8 + arg2); break;
	case DIVPD_RR: // 0040AD9A 66 0F 5E C1      divpd       xmm0,xmm1 
		putb(0x66); putb(0x0f); putb(0x5e); putb(0xc0+ arg1*8 + arg2); break;
	case SQRTPD_RR: // 0040AD9E 66 0F 51 C1      sqrtpd      xmm0,xmm1 
		putb(0x66); putb(0x0f); putb(0x51); putb(0xc0+ arg1*8 + arg2); break;		
	default: // illegal or unknown, put breakpoint
		putb(0xcc);break;
	}
}
