/*====================================================================

filename:     config.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "hardware/memory_interface.h"

// list of configuration items
int	config_cpumode = CPU_RECOMPILER;
//int	config_cpumode = CPU_INTERPRETER;

int	config_disable_sse2 = 1;
int config_stackinram = 1;
int	config_skipidle = 0;
int config_region = 0; 
// Lets assume average 1 instruction per clock cycle real world performance
// (keep in mind that L1 and L2 are relatively slow and main memory is even worse)
// 485 Mhz, 50 fps, 256 lines per field = 37890 instructions per line
int	config_instructions_per_line = 15000;
int config_debugasm = 0;
int	config_constantaddress = 0;

// hotkey logging button
int config_hotkeylogging = 0;
int config_debug = 0;

char config_gpuplugin[255] = "plugins/gxGCEmuOGL.dll";

int sw_cfgfile(char *cfgname);
int sw_gpuconfig(char *gpuplugname);

variable_def_t variables[] =
{
    { VART_FUNC,    "-help",				'h',	NULL,							
		0,  config_help, "shows this help information"},
    { VART_FUNCP,   "-use-config-file",		'c',	NULL,							
		0,  sw_cfgfile, "full path to configuration file with additional options"},
	{ VART_INT,     "-cpu-mode",			'm',	&config_cpumode,				
		CPU_RECOMPILER,  NULL, "0=RECOMPILER, 1=INTERPRETER, 2=SELFCHECK MODE"},
	{ VART_INT,     "-disable-sse2",		0,		&config_disable_sse2,			
		0,  NULL, "0=SSE2 enabled, 1=SSE2 disabled"},
	{ VART_INT,     "-disable-skipidle",	0,		&config_skipidle,				
		0,  NULL, "0=skip idle loops, 1=run idle loops"},
	{ VART_INT,     "-line-instr",			0,		&config_instructions_per_line,	
		10000,  NULL, "instructions per horizontal line (485Mhz is 37890 cycles/line"},
	{ VART_INT,     "-debugasm",			0,		&config_debugasm,				
		0,  NULL, "0=no assembly dump, 1=assembly dump of recompiler output"},
	{ VART_INT,     "-stackinram",			0,		&config_stackinram,				
		0,  NULL, "0=normal memory access, 1=stack always goes to main RAM"},
	{ VART_INT,     "-constantaddress",		0,		&config_constantaddress,		
		0,  NULL, "0=always use memory access routines 1=direct load on constant addresses"},
	{ VART_INT,     "-region",				'r',	&config_region,					
		0,  NULL, "0 = USA, NTSC ; 1 = EUROPE, PAL ; 2 = JAPAN, NTSC"},
	{ VART_bool,	"-log",					'l',	&config_hotkeylogging,			
		0,  NULL, ""},
	{ VART_bool,	"-debug",				'd',	&config_debug,					
		0,  NULL, ""},
	{ VART_FUNCP,		"-gpu",				0,		NULL,					
		0,  sw_gpuconfig, "name of gpu plugin (gxDefault by default)"}
};
/////////////////////////////////////////////////////////
int config_help(char *a)
{
    int i;
    char tmpstr[256];
        for ( i = 0 ; i < (int)(sizeof(variables)/sizeof(variable_def_t)) ; i++ )
        {
            switch(variables[i].type)
            {
            case VART_bool:
                sprintf(tmpstr,"-%s=<yes|no>", variables[i].name);
                printf("%-31s def: %-3s %s",tmpstr, variables[i].value?"yes":"no",variables[i].description);
                break;
            case VART_INT:
                sprintf(tmpstr,"-%s=<value>", variables[i].name);
                printf("%-31s def: %3d %s",tmpstr, variables[i].value,variables[i].description);
                break;
            case VART_FUNC:
                printf("-%s", variables[i].name);
                break;
            case VART_FUNCP:
                printf("-%s=<value>", variables[i].name);
                break;
            }
        printf("\n");
        }
    return 0;
}

/////////////////////////////////////////////////////////

unsigned char config_variable(char *varname)
{
    unsigned int i;
    int var_len, var_len2;
    int value;
	bool	found;
    for ( i = 0 ; i < (sizeof(variables)/sizeof(variable_def_t)) ; i++ )
    {
		found = false;
        var_len = strlen(variables[i].name);
		
        if (strncmp(variables[i].name, varname, var_len) == 0)
			found = true;
		if (varname[0] == variables[i].short_name)
			found = true;

		if (found)
        {
            switch(variables[i].type)
            {
            case VART_bool:
                if ((var_len == (int)strlen(varname)) || ((int)strlen(varname) == 1))
                    *(variables[i].var) = 1;
                else
                {
                    var_len2 = strlen(varname) - var_len;
                    if (var_len2 <= 1) return false;
                    if (varname[var_len] != '=') return false;
                    if (strcmp("yes",varname+var_len+1) == 0)
                        *(variables[i].var) = 1;
                    else
                    if (strcmp("no",varname+var_len+1) == 0)
                        *(variables[i].var) = 0;
                    else return false;
                    return true;
                }
                return true;
            case VART_INT:
                if (var_len == (int)strlen(varname) )
				{
                    return false;
				}
                else
                {
                    var_len2 = strlen(varname) - var_len;
                    if (var_len2 <= 1) return false;
                    if (varname[var_len] != '=') return false;
                    value = strtoul(varname+var_len+1,NULL,10);
                    *(variables[i].var) = value;
                    return true;
                }
				break;
            case VART_FUNC:
                    if ( variables[i].function(NULL) == 0) exit(1);
                    return true;
            case VART_FUNCP:
				if ((var_len == (int)strlen(varname)) || ((int)strlen(varname) == 1))
				{
                    return false;
				}
                else
                {
                    if (varname[0] != '-')
						var_len2 = strlen(varname) - var_len;
					else
						var_len2 = strlen(varname) - 1;
                    if (var_len2 <= 1) return false;
                    if (varname[var_len] != '=') return false;
                    if ( variables[i].function(varname+var_len+1) == 0) exit(1);
                    return true;
                }
                return true;
            }
        }
    }
    return false;
}

/////////////////////////////////////////////////////////

int sw_cfgfile(char *cfgname)
{
	FILE *cfgfile = fopen(cfgname,"r");
	char tmpstr[256];
	if ( cfgfile )
	{
	while (!feof(cfgfile))
	{
		fscanf(cfgfile,"%s\n",tmpstr);
		if (tmpstr[0] == '-')
			if ( config_variable(tmpstr+1) == false )
			{
				printf("unknown option: %s\n", tmpstr);
				exit(1);
			}
		}
		fclose(cfgfile);
	}
	else
	{
		printf("configuration file [%s] not found\n", cfgname);
		exit(1);
	}
	return 1;
}

int sw_gpuconfig(char *gpuplugname)
{
	sprintf(config_gpuplugin, "plugins/%s.dll", gpuplugname);
	return 1;
}