#include "plugins.h"
#include "resource.h"
#include "windows.h"

#define MASK555 0x3DEF
#define MASK565 0x7BEF

#define MASK5552	0x1CE7
#define MASK5652	0x39E7

#define GMASK555	0x3E0
#define GMASK565	0x7E0
#define GBITS555    (5-3)
#define GBITS565    (5-2)

#define RMASK555	0x7C00
#define RMASK565	0xF800
#define RBITS555    (10-3)
#define RBITS565    (11-3)

#define BMASK		0x1F


unsigned short MASK,MASK2,GMASK,RMASK,RBITS,GBITS;

enum {SCAN0=0,SCAN25,SCAN50,SCAN75,NOSCAN,SCAN} ScanType;
unsigned int Percent=0;

unsigned short LookUp[0x10000];

void ReadConfig()
{
	char dir[512];

	GetCurrentDirectory(512,dir);
	strcat(dir,"\\PLUGINS\\Plugins.cfg");

	ScanType=GetPrivateProfileInt("CustomScan","ScanType",0,dir);
	Percent=GetPrivateProfileInt("CustomScan","Percent",0,dir);
}

void WriteConfig()
{
	char dir[512];
	char aux[12];

	GetCurrentDirectory(512,dir);
	strcat(dir,"\\PLUGINS\\Plugins.cfg");

	itoa(ScanType,aux,10);
	WritePrivateProfileString("CustomScan","ScanType",aux,dir);
	itoa(Percent,aux,10);
	WritePrivateProfileString("CustomScan","Percent",aux,dir);
}

void BuildLUT()
{
	unsigned int i;
	for(i=0;i<=0xffff;++i)
	{
		unsigned int r,g,b;
		
        r=(i&RMASK)>>(RBITS);
        g=(i&GMASK)>>(GBITS);
		b=(i&BMASK)<<3;
		r=MulDiv(r,Percent,100);
		g=MulDiv(g,Percent,100);
		b=MulDiv(b,Percent,100);
		if(r>0xff)	r=0xff;
		if(g>0xff)	g=0xff;
		if(b>0xff)	b=0xff;
        LookUp[i]=((r<<(RBITS))&RMASK)|((g<<(GBITS))&GMASK)|((b>>3)&BMASK);
	}

}

void Init(HWND Parent, char Is555,char Is32bit,char Rotated)
{
	ReadConfig();

	if(Is555)
	{
        MASK=MASK555;
		MASK2=MASK5552;
		GMASK=GMASK555;
		RMASK=RMASK555;
		RBITS=RBITS555;
        GBITS=RBITS555;
	}
    else
	{
        MASK=MASK565;
		MASK2=MASK5652;
		GMASK=GMASK565;
		RMASK=RMASK565;
		RBITS=RBITS565;
        GBITS=RBITS555;
	}
	
	BuildLUT();
}

unsigned int SetWidth(unsigned short width)
{
    return 2*width;
}

unsigned int SetHeight(unsigned short height)
{
    return 2*height;
}

void BlitScan(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
    int j;
    unsigned short *lines=src;
    unsigned short *lined=dst;
    for(j=0;j<height;++j)
    {
        unsigned short *pixels=lines;
        unsigned short *pixeld=lined;

        register int i;
        for(i=0;i<width;++i)
        {
	        register unsigned short pixel=*pixels;
            pixeld[0]=pixel;
            pixeld[1]=pixel;
            pixeld+=2;
            ++pixels;
        }
        lines+=srcpitch;
        lined+=2*dstpitch/2;
    }
}


void Blit25(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
    int j;
    unsigned short *lines=src;
    unsigned short *lined=dst;
    for(j=0;j<height*2;++j)
    {
        unsigned short *pixels=lines;
        unsigned short *pixeld=lined;

        //Draw the lines in 2 passes, it's faster than drawing
        //both lines (normal,25%) in 1 pass as this way you
        //avoid the video mem address select latency
        if(j&1)
        {
            register int i;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=*pixels;
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }
        }
        else
        {
            register int i;
            register unsigned short M=MASK2;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=((*pixels)>>2)&M;
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }
            lines+=srcpitch;
        }
        lined+=dstpitch/2;
    }
}


void Blit50(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
    int j;
    unsigned short *lines=src;
    unsigned short *lined=dst;
    for(j=0;j<height*2;++j)
    {
        unsigned short *pixels=lines;
        unsigned short *pixeld=lined;

        //Draw the lines in 2 passes, it's faster than drawing
        //both lines (normal,50%) in 1 pass as this way you
        //avoid the video mem address select latency
        if(!(j&1))
        {
            register int i;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=*pixels;
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }
        }
        else
        {
            register int i;
            register unsigned short M=MASK;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=((*pixels)>>1)&M;
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }
            lines+=srcpitch;
        }
        lined+=dstpitch/2;
    }
}

void Blit75(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
    int j;
    unsigned short *lines=src;
    unsigned short *lined=dst;
    for(j=0;j<height*2;++j)
    {
        unsigned short *pixels=lines;
        unsigned short *pixeld=lined;

        //Draw the lines in 2 passes, it's faster than drawing
        //both lines (normal,50%) in 1 pass as this way you
        //avoid the video mem address select latency
        if(!(j&1))
        {
            register int i;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=*pixels;
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }
        }
        else
        {
            register int i;
            register unsigned short M=MASK;
			register unsigned short M2=MASK2;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=(((*pixels)>>1)&M)+(((*pixels)>>2)&M2);
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }
            lines+=srcpitch;
        }
        lined+=dstpitch/2;
    }
}


void Blit100(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
    int j;
    unsigned short *lines=src;
    unsigned short *lined=dst;
    for(j=0;j<height*2;++j)
    {
        unsigned short *pixels=lines;
        unsigned short *pixeld=lined;

        register int i;
        for(i=0;i<width;++i)
        {
	        register unsigned short pixel=*pixels;
            pixeld[0]=pixel;
            pixeld[1]=pixel;
            pixeld+=2;
            ++pixels;
        }
    
        if(j&1)
			lines+=srcpitch;
        lined+=dstpitch/2;
    }
}


void BlitCustomLUT(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
    int j;
    unsigned short *lines=src;
    unsigned short *lined=dst;
    for(j=0;j<height*2;++j)
    {
        unsigned short *pixels=lines;
        unsigned short *pixeld=lined;

        if(!(j&1))
        {
            register int i;
            for(i=0;i<width;++i)
            {
                register unsigned short pixel=*pixels;
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }

        }
        else
        {
            register int i;
            for(i=0;i<width;++i)
            {
				//Unoptimized=>Slow:
				register unsigned short pixel=LookUp[*pixels];
                pixeld[0]=pixel;
                pixeld[1]=pixel;
                pixeld+=2;
                ++pixels;
            }
            lines+=srcpitch;
        }
        lined+=dstpitch/2;
    }
}


void (*BlitTable[])(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)=
{
	BlitScan,
	Blit25,
	Blit50,
	Blit75,
	Blit100,
	BlitCustomLUT,
};

void Blit(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
    BlitTable[ScanType](width,height,src,srcpitch,dst,dstpitch,palette32);
}

BOOL CALLBACK ConfigProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
    switch(uMsg)
    {
        case WM_CLOSE:
            EndDialog(hwndDlg,0);
        case WM_INITDIALOG:
			{
				unsigned int RadioButtons[]={IDC_0,IDC_25,IDC_50,IDC_75,IDC_100,IDC_CUSTOM};
				char aux[12];
				ReadConfig();

				SendDlgItemMessage(hwndDlg,RadioButtons[ScanType],BM_SETCHECK,BST_CHECKED,0);
				itoa(Percent,aux,10);
				SetDlgItemText(hwndDlg,IDC_PERCENT,aux);
			}
            return TRUE;
		case WM_DESTROY:
			{
				char aux[12];
				GetDlgItemText(hwndDlg,IDC_PERCENT,aux,12);
				Percent=atoi(aux);
				WriteConfig();
				BuildLUT();
			}
			break;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDOK:
                    EndDialog(hwndDlg,0);
                    break;
				case IDC_0:
					ScanType=SCAN0;
					break;
				case IDC_25:
					ScanType=SCAN25;
					break;
				case IDC_50:
					ScanType=SCAN50;
					break;
				case IDC_75:
					ScanType=SCAN75;
					break;
				case IDC_100:
					ScanType=NOSCAN;
					break;
				case IDC_CUSTOM:
					ScanType=SCAN;
					break;
            }
            break;
    }
    return FALSE;
}

void Configure(HINSTANCE Handler,HWND Parent)
{
    DialogBoxParam(Handler,MAKEINTRESOURCE(IDD_CONFIG),Parent,ConfigProc,0);
}

void Terminate()
{

}

struct _PluginInfo PluginInfo=
{
    PLUGINVER,
    VIDEOPLUGIN,
    "Custom bright scanlines",
    "ElSemi",
    "http://nebula.emulatronia.com",
    1,
    0,
	//VideoInterface
    SUPPORTS16BIT,
	Init,
	SetWidth,
	SetHeight,
	Blit,
    Configure,
    Terminate
};


struct _PluginInfo __declspec(dllexport) * __cdecl GetInterface()
{
	return &PluginInfo;
}
