#include "deflateInterface.h"
#include "zlib.h"

//#define INBUFSIZ   1024         /* ̓obt@TCYiCӁj */
//#define OUTBUFSIZ  1024         /* o̓obt@TCYiCӁj */
#define INBUFSIZ   128         /* ̓obt@TCYiCӁj */
#define OUTBUFSIZ  1024         /* o̓obt@TCYiCӁj */


int do_compress_m2m(char *pIn,int nInSize,char *pOut,int nOutSize,int level)          /* k */
{
	int flush, status;
	z_stream z;                     /* CuƂƂ肷邽߂̍\ */

	char *pI = pIn;
	char *pO = pOut;
	int nUsedSizeIn  = 0;
	int nUsedSizeOut = 0;

	if((level < 0) || (9 < level))	level = 6;
	if(nOutSize < 0)	return DZEXR_OUTBUFFERROR;

    /* ׂẴǗOōs */
    z.zalloc = Z_NULL;
    z.zfree  = Z_NULL;
    z.opaque = Z_NULL;

    /*  */
    /* 2͈k̓xB0`9 ͈̔͂̐ŁC0 ͖k */
    if (deflateInit(&z, level) != Z_OK){return DZEXR_INITERROR;}

    z.avail_in  = 0;            /* ̓obt@̃f[^̃oCg */
    z.next_out  = pO;           /* o̓|C^ */
    z.avail_out = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut;    /* o̓obt@̃TCY */
	pO           += z.avail_out;
	nUsedSizeOut += z.avail_out;

    /* ʏ deflate() ̑2 Z_NO_FLUSH ɂČĂяo */
    flush = Z_NO_FLUSH;

    while(1)
	{
        if (z.avail_in == 0)
		{  /* ͂s */
            z.next_in  = pI;  /* ̓|C^̓obt@̐擪 */
            z.avail_in = (nInSize - nUsedSizeIn >= INBUFSIZ) ? INBUFSIZ : nInSize - nUsedSizeIn;	/* f[^ǂݍ */
			pI          += z.avail_in;
			nUsedSizeIn += z.avail_in;

            /* ͂ŌɂȂ deflate() ̑2 Z_FINISH ɂ */
            if (z.avail_in < INBUFSIZ) flush = Z_FINISH;
        }
        status = deflate(&z, flush); /* k */

        /* s󋵕\ */
        //psp_progress(nUsedSizeIn,nInSize,0x001f<<10);
        
        if (status == Z_STREAM_END) break; /*  */
        if (status != Z_OK) {   /* G[ */
            return DZEXR_DEFLATEERROR;
        }
        if (z.avail_out == 0)
		{ /* o̓obt@s */
            z.next_out  = pO;        /* o̓|C^ɖ߂ */
            z.avail_out = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut; /* o̓obt@cʂɖ߂ */
			pO           += z.avail_out;
			nUsedSizeOut += z.avail_out;

			if(z.avail_out == 0)	return DZEXR_OUTBUFFERROR;
        }
    }

    /* cfo */
    nUsedSizeOut -= z.avail_out;

    /* n */
    if (deflateEnd(&z) != Z_OK)
	{
        return DZEXR_DEFLATEERROR;
    }

	return nUsedSizeOut;
}

int do_decompress_m2m(char *pIn,int nInSize,char *pOut,int nOutSize)        /* WJij */
{
	int status;
	z_stream z;                     /* CuƂƂ肷邽߂̍\ */

	char *pI = pIn;
	char *pO = pOut;
	int nUsedSizeIn  = 0;
	int nUsedSizeOut = 0;

	if(nOutSize < 0)	return DZEXR_OUTBUFFERROR;

   /* ׂẴǗOōs */
    z.zalloc = Z_NULL;
    z.zfree  = Z_NULL;
    z.opaque = Z_NULL;

    /*  */
    z.next_in  = Z_NULL;
    z.avail_in = 0;
    if (inflateInit(&z) != Z_OK){return DZEXR_INITERROR;}

    z.next_out  = pO;           /* o̓|C^ */
    z.avail_out = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut;    /* o̓obt@c */
 	pO           += z.avail_out;
	nUsedSizeOut += z.avail_out;
    status = Z_OK;

    while (status != Z_STREAM_END)
	{
        if (z.avail_in == 0)
		{  /* ͎cʂ[ɂȂ */
            z.next_in  = pI;  /* ̓|C^ɖ߂ */
            z.avail_in = (nInSize - nUsedSizeIn >= INBUFSIZ) ? INBUFSIZ : nInSize - nUsedSizeIn;	/* f[^ǂݍ */
			pI          += z.avail_in;
			nUsedSizeIn += z.avail_in;
        }
        status = inflate(&z, Z_NO_FLUSH); /* WJ */

        /* s󋵕\ */
        //psp_progress(nUsedSizeIn,nInSize,0x1f<<8);
        
        if (status == Z_STREAM_END) break; /*  */
        if (status != Z_OK)
		{   /* G[ */
            return DZEXR_INFLATEERROR;
        }
        if (z.avail_out == 0)
		{ /* o̓obt@s */
            z.next_out    = pO;        /* o̓|C^ɖ߂ */
            z.avail_out   = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut; /* o̓obt@cʂɖ߂ */
			pO           += z.avail_out;
			nUsedSizeOut += z.avail_out;

			if(z.avail_out == 0)	return DZEXR_OUTBUFFERROR;
        }
    }

    /* cfo */
    nUsedSizeOut -= z.avail_out;

    /* n */
    if (inflateEnd(&z) != Z_OK)
	{
        return DZEXR_INFLATEERROR;
    }

	return nUsedSizeOut;
}


